/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.datastreams.lifecycle.action.ExplainDataStreamLifecycleAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestChunkedToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestExplainDataStreamLifecycleAction
extends BaseRestHandler {
    public String getName() {
        return "data_stream_lifecycle_explain_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_lifecycle/explain"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray((String)restRequest.param("index"));
        ExplainDataStreamLifecycleAction.Request explainRequest = new ExplainDataStreamLifecycleAction.Request(indices);
        explainRequest.includeDefaults(restRequest.paramAsBoolean("include_defaults", false));
        explainRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)IndicesOptions.strictExpandOpen()));
        String masterNodeTimeout = restRequest.param("master_timeout");
        if (masterNodeTimeout != null) {
            explainRequest.masterNodeTimeout(masterNodeTimeout);
        }
        return channel -> client.execute((ActionType)ExplainDataStreamLifecycleAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)new RestChunkedToXContentListener(channel));
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }
}

