/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.PromoteDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class PromoteDataStreamTransportAction
extends AcknowledgedTransportMasterNodeAction<PromoteDataStreamAction.Request> {
    private final SystemIndices systemIndices;

    @Inject
    public PromoteDataStreamTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/data_stream/promote", transportService, clusterService, threadPool, actionFilters, PromoteDataStreamAction.Request::new, indexNameExpressionResolver, "same");
        this.systemIndices = systemIndices;
    }

    protected void masterOperation(Task task, final PromoteDataStreamAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.systemIndices.validateDataStreamAccess(request.getName(), this.threadPool.getThreadContext());
        this.submitUnbatchedTask("promote-data-stream [" + request.getName() + "]", new ClusterStateUpdateTask(Priority.HIGH, request.masterNodeTimeout()){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public ClusterState execute(ClusterState currentState) {
                return PromoteDataStreamTransportAction.promoteDataStream(currentState, request);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState promoteDataStream(ClusterState currentState, PromoteDataStreamAction.Request request) {
        DataStream dataStream = (DataStream)currentState.getMetadata().dataStreams().get(request.getName());
        if (dataStream == null) {
            throw new ResourceNotFoundException("data stream [" + request.getName() + "] does not exist", new Object[0]);
        }
        DataStream promotedDataStream = dataStream.promoteDataStream();
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        metadata.put(promotedDataStream);
        return ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
    }

    protected ClusterBlockException checkBlock(PromoteDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

