/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.datastreams.action.DataStreamsActionUtil;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DeleteDataStreamTransportAction
extends AcknowledgedTransportMasterNodeAction<DeleteDataStreamAction.Request> {
    private static final Logger LOGGER = LogManager.getLogger(DeleteDataStreamTransportAction.class);
    private final MetadataDeleteIndexService deleteIndexService;
    private final SystemIndices systemIndices;

    @Inject
    public DeleteDataStreamTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDeleteIndexService deleteIndexService, SystemIndices systemIndices) {
        super("indices:admin/data_stream/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataStreamAction.Request::new, indexNameExpressionResolver, "same");
        this.deleteIndexService = deleteIndexService;
        this.systemIndices = systemIndices;
    }

    protected void masterOperation(Task task, final DeleteDataStreamAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        List<String> names = DataStreamsActionUtil.getDataStreamNames(this.indexNameExpressionResolver, state, request.getNames(), request.indicesOptions());
        for (String name : names) {
            this.systemIndices.validateDataStreamAccess(name, this.threadPool.getThreadContext());
        }
        this.submitUnbatchedTask("remove-data-stream [" + Strings.arrayToCommaDelimitedString((Object[])request.getNames()) + "]", new ClusterStateUpdateTask(Priority.HIGH, request.masterNodeTimeout()){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public ClusterState execute(ClusterState currentState) {
                return DeleteDataStreamTransportAction.removeDataStream(DeleteDataStreamTransportAction.this.deleteIndexService, DeleteDataStreamTransportAction.this.indexNameExpressionResolver, currentState, request, ds -> DeleteDataStreamTransportAction.this.systemIndices.validateDataStreamAccess(ds, DeleteDataStreamTransportAction.this.threadPool.getThreadContext()));
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState removeDataStream(MetadataDeleteIndexService deleteIndexService, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState currentState, DeleteDataStreamAction.Request request, Consumer<String> systemDataStreamAccessValidator) {
        List<String> names = DataStreamsActionUtil.getDataStreamNames(indexNameExpressionResolver, currentState, request.getNames(), request.indicesOptions());
        HashSet<String> dataStreams = new HashSet<String>(names);
        for (String dataStreamName : dataStreams) {
            systemDataStreamAccessValidator.accept(dataStreamName);
        }
        Set snapshottingDataStreams = SnapshotsService.snapshottingDataStreams((ClusterState)currentState, dataStreams);
        if (dataStreams.isEmpty()) {
            if (request.isWildcardExpressionsOriginallySpecified()) {
                return currentState;
            }
            throw new ResourceNotFoundException("data streams " + Arrays.toString(request.getNames()) + " not found", new Object[0]);
        }
        if (!snapshottingDataStreams.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete data streams that are being snapshotted: " + snapshottingDataStreams + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        HashSet backingIndicesToRemove = new HashSet();
        for (String dataStreamName : dataStreams) {
            DataStream dataStream = (DataStream)currentState.metadata().dataStreams().get(dataStreamName);
            assert (dataStream != null);
            backingIndicesToRemove.addAll(dataStream.getIndices());
        }
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        for (String ds : dataStreams) {
            LOGGER.info("removing data stream [{}]", (Object)ds);
            metadata.removeDataStream(ds);
        }
        currentState = ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
        return deleteIndexService.deleteIndices(currentState, backingIndicesToRemove);
    }

    protected ClusterBlockException checkBlock(DeleteDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

