/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DataStreamsStatsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.datastreams.action.DataStreamsActionUtil;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class DataStreamsStatsTransportAction
extends TransportBroadcastByNodeAction<DataStreamsStatsAction.Request, DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats> {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public DataStreamsStatsTransportAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/data_stream/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, DataStreamsStatsAction.Request::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, DataStreamsStatsAction.Request request, ActionListener<DataStreamsStatsAction.Response> listener) {
        request.indicesOptions(DataStreamsActionUtil.updateIndicesOptions(request.indicesOptions()));
        super.doExecute(task, (BroadcastRequest)request, listener);
    }

    protected DataStreamsStatsAction.Request readRequestFrom(StreamInput in) throws IOException {
        return new DataStreamsStatsAction.Request(in);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, DataStreamsStatsAction.Request request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, DataStreamsStatsAction.Request request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    protected String[] resolveConcreteIndexNames(ClusterState clusterState, DataStreamsStatsAction.Request request) {
        List abstractionNames = this.indexNameExpressionResolver.dataStreamNames(clusterState, request.indicesOptions(), request.indices());
        SortedMap indicesLookup = clusterState.getMetadata().getIndicesLookup();
        String[] concreteDatastreamIndices = (String[])abstractionNames.stream().flatMap(abstractionName -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(abstractionName);
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
                DataStream dataStream = (DataStream)indexAbstraction;
                List indices = dataStream.getIndices();
                return indices.stream().map(Index::getName);
            }
            return Stream.empty();
        }).toArray(String[]::new);
        return concreteDatastreamIndices;
    }

    protected ShardsIterator shards(ClusterState clusterState, DataStreamsStatsAction.Request request, String[] concreteIndices) {
        return clusterState.getRoutingTable().allShards(concreteIndices);
    }

    protected void shardOperation(DataStreamsStatsAction.Request request, ShardRouting shardRouting, Task task, ActionListener<DataStreamsStatsAction.DataStreamShardStats> listener) {
        ActionListener.completeWith(listener, () -> {
            IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
            IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
            StoreStats storeStats = indexShard.storeStats();
            IndexAbstraction indexAbstraction = (IndexAbstraction)this.clusterService.state().getMetadata().getIndicesLookup().get(shardRouting.getIndexName());
            assert (indexAbstraction != null);
            DataStream dataStream = indexAbstraction.getParentDataStream();
            assert (dataStream != null);
            long maxTimestamp = 0L;
            try (Engine.Searcher searcher = indexShard.acquireSearcher("data_stream_stats");){
                IndexReader indexReader = searcher.getIndexReader();
                byte[] maxPackedValue = PointValues.getMaxPackedValue((IndexReader)indexReader, (String)"@timestamp");
                if (maxPackedValue != null) {
                    maxTimestamp = LongPoint.decodeDimension((byte[])maxPackedValue, (int)0);
                }
            }
            return new DataStreamsStatsAction.DataStreamShardStats(indexShard.routingEntry(), storeStats, maxTimestamp);
        });
    }

    protected DataStreamsStatsAction.DataStreamShardStats readShardResult(StreamInput in) throws IOException {
        return new DataStreamsStatsAction.DataStreamShardStats(in);
    }

    protected TransportBroadcastByNodeAction.ResponseFactory<DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats> getResponseFactory(DataStreamsStatsAction.Request request, ClusterState clusterState) {
        HashMap<String, AggregatedStats> aggregatedDataStreamsStats = new HashMap<String, AggregatedStats>();
        HashSet<String> allBackingIndices = new HashSet<String>();
        SortedMap indicesLookup = clusterState.getMetadata().getIndicesLookup();
        List abstractionNames = this.indexNameExpressionResolver.dataStreamNames(clusterState, request.indicesOptions(), request.indices());
        for (String abstractionName : abstractionNames) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(abstractionName);
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) continue;
            DataStream dataStream = (DataStream)indexAbstraction;
            AggregatedStats stats = aggregatedDataStreamsStats.computeIfAbsent(dataStream.getName(), s -> new AggregatedStats());
            dataStream.getIndices().stream().map(Index::getName).forEach(index -> {
                stats.backingIndices.add((String)index);
                allBackingIndices.add((String)index);
            });
        }
        return new ResponseFactory(indicesLookup, allBackingIndices, aggregatedDataStreamsStats);
    }

    private static class AggregatedStats {
        Set<String> backingIndices = new HashSet<String>();
        long storageBytes = 0L;
        long maxTimestamp = 0L;

        private AggregatedStats() {
        }
    }

    private class ResponseFactory
    implements TransportBroadcastByNodeAction.ResponseFactory<DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats> {
        private final SortedMap<String, IndexAbstraction> indicesLookup;
        private final Set<String> allBackingIndices;
        private final Map<String, AggregatedStats> aggregatedDataStreamsStats;

        ResponseFactory(SortedMap<String, IndexAbstraction> indicesLookup, Set<String> allBackingIndices, Map<String, AggregatedStats> aggregatedDataStreamsStats) {
            this.indicesLookup = indicesLookup;
            this.allBackingIndices = allBackingIndices;
            this.aggregatedDataStreamsStats = aggregatedDataStreamsStats;
        }

        public DataStreamsStatsAction.Response newResponse(int totalShards, int successfulShards, int failedShards, List<DataStreamsStatsAction.DataStreamShardStats> dataStreamShardStats, List<DefaultShardOperationFailedException> shardFailures) {
            long totalStoreSizeBytes = 0L;
            for (DataStreamsStatsAction.DataStreamShardStats shardStat : dataStreamShardStats) {
                String indexName = shardStat.getShardRouting().getIndexName();
                IndexAbstraction indexAbstraction = (IndexAbstraction)this.indicesLookup.get(indexName);
                DataStream dataStream = indexAbstraction.getParentDataStream();
                assert (dataStream != null);
                totalStoreSizeBytes += shardStat.getStoreStats().sizeInBytes();
                AggregatedStats stats = this.aggregatedDataStreamsStats.computeIfAbsent(dataStream.getName(), s -> new AggregatedStats());
                stats.storageBytes += shardStat.getStoreStats().sizeInBytes();
                stats.maxTimestamp = Math.max(stats.maxTimestamp, shardStat.getMaxTimestamp());
            }
            DataStreamsStatsAction.DataStreamStats[] dataStreamStats = (DataStreamsStatsAction.DataStreamStats[])this.aggregatedDataStreamsStats.entrySet().stream().map(entry -> new DataStreamsStatsAction.DataStreamStats((String)entry.getKey(), ((AggregatedStats)entry.getValue()).backingIndices.size(), ByteSizeValue.ofBytes((long)((AggregatedStats)entry.getValue()).storageBytes), ((AggregatedStats)entry.getValue()).maxTimestamp)).toArray(DataStreamsStatsAction.DataStreamStats[]::new);
            return new DataStreamsStatsAction.Response(totalShards, successfulShards, failedShards, shardFailures, this.aggregatedDataStreamsStats.size(), this.allBackingIndices.size(), ByteSizeValue.ofBytes((long)totalStoreSizeBytes), dataStreamStats);
        }
    }
}

