/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapChecks;
import co.elastic.apm.agent.premain.ShadedClassLoader;
import co.elastic.apm.agent.premain.common.JvmRuntimeInfo;
import co.elastic.apm.agent.premain.common.ThreadUtils;
import co.elastic.apm.agent.premain.common.util.SystemStandardOutputLogger;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class AgentMain {
    private static ClassLoader lookupKeyClassLoader;
    private static URLClassLoader agentClassLoader;

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        AgentMain.init(agentArguments, instrumentation, true);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) {
        AgentMain.init(agentArguments, instrumentation, false);
    }

    public static synchronized void init(String agentArguments, Instrumentation instrumentation, boolean premain) {
        AgentMain.securityManagerCheck();
        if (Boolean.getBoolean("ElasticApm.attached")) {
            return;
        }
        if (!BootstrapChecks.defaults().isPassing()) {
            return;
        }
        FileSystems.getDefault();
        long delayAgentInitMs = -1L;
        String delayAgentInitMsProperty = System.getProperty("elastic.apm.delay_agent_premain_ms");
        if (delayAgentInitMsProperty != null) {
            try {
                delayAgentInitMs = Long.parseLong(delayAgentInitMsProperty.trim());
            }
            catch (NumberFormatException numberFormatException) {
                SystemStandardOutputLogger.stdErrWarn("The value of the \"elastic.apm.delay_agent_premain_ms\" System property must be a number");
            }
        }
        if (premain && AgentMain.shouldDelayOnPremain()) {
            delayAgentInitMs = Math.max(delayAgentInitMs, 3000L);
        }
        if (delayAgentInitMs > 0L) {
            AgentMain.delayAndInitAgentAsync(agentArguments, instrumentation, premain, delayAgentInitMs);
        } else {
            String startAgentAsyncProperty = System.getProperty("elastic.apm.start_async");
            if (startAgentAsyncProperty != null) {
                AgentMain.delayAndInitAgentAsync(agentArguments, instrumentation, premain, 0L);
            } else {
                AgentMain.loadAndInitializeAgent(agentArguments, instrumentation, premain);
            }
        }
    }

    static boolean shouldDelayOnPremain() {
        JvmRuntimeInfo runtimeInfo = JvmRuntimeInfo.ofCurrentVM();
        int majorVersion = runtimeInfo.getMajorVersion();
        return majorVersion == 7 || majorVersion == 8 && runtimeInfo.isHotSpot() && runtimeInfo.getUpdateVersion() < 2 || majorVersion == 8 && runtimeInfo.isHotSpot() && runtimeInfo.getUpdateVersion() < 40;
    }

    private static void delayAndInitAgentAsync(final String agentArguments, final Instrumentation instrumentation, final boolean premain, final long delayAgentInitMs) {
        SystemStandardOutputLogger.stdOutInfo("Delaying Elastic APM Agent initialization by " + delayAgentInitMs + " milliseconds.");
        Thread initThread = new Thread(ThreadUtils.addElasticApmThreadPrefix("agent-initialization")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Class<AgentMain> clazz = AgentMain.class;
                    synchronized (AgentMain.class) {
                        if (delayAgentInitMs > 0L) {
                            Thread.sleep(delayAgentInitMs);
                        }
                        AgentMain.loadAndInitializeAgent(agentArguments, instrumentation, premain);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                catch (InterruptedException e) {
                    SystemStandardOutputLogger.stdErrError(this.getName() + " thread was interrupted, the agent will not be attached to this JVM.");
                    SystemStandardOutputLogger.printStackTrace(e);
                }
                catch (Throwable throwable) {
                    SystemStandardOutputLogger.stdErrError("Elastic APM Agent initialization failed: " + throwable.getMessage());
                    SystemStandardOutputLogger.printStackTrace(throwable);
                }
                {
                    return;
                }
            }
        };
        initThread.setDaemon(true);
        initThread.start();
    }

    private static synchronized void loadAndInitializeAgent(String agentArguments, Instrumentation instrumentation, boolean premain) {
        try {
            File agentJar = AgentMain.getAgentJarFile();
            if (lookupKeyClassLoader == null) {
                lookupKeyClassLoader = new ShadedClassLoader(agentJar, AgentMain.getAgentClassLoaderParent(), "cached-lookup-key/");
            }
            agentClassLoader = new ShadedClassLoader(agentJar, lookupKeyClassLoader, "agent/");
            Class.forName("co.elastic.apm.agent.bci.ElasticApmAgent", true, agentClassLoader).getMethod("initialize", String.class, Instrumentation.class, File.class, Boolean.TYPE).invoke(null, agentArguments, instrumentation, agentJar, premain);
            System.setProperty("ElasticApm.attached", Boolean.TRUE.toString());
        }
        catch (Exception | LinkageError e) {
            SystemStandardOutputLogger.stdErrError("Failed to start agent");
            SystemStandardOutputLogger.printStackTrace(e);
        }
    }

    private static void securityManagerCheck() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        try {
            sm.checkPermission(new AllPermission());
        }
        catch (SecurityException e) {
            SystemStandardOutputLogger.stdErrWarn("Security manager without agent grant-all permission, adding the following snippet to security policy is recommended:");
            SystemStandardOutputLogger.stdErrWarn("grant codeBase \"file:/path/to/elastic-apm-agent.jar\" {");
            SystemStandardOutputLogger.stdErrWarn("    permission java.security.AllPermission;");
            SystemStandardOutputLogger.stdErrWarn("};");
        }
    }

    private static synchronized void detach() {
        try {
            if (Boolean.getBoolean("ElasticApm.attached") || agentClassLoader == null) {
                throw new IllegalStateException("Agent is not initialized");
            }
            Class.forName("co.elastic.apm.agent.bci.ElasticApmAgent", true, agentClassLoader).getMethod("reset", new Class[0]).invoke(null, new Object[0]);
            agentClassLoader.close();
            agentClassLoader = null;
            System.setProperty("ElasticApm.attached", Boolean.FALSE.toString());
        }
        catch (Exception e) {
            SystemStandardOutputLogger.stdErrError("ERROR Failed to detach agent");
            SystemStandardOutputLogger.printStackTrace(e);
        }
    }

    private static ClassLoader getAgentClassLoaderParent() {
        try {
            return (ClassLoader)ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static File getAgentJarFile() throws URISyntaxException {
        ProtectionDomain protectionDomain = AgentMain.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            throw new IllegalStateException(String.format("Unable to get agent location, protection domain = %s", protectionDomain));
        }
        URL location = codeSource.getLocation();
        if (location == null) {
            throw new IllegalStateException(String.format("Unable to get agent location, code source = %s", codeSource));
        }
        File agentJar = new File(location.toURI());
        if (!agentJar.getName().endsWith(".jar")) {
            throw new IllegalStateException("Agent is not a jar file: " + agentJar);
        }
        return agentJar.getAbsoluteFile();
    }
}

