/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.metric;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.aggregations.metric.RunningStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.support.SamplingContext;

class MatrixStatsResults
implements Writeable {
    protected final RunningStats results;
    protected final Map<String, HashMap<String, Double>> correlation;

    MatrixStatsResults() {
        this.results = new RunningStats();
        this.correlation = new HashMap<String, HashMap<String, Double>>();
    }

    MatrixStatsResults(RunningStats stats) {
        this.results = stats.clone();
        this.correlation = new HashMap<String, HashMap<String, Double>>();
        this.compute();
    }

    MatrixStatsResults(RunningStats stats, SamplingContext samplingContext) {
        this.results = stats.clone();
        this.correlation = new HashMap<String, HashMap<String, Double>>();
        this.compute();
        this.results.docCount = samplingContext.scaleUp(this.results.docCount);
        for (String field : this.results.counts.keySet()) {
            this.results.counts.computeIfPresent(field, (k, v) -> samplingContext.scaleUp(v.longValue()));
        }
    }

    protected MatrixStatsResults(StreamInput in) {
        try {
            this.results = new RunningStats(in);
            this.correlation = (Map)in.readGenericValue();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error trying to create multifield_stats results from stream input", (Throwable)e, new Object[0]);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.results.writeTo(out);
        out.writeGenericValue(this.correlation);
    }

    public final long getDocCount() {
        return this.results.docCount;
    }

    protected Map<String, Long> getFieldCounts() {
        return Collections.unmodifiableMap(this.results.counts);
    }

    public long getFieldCount(String field) {
        if (!this.results.counts.containsKey(field)) {
            return 0L;
        }
        return this.results.counts.get(field);
    }

    protected Map<String, Double> getMeans() {
        return Collections.unmodifiableMap(this.results.means);
    }

    public double getMean(String field) {
        this.checkField(field, this.results.means);
        return this.results.means.get(field);
    }

    protected Map<String, Double> getVariances() {
        return Collections.unmodifiableMap(this.results.variances);
    }

    public double getVariance(String field) {
        this.checkField(field, this.results.variances);
        return this.results.variances.get(field);
    }

    protected Map<String, Double> getSkewness() {
        return Collections.unmodifiableMap(this.results.skewness);
    }

    public double getSkewness(String field) {
        this.checkField(field, this.results.skewness);
        return this.results.skewness.get(field);
    }

    protected Map<String, Double> getKurtosis() {
        return Collections.unmodifiableMap(this.results.kurtosis);
    }

    public double getKurtosis(String field) {
        this.checkField(field, this.results.kurtosis);
        return this.results.kurtosis.get(field);
    }

    protected Map<String, HashMap<String, Double>> getCovariances() {
        return Collections.unmodifiableMap(this.results.covariances);
    }

    public double getCovariance(String fieldX, String fieldY) {
        if (fieldX.equals(fieldY)) {
            this.checkField(fieldX, this.results.variances);
            return this.results.variances.get(fieldX);
        }
        return MatrixStatsResults.getValFromUpperTriangularMatrix(this.results.covariances, fieldX, fieldY);
    }

    protected Map<String, HashMap<String, Double>> getCorrelations() {
        return Collections.unmodifiableMap(this.correlation);
    }

    public Double getCorrelation(String fieldX, String fieldY) {
        if (fieldX.equals(fieldY)) {
            return 1.0;
        }
        return MatrixStatsResults.getValFromUpperTriangularMatrix(this.correlation, fieldX, fieldY);
    }

    static <M extends Map<String, Double>> double getValFromUpperTriangularMatrix(Map<String, M> map, String fieldX, String fieldY) {
        if (!map.containsKey(fieldX) && !map.containsKey(fieldY)) {
            throw new IllegalArgumentException("neither field " + fieldX + " nor " + fieldY + " exist");
        }
        if (map.containsKey(fieldX)) {
            if (((Map)map.get(fieldX)).containsKey(fieldY)) {
                return (Double)((Map)map.get(fieldX)).get(fieldY);
            }
            return (Double)((Map)map.get(fieldY)).get(fieldX);
        }
        if (map.containsKey(fieldY)) {
            return (Double)((Map)map.get(fieldY)).get(fieldX);
        }
        throw new IllegalArgumentException("Coefficient not computed between fields: " + fieldX + " and " + fieldY);
    }

    private void checkField(String field, Map<String, ?> map) {
        if (field == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        if (!map.containsKey(field)) {
            throw new IllegalArgumentException("field " + field + " does not exist");
        }
    }

    private void compute() {
        double nM1 = (double)this.results.docCount - 1.0;
        for (String fieldName : this.results.means.keySet()) {
            double var = this.results.variances.get(fieldName);
            this.results.skewness.put(fieldName, Math.sqrt(this.results.docCount) * this.results.skewness.get(fieldName) / Math.pow(var, 1.5));
            this.results.kurtosis.put(fieldName, (double)this.results.docCount * this.results.kurtosis.get(fieldName) / (var * var));
            this.results.variances.put(fieldName, this.results.variances.get(fieldName) / nM1);
        }
        for (Map.Entry<String, HashMap<String, Double>> row : this.results.covariances.entrySet()) {
            String rowName = row.getKey();
            HashMap<String, Double> covRow = row.getValue();
            HashMap<String, Double> corRow = new HashMap<String, Double>();
            for (Map.Entry<String, Double> col : covRow.entrySet()) {
                double cor;
                String colName = col.getKey();
                covRow.put(colName, covRow.get(colName) / nM1);
                if (this.results.variances.get(rowName) == 0.0 || this.results.variances.get(colName) == 0.0) {
                    cor = Double.NaN;
                } else {
                    double corDen = Math.sqrt(this.results.variances.get(rowName)) * Math.sqrt(this.results.variances.get(colName));
                    cor = covRow.get(colName) / corDen;
                }
                corRow.put(colName, cor);
            }
            this.results.covariances.put(rowName, covRow);
            this.correlation.put(rowName, corRow);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixStatsResults that = (MatrixStatsResults)o;
        return Objects.equals(this.results, that.results) && Objects.equals(this.correlation, that.correlation);
    }

    public int hashCode() {
        return Objects.hash(this.results, this.correlation);
    }
}

