/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.elasticsearch.core.RefCounted;

public abstract class AbstractRefCounted
implements RefCounted {
    public static final String ALREADY_CLOSED_MESSAGE = "already closed, can't increment ref count";
    private static final VarHandle VH_REFCOUNT_FIELD;
    private volatile int refCount = 1;

    protected AbstractRefCounted() {
    }

    @Override
    public final void incRef() {
        if (!this.tryIncRef()) {
            this.alreadyClosed();
        }
    }

    @Override
    public final boolean tryIncRef() {
        int i;
        while ((i = this.refCount) > 0) {
            if (!VH_REFCOUNT_FIELD.weakCompareAndSet(this, i, i + 1)) continue;
            this.touch();
            return true;
        }
        return false;
    }

    @Override
    public final boolean decRef() {
        this.touch();
        int i = VH_REFCOUNT_FIELD.getAndAdd(this, -1);
        assert (i > 0) : "invalid decRef call: already closed";
        if (i == 1) {
            try {
                this.closeInternal();
            }
            catch (Exception e) {
                assert (false) : e;
                throw e;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasReferences() {
        return this.refCount > 0;
    }

    protected void touch() {
    }

    protected void alreadyClosed() {
        int currentRefCount = this.refCount;
        assert (currentRefCount == 0) : currentRefCount;
        throw new IllegalStateException(ALREADY_CLOSED_MESSAGE);
    }

    public final int refCount() {
        return this.refCount;
    }

    protected abstract void closeInternal();

    public static AbstractRefCounted of(final Runnable onClose) {
        Objects.requireNonNull(onClose);
        return new AbstractRefCounted(){

            @Override
            protected void closeInternal() {
                onClose.run();
            }

            public String toString() {
                return "refCounted[" + onClose + "]";
            }
        };
    }

    static {
        try {
            VH_REFCOUNT_FIELD = MethodHandles.lookup().in(AbstractRefCounted.class).findVarHandle(AbstractRefCounted.class, "refCount", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

