/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.WatcherHandle;

public class ResourceWatcherService
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ResourceWatcherService.class);
    public static final Setting<Boolean> ENABLED = Setting.boolSetting("resource.reload.enabled", true, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RELOAD_INTERVAL_HIGH = Setting.timeSetting("resource.reload.interval.high", Frequency.HIGH.interval, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RELOAD_INTERVAL_MEDIUM = Setting.timeSetting("resource.reload.interval.medium", Setting.timeSetting("resource.reload.interval", Frequency.MEDIUM.interval, new Setting.Property[0]), Setting.Property.NodeScope);
    public static final Setting<TimeValue> RELOAD_INTERVAL_LOW = Setting.timeSetting("resource.reload.interval.low", Frequency.LOW.interval, Setting.Property.NodeScope);
    private final boolean enabled;
    final ResourceMonitor lowMonitor;
    final ResourceMonitor mediumMonitor;
    final ResourceMonitor highMonitor;
    private final Scheduler.Cancellable lowFuture;
    private final Scheduler.Cancellable mediumFuture;
    private final Scheduler.Cancellable highFuture;

    public ResourceWatcherService(Settings settings, ThreadPool threadPool) {
        this.enabled = ENABLED.get(settings);
        TimeValue interval = RELOAD_INTERVAL_LOW.get(settings);
        this.lowMonitor = new ResourceMonitor(interval, Frequency.LOW);
        interval = RELOAD_INTERVAL_MEDIUM.get(settings);
        this.mediumMonitor = new ResourceMonitor(interval, Frequency.MEDIUM);
        interval = RELOAD_INTERVAL_HIGH.get(settings);
        this.highMonitor = new ResourceMonitor(interval, Frequency.HIGH);
        if (this.enabled) {
            this.lowFuture = threadPool.scheduleWithFixedDelay(this.lowMonitor, this.lowMonitor.interval, "generic");
            this.mediumFuture = threadPool.scheduleWithFixedDelay(this.mediumMonitor, this.mediumMonitor.interval, "generic");
            this.highFuture = threadPool.scheduleWithFixedDelay(this.highMonitor, this.highMonitor.interval, "generic");
        } else {
            this.lowFuture = null;
            this.mediumFuture = null;
            this.highFuture = null;
        }
    }

    @Override
    public void close() {
        if (this.enabled) {
            this.lowFuture.cancel();
            this.mediumFuture.cancel();
            this.highFuture.cancel();
        }
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) throws IOException {
        return this.add(watcher, Frequency.MEDIUM);
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher, Frequency frequency) throws IOException {
        watcher.init();
        return switch (frequency) {
            default -> throw new IncompatibleClassChangeError();
            case Frequency.LOW -> this.lowMonitor.add(watcher);
            case Frequency.MEDIUM -> this.mediumMonitor.add(watcher);
            case Frequency.HIGH -> this.highMonitor.add(watcher);
        };
    }

    public void notifyNow(Frequency frequency) {
        switch (frequency) {
            case LOW: {
                this.lowMonitor.run();
                break;
            }
            case MEDIUM: {
                this.mediumMonitor.run();
                break;
            }
            case HIGH: {
                this.highMonitor.run();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frequency [" + frequency + "]");
            }
        }
    }

    static class ResourceMonitor
    implements Runnable {
        final TimeValue interval;
        final Frequency frequency;
        final Set<ResourceWatcher> watchers = new CopyOnWriteArraySet<ResourceWatcher>();

        private ResourceMonitor(TimeValue interval, Frequency frequency) {
            this.interval = interval;
            this.frequency = frequency;
        }

        private <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) {
            this.watchers.add(watcher);
            return new WatcherHandle<W>(this, watcher);
        }

        @Override
        public synchronized void run() {
            for (ResourceWatcher watcher : this.watchers) {
                try {
                    watcher.checkAndNotify();
                }
                catch (IOException e) {
                    logger.trace("failed to check resource watcher", (Throwable)e);
                }
            }
        }
    }

    public static enum Frequency {
        HIGH(TimeValue.timeValueSeconds((long)5L)),
        MEDIUM(TimeValue.timeValueSeconds((long)30L)),
        LOW(TimeValue.timeValueSeconds((long)60L));

        final TimeValue interval;

        private Frequency(TimeValue interval) {
            this.interval = interval;
        }
    }
}

