/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class CancellableTasksTracker<T> {
    private final T[] empty;
    private final Map<Long, T> byTaskId = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final Map<TaskId, Map<Long, T[]>> byParentTaskId = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public CancellableTasksTracker(T[] empty) {
        assert (empty.length == 0);
        this.empty = empty;
    }

    public Stream<T> getChildrenByRequestId(TaskId parentTaskId, long childRequestId) {
        T[] children;
        Map<Long, T[]> byRequestId = this.byParentTaskId.get(parentTaskId);
        if (byRequestId != null && (children = byRequestId.get(childRequestId)) != null) {
            return Arrays.stream(children);
        }
        return Stream.empty();
    }

    public void put(Task task, long requestId, T item) {
        long taskId = task.getId();
        if (task.getParentTaskId().isSet()) {
            this.byParentTaskId.compute(task.getParentTaskId(), (taskKey, oldRequestIdMap) -> {
                if (oldRequestIdMap == null) {
                    oldRequestIdMap = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
                }
                oldRequestIdMap.compute(requestId, (requestIdKey, oldValue) -> {
                    if (oldValue == null) {
                        oldValue = this.empty;
                    }
                    Object[] newValue = Arrays.copyOf(oldValue, ((Object[])oldValue).length + 1);
                    newValue[oldValue.length] = item;
                    return newValue;
                });
                return oldRequestIdMap;
            });
        }
        T oldItem = this.byTaskId.put(taskId, item);
        assert (oldItem == null) : "duplicate entry for task [" + taskId + "]";
    }

    public T get(long id) {
        return this.byTaskId.get(id);
    }

    public T remove(Task task) {
        long taskId = task.getId();
        Object oldItem = this.byTaskId.remove(taskId);
        if (oldItem != null && task.getParentTaskId().isSet()) {
            this.byParentTaskId.compute(task.getParentTaskId(), (taskKey, oldRequestIdMap) -> {
                if (oldRequestIdMap == null) {
                    return null;
                }
                for (Long requestId : oldRequestIdMap.keySet()) {
                    oldRequestIdMap.compute(requestId, (requestIdKey, oldValue) -> {
                        if (oldValue == null) {
                            return null;
                        }
                        if (((Object[])oldValue).length == 1) {
                            if (oldValue[0] == oldItem) {
                                return null;
                            }
                            return oldValue;
                        }
                        if (oldValue[0] == oldItem) {
                            return Arrays.copyOfRange(oldValue, 1, ((Object[])oldValue).length);
                        }
                        for (int i = 1; i < ((Object[])oldValue).length; ++i) {
                            if (oldValue[i] != oldItem) continue;
                            Object[] newValue = Arrays.copyOf(oldValue, ((Object[])oldValue).length - 1);
                            System.arraycopy(oldValue, i + 1, newValue, i, ((Object[])oldValue).length - i - 1);
                            return newValue;
                        }
                        return oldValue;
                    });
                }
                if (oldRequestIdMap.keySet().isEmpty()) {
                    return null;
                }
                return oldRequestIdMap;
            });
        }
        return oldItem;
    }

    public Collection<T> values() {
        return this.byTaskId.values();
    }

    public Stream<T> getByParent(TaskId parentTaskId) {
        Map<Long, T[]> byParent = this.byParentTaskId.get(parentTaskId);
        if (byParent == null) {
            return Stream.empty();
        }
        return byParent.values().stream().flatMap(Stream::of);
    }

    boolean assertConsistent() {
        assert (!this.byTaskId.isEmpty() || this.byParentTaskId.isEmpty());
        HashSet byTaskValues = new HashSet(this.byTaskId.values());
        this.byParentTaskId.values().forEach(byParentMap -> byParentMap.forEach((requestId, byParentArray) -> {
            assert (((Object[])byParentArray).length > 0);
            for (Object t : byParentArray) {
                assert (byTaskValues.contains(t));
            }
        }));
        return true;
    }
}

