/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.search.vectors.QueryVectorBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class KnnSearchBuilder
implements Writeable,
ToXContentFragment,
Rewriteable<KnnSearchBuilder> {
    private static final int NUM_CANDS_LIMIT = 10000;
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField K_FIELD = new ParseField("k", new String[0]);
    public static final ParseField NUM_CANDS_FIELD = new ParseField("num_candidates", new String[0]);
    public static final ParseField QUERY_VECTOR_FIELD = new ParseField("query_vector", new String[0]);
    public static final ParseField QUERY_VECTOR_BUILDER_FIELD = new ParseField("query_vector_builder", new String[0]);
    public static final ParseField VECTOR_SIMILARITY = new ParseField("similarity", new String[0]);
    public static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]);
    public static final ParseField BOOST_FIELD = AbstractQueryBuilder.BOOST_FIELD;
    private static final ConstructingObjectParser<KnnSearchBuilder, Void> PARSER = new ConstructingObjectParser("knn", args -> {
        float[] vectorArray;
        List vector = (List)args[1];
        if (vector != null) {
            vectorArray = new float[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                vectorArray[i] = ((Float)vector.get(i)).floatValue();
            }
        } else {
            vectorArray = null;
        }
        return new KnnSearchBuilder((String)args[0], vectorArray, (QueryVectorBuilder)args[4], (int)((Integer)args[2]), (Integer)args[3], (Float)args[5]);
    });
    final String field;
    final float[] queryVector;
    final QueryVectorBuilder queryVectorBuilder;
    private final Supplier<float[]> querySupplier;
    final int k;
    final int numCands;
    final Float similarity;
    final List<QueryBuilder> filterQueries;
    float boost = 1.0f;

    public static KnnSearchBuilder fromXContent(XContentParser parser) throws IOException {
        return (KnnSearchBuilder)PARSER.parse(parser, null);
    }

    public KnnSearchBuilder(String field, float[] queryVector, int k, int numCands, Float similarity) {
        this(field, Objects.requireNonNull(queryVector, Strings.format("[%s] cannot be null", QUERY_VECTOR_FIELD)), null, k, numCands, similarity);
    }

    public KnnSearchBuilder(String field, QueryVectorBuilder queryVectorBuilder, int k, int numCands, Float similarity) {
        this(field, null, Objects.requireNonNull(queryVectorBuilder, Strings.format("[%s] cannot be null", QUERY_VECTOR_BUILDER_FIELD.getPreferredName())), k, numCands, similarity);
    }

    private KnnSearchBuilder(String field, float[] queryVector, QueryVectorBuilder queryVectorBuilder, int k, int numCands, Float similarity) {
        if (k < 1) {
            throw new IllegalArgumentException("[" + K_FIELD.getPreferredName() + "] must be greater than 0");
        }
        if (numCands < k) {
            throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] cannot be less than [" + K_FIELD.getPreferredName() + "]");
        }
        if (numCands > 10000) {
            throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] cannot exceed [10000]");
        }
        if (queryVector == null && queryVectorBuilder == null) {
            throw new IllegalArgumentException(Strings.format("either [%s] or [%s] must be provided", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), QUERY_VECTOR_FIELD.getPreferredName()));
        }
        if (queryVector != null && queryVectorBuilder != null) {
            throw new IllegalArgumentException(Strings.format("cannot provide both [%s] and [%s]", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), QUERY_VECTOR_FIELD.getPreferredName()));
        }
        this.field = field;
        this.queryVector = queryVector == null ? new float[]{} : queryVector;
        this.queryVectorBuilder = queryVectorBuilder;
        this.k = k;
        this.numCands = numCands;
        this.filterQueries = new ArrayList<QueryBuilder>();
        this.querySupplier = null;
        this.similarity = similarity;
    }

    private KnnSearchBuilder(String field, Supplier<float[]> querySupplier, int k, int numCands, List<QueryBuilder> filterQueries, Float similarity) {
        this.field = field;
        this.queryVector = new float[0];
        this.queryVectorBuilder = null;
        this.k = k;
        this.numCands = numCands;
        this.filterQueries = filterQueries;
        this.querySupplier = querySupplier;
        this.similarity = similarity;
    }

    public KnnSearchBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.k = in.readVInt();
        this.numCands = in.readVInt();
        this.queryVector = in.readFloatArray();
        this.filterQueries = in.readNamedWriteableList(QueryBuilder.class);
        this.boost = in.readFloat();
        this.queryVectorBuilder = in.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0) ? in.readOptionalNamedWriteable(QueryVectorBuilder.class) : null;
        this.querySupplier = null;
        this.similarity = in.getTransportVersion().onOrAfter(TransportVersion.V_8_8_0) ? in.readOptionalFloat() : null;
    }

    public int k() {
        return this.k;
    }

    public QueryVectorBuilder getQueryVectorBuilder() {
        return this.queryVectorBuilder;
    }

    public float[] getQueryVector() {
        return this.queryVector;
    }

    public KnnSearchBuilder addFilterQuery(QueryBuilder filterQuery) {
        Objects.requireNonNull(filterQuery);
        this.filterQueries.add(filterQuery);
        return this;
    }

    public KnnSearchBuilder addFilterQueries(List<QueryBuilder> filterQueries) {
        Objects.requireNonNull(filterQueries);
        this.filterQueries.addAll(filterQueries);
        return this;
    }

    public KnnSearchBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public KnnSearchBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.querySupplier != null) {
            if (this.querySupplier.get() == null) {
                return this;
            }
            return new KnnSearchBuilder(this.field, this.querySupplier.get(), this.k, this.numCands, this.similarity).boost(this.boost).addFilterQueries(this.filterQueries);
        }
        if (this.queryVectorBuilder != null) {
            SetOnce toSet = new SetOnce();
            ctx.registerAsyncAction((c, l) -> this.queryVectorBuilder.buildVector((Client)c, l.delegateFailureAndWrap((ll, v) -> {
                toSet.set(v);
                if (v == null) {
                    ll.onFailure(new IllegalArgumentException(Strings.format("[%s] with name [%s] returned null query_vector", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), this.queryVectorBuilder.getWriteableName())));
                    return;
                }
                ll.onResponse(null);
            })));
            return new KnnSearchBuilder(this.field, () -> ((SetOnce)toSet).get(), this.k, this.numCands, this.filterQueries, this.similarity).boost(this.boost);
        }
        boolean changed = false;
        ArrayList<QueryBuilder> rewrittenQueries = new ArrayList<QueryBuilder>(this.filterQueries.size());
        for (QueryBuilder query : this.filterQueries) {
            QueryBuilder rewrittenQuery = query.rewrite(ctx);
            if (rewrittenQuery != query) {
                changed = true;
            }
            rewrittenQueries.add(rewrittenQuery);
        }
        if (changed) {
            return new KnnSearchBuilder(this.field, this.queryVector, this.k, this.numCands, this.similarity).boost(this.boost).addFilterQueries(rewrittenQueries);
        }
        return this;
    }

    public KnnVectorQueryBuilder toQueryBuilder() {
        if (this.queryVectorBuilder != null) {
            throw new IllegalArgumentException("missing rewrite");
        }
        return ((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.field, this.queryVector, this.numCands, this.similarity).boost(this.boost)).addFilterQueries(this.filterQueries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnnSearchBuilder that = (KnnSearchBuilder)o;
        return this.k == that.k && this.numCands == that.numCands && Objects.equals(this.field, that.field) && Arrays.equals(this.queryVector, that.queryVector) && Objects.equals(this.queryVectorBuilder, that.queryVectorBuilder) && Objects.equals(this.querySupplier, that.querySupplier) && Objects.equals(this.filterQueries, that.filterQueries) && Objects.equals(this.similarity, that.similarity) && this.boost == that.boost;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.k, this.numCands, this.querySupplier, this.queryVectorBuilder, this.similarity, Arrays.hashCode(this.queryVector), Objects.hashCode(this.filterQueries), Float.valueOf(this.boost));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field).field(K_FIELD.getPreferredName(), this.k).field(NUM_CANDS_FIELD.getPreferredName(), this.numCands);
        if (this.queryVectorBuilder != null) {
            builder.startObject(QUERY_VECTOR_BUILDER_FIELD.getPreferredName());
            builder.field(this.queryVectorBuilder.getWriteableName(), (ToXContent)this.queryVectorBuilder);
            builder.endObject();
        } else {
            builder.array(QUERY_VECTOR_FIELD.getPreferredName(), this.queryVector);
        }
        if (this.similarity != null) {
            builder.field(VECTOR_SIMILARITY.getPreferredName(), this.similarity);
        }
        if (!this.filterQueries.isEmpty()) {
            builder.startArray(FILTER_FIELD.getPreferredName());
            for (QueryBuilder filterQuery : this.filterQueries) {
                filterQuery.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.boost != 1.0f) {
            builder.field(BOOST_FIELD.getPreferredName(), this.boost);
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.querySupplier != null) {
            throw new IllegalStateException("missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        out.writeVInt(this.k);
        out.writeVInt(this.numCands);
        out.writeFloatArray(this.queryVector);
        out.writeNamedWriteableList(this.filterQueries);
        out.writeFloat(this.boost);
        if (out.getTransportVersion().before(TransportVersion.V_8_7_0) && this.queryVectorBuilder != null) {
            throw new IllegalArgumentException(Strings.format("cannot serialize [%s] to older node of version [%s]", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), out.getTransportVersion()));
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0)) {
            out.writeOptionalNamedWriteable(this.queryVectorBuilder);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_8_0)) {
            out.writeOptionalFloat(this.similarity);
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareFloatArray(ConstructingObjectParser.optionalConstructorArg(), QUERY_VECTOR_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), K_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_CANDS_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (QueryVectorBuilder)p.namedObject(QueryVectorBuilder.class, n, c), QUERY_VECTOR_BUILDER_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), VECTOR_SIMILARITY);
        PARSER.declareFieldArray(KnnSearchBuilder::addFilterQueries, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p), FILTER_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareFloat(KnnSearchBuilder::boost, BOOST_FIELD);
    }
}

