/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.TaskExecutionTimeTrackingEsThreadPoolExecutor;
import org.elasticsearch.lucene.queries.SearchAfterSortedDocQuery;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchContextSourcePrinter;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseCollectorManager;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QueryPhaseResult;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.RankSearchContext;
import org.elasticsearch.search.rank.RankShardContext;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestPhase;

public class QueryPhase {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhase.class);

    private QueryPhase() {
    }

    public static void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.rankShardContext() == null) {
            QueryPhase.executeQuery(searchContext);
        } else {
            QueryPhase.executeRank(searchContext);
        }
    }

    static void executeRank(SearchContext searchContext) throws QueryPhaseExecutionException {
        RankShardContext rankShardContext = searchContext.rankShardContext();
        QuerySearchResult querySearchResult = searchContext.queryResult();
        if (searchContext.trackTotalHitsUpTo() != -1 || searchContext.aggregations() != null) {
            searchContext.size(0);
            QueryPhase.executeQuery(searchContext);
        } else {
            searchContext.queryResult().topDocs(new TopDocsAndMaxScore(new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN), new DocValueFormat[0]);
        }
        ArrayList<TopDocs> rrfRankResults = new ArrayList<TopDocs>();
        boolean searchTimedOut = querySearchResult.searchTimedOut();
        long serviceTimeEWMA = querySearchResult.serviceTimeEWMA();
        int nodeQueueSize = querySearchResult.nodeQueueSize();
        for (Query rankQuery : rankShardContext.queries()) {
            if (searchTimedOut) break;
            RankSearchContext rankSearchContext = new RankSearchContext(searchContext, rankQuery, rankShardContext.windowSize());
            QueryPhase.addCollectorsAndSearch(rankSearchContext);
            QuerySearchResult rrfQuerySearchResult = rankSearchContext.queryResult();
            rrfRankResults.add(rrfQuerySearchResult.topDocs().topDocs);
            serviceTimeEWMA += rrfQuerySearchResult.serviceTimeEWMA();
            nodeQueueSize = Math.max(nodeQueueSize, rrfQuerySearchResult.nodeQueueSize());
            searchTimedOut = rrfQuerySearchResult.searchTimedOut();
        }
        querySearchResult.setRankShardResult(rankShardContext.combine(rrfRankResults));
        querySearchResult.searchTimedOut(searchTimedOut);
        querySearchResult.serviceTimeEWMA(serviceTimeEWMA);
        querySearchResult.nodeQueueSize(nodeQueueSize);
    }

    static void executeQuery(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.hasOnlySuggest()) {
            SuggestPhase.execute(searchContext);
            searchContext.queryResult().topDocs(new TopDocsAndMaxScore(new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN), new DocValueFormat[0]);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(searchContext));
        }
        AggregationPhase.preProcess(searchContext);
        QueryPhase.addCollectorsAndSearch(searchContext);
        RescorePhase.execute(searchContext);
        SuggestPhase.execute(searchContext);
        AggregationPhase.execute(searchContext);
        if (searchContext.getProfilers() != null) {
            searchContext.queryResult().profileResults(searchContext.getProfilers().buildQueryPhaseResults());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addCollectorsAndSearch(SearchContext searchContext) throws QueryPhaseExecutionException {
        ContextIndexSearcher searcher = searchContext.searcher();
        IndexReader reader = searcher.getIndexReader();
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        try {
            queryResult.from(searchContext.from());
            queryResult.size(searchContext.size());
            Query query = searchContext.rewrittenQuery();
            assert (query == searcher.rewrite(query));
            ScrollContext scrollContext = searchContext.scrollContext();
            if (scrollContext != null) {
                if (scrollContext.totalHits == null) {
                    assert (scrollContext.lastEmittedDoc == null);
                } else {
                    ScoreDoc after = scrollContext.lastEmittedDoc;
                    if (QueryPhase.canEarlyTerminate(reader, searchContext.sort()) && after != null) {
                        query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new SearchAfterSortedDocQuery(searchContext.sort().sort, (FieldDoc)after), BooleanClause.Occur.FILTER).build();
                    }
                }
            }
            boolean hasFilterCollector = searchContext.parsedPostFilter() != null || searchContext.minimumScore() != null;
            Weight postFilterWeight = null;
            if (searchContext.parsedPostFilter() != null) {
                postFilterWeight = searcher.createWeight(searcher.rewrite(searchContext.parsedPostFilter().query()), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            CollectorManager<Collector, QueryPhaseResult> collectorManager = QueryPhaseCollectorManager.createQueryPhaseCollectorManager(postFilterWeight, searchContext.aggregations() == null ? null : searchContext.aggregations().getAggsCollectorManager(), searchContext, hasFilterCollector);
            Runnable timeoutRunnable = QueryPhase.getTimeoutCheck(searchContext);
            if (timeoutRunnable != null) {
                searcher.addQueryCancellation(timeoutRunnable);
            }
            try {
                QueryPhaseResult queryPhaseResult = searcher.search(query, collectorManager);
                if (searchContext.getProfilers() != null) {
                    searchContext.getProfilers().getCurrentQueryProfiler().setCollectorResult(queryPhaseResult.collectorResult());
                }
                queryResult.topDocs(queryPhaseResult.topDocsAndMaxScore(), queryPhaseResult.sortValueFormats());
                if (searcher.timeExceeded()) {
                    assert (timeoutRunnable != null) : "TimeExceededException thrown even though timeout wasn't set";
                    if (!searchContext.request().allowPartialSearchResults()) {
                        throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
                    }
                    queryResult.searchTimedOut(true);
                }
                if (searchContext.terminateAfter() != 0) {
                    queryResult.terminatedEarly(queryPhaseResult.terminatedAfter());
                }
                ExecutorService executor = searchContext.indexShard().getThreadPool().executor("search");
                assert (executor instanceof TaskExecutionTimeTrackingEsThreadPoolExecutor || !(executor instanceof EsThreadPoolExecutor)) : "SEARCH threadpool should have an executor that exposes EWMA metrics, but is of type " + executor.getClass();
                if (executor instanceof TaskExecutionTimeTrackingEsThreadPoolExecutor) {
                    TaskExecutionTimeTrackingEsThreadPoolExecutor rExecutor = (TaskExecutionTimeTrackingEsThreadPoolExecutor)executor;
                    queryResult.nodeQueueSize(rExecutor.getCurrentQueueSize());
                    queryResult.serviceTimeEWMA((long)rExecutor.getTaskExecutionEWMA());
                }
            }
            finally {
                if (timeoutRunnable != null) {
                    searcher.removeQueryCancellation(timeoutRunnable);
                }
            }
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute main query", e);
        }
    }

    private static boolean canEarlyTerminate(IndexReader reader, SortAndFormats sortAndFormats) {
        if (sortAndFormats == null || sortAndFormats.sort == null) {
            return false;
        }
        Sort sort = sortAndFormats.sort;
        for (LeafReaderContext ctx : reader.leaves()) {
            Sort indexSort = ctx.reader().getMetaData().getSort();
            if (indexSort != null && Lucene.canEarlyTerminate(sort, indexSort)) continue;
            return false;
        }
        return true;
    }

    public static Runnable getTimeoutCheck(SearchContext searchContext) {
        boolean timeoutSet;
        boolean bl = timeoutSet = searchContext.scrollContext() == null && searchContext.timeout() != null && !searchContext.timeout().equals((Object)SearchService.NO_TIMEOUT);
        if (timeoutSet) {
            long startTime = searchContext.getRelativeTimeInMillis();
            long timeout = searchContext.timeout().millis();
            long maxTime = startTime + timeout;
            return () -> {
                long time = searchContext.getRelativeTimeInMillis();
                if (time > maxTime) {
                    searchContext.searcher().throwTimeExceededException();
                }
            };
        }
        return null;
    }
}

