/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;

public class SearchProfileQueryPhaseResult
implements Writeable {
    private SearchProfileDfsPhaseResult searchProfileDfsPhaseResult;
    private final List<QueryProfileShardResult> queryProfileResults;
    private final AggregationProfileShardResult aggProfileShardResult;

    public SearchProfileQueryPhaseResult(List<QueryProfileShardResult> queryProfileResults, AggregationProfileShardResult aggProfileShardResult) {
        this.searchProfileDfsPhaseResult = null;
        this.aggProfileShardResult = aggProfileShardResult;
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
    }

    public SearchProfileQueryPhaseResult(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_6_0)) {
            this.searchProfileDfsPhaseResult = in.readOptionalWriteable(SearchProfileDfsPhaseResult::new);
        }
        int profileSize = in.readVInt();
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>(profileSize);
        for (int i = 0; i < profileSize; ++i) {
            QueryProfileShardResult result = new QueryProfileShardResult(in);
            queryProfileResults.add(result);
        }
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.aggProfileShardResult = new AggregationProfileShardResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_6_0)) {
            out.writeOptionalWriteable(this.searchProfileDfsPhaseResult);
        }
        out.writeVInt(this.queryProfileResults.size());
        for (QueryProfileShardResult queryShardResult : this.queryProfileResults) {
            queryShardResult.writeTo(out);
        }
        this.aggProfileShardResult.writeTo(out);
    }

    public void setSearchProfileDfsPhaseResult(SearchProfileDfsPhaseResult searchProfileDfsPhaseResult) {
        this.searchProfileDfsPhaseResult = searchProfileDfsPhaseResult;
    }

    public SearchProfileDfsPhaseResult getSearchProfileDfsPhaseResult() {
        return this.searchProfileDfsPhaseResult;
    }

    public List<QueryProfileShardResult> getQueryProfileResults() {
        return this.queryProfileResults;
    }

    public AggregationProfileShardResult getAggregationProfileResults() {
        return this.aggProfileShardResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchProfileQueryPhaseResult that = (SearchProfileQueryPhaseResult)o;
        return Objects.equals(this.searchProfileDfsPhaseResult, that.searchProfileDfsPhaseResult) && Objects.equals(this.queryProfileResults, that.queryProfileResults) && Objects.equals(this.aggProfileShardResult, that.aggProfileShardResult);
    }

    public int hashCode() {
        return Objects.hash(this.searchProfileDfsPhaseResult, this.queryProfileResults, this.aggProfileShardResult);
    }
}

