/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.lucene.util.CombinedBitSet;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.internal.CancellableBulkScorer;
import org.elasticsearch.search.internal.ExitableDirectoryReader;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.profile.query.QueryTimingType;
import org.elasticsearch.search.query.QueryPhaseCollector;

public class ContextIndexSearcher
extends IndexSearcher
implements Releasable {
    private static final Logger logger = LogManager.getLogger(ContextIndexSearcher.class);
    private static final int CHECK_CANCELLED_SCORER_INTERVAL = 2048;
    static final double MINIMUM_DOCS_PERCENT_PER_SLICE = 0.1;
    private AggregatedDfs aggregatedDfs;
    private QueryProfiler profiler;
    private final MutableQueryTimeout cancellable;
    private final IndexSearcher.LeafSlice[] leafSlices;
    private final int minimumDocsPerSlice;
    private volatile boolean timeExceeded = false;

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader, null, -1, -1);
    }

    public ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, boolean wrapWithExitableDirectoryReader, Executor executor, int maximumNumberOfSlices, int minimumDocsPerSlice) throws IOException {
        this(reader, similarity, queryCache, queryCachingPolicy, new MutableQueryTimeout(), wrapWithExitableDirectoryReader, executor, maximumNumberOfSlices, minimumDocsPerSlice);
    }

    ContextIndexSearcher(IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, MutableQueryTimeout cancellable, boolean wrapWithExitableDirectoryReader, Executor executor, int maximumNumberOfSlices, int minimumDocsPerSlice) throws IOException {
        super((IndexReader)(wrapWithExitableDirectoryReader ? new ExitableDirectoryReader((DirectoryReader)reader, cancellable) : reader), ContextIndexSearcher.wrapExecutor(executor));
        this.setSimilarity(similarity);
        this.setQueryCache(queryCache);
        this.setQueryCachingPolicy(queryCachingPolicy);
        this.cancellable = cancellable;
        this.minimumDocsPerSlice = minimumDocsPerSlice;
        if (executor == null) {
            this.leafSlices = null;
        } else {
            this.leafSlices = ContextIndexSearcher.computeSlices(this.getLeafContexts(), maximumNumberOfSlices, minimumDocsPerSlice);
            assert (this.leafSlices.length <= maximumNumberOfSlices) : "more slices created than the maximum allowed";
        }
    }

    private static Executor wrapExecutor(Executor executor) {
        if (executor instanceof ThreadPoolExecutor) {
            return executor::execute;
        }
        return executor;
    }

    int getMinimumDocsPerSlice() {
        return this.minimumDocsPerSlice;
    }

    public void setProfiler(QueryProfiler profiler) {
        this.profiler = profiler;
    }

    public Runnable addQueryCancellation(Runnable action) {
        return this.cancellable.add(action);
    }

    public void removeQueryCancellation(Runnable action) {
        this.cancellable.remove(action);
    }

    public void close() {
        this.cancellable.clear();
    }

    public boolean hasCancellations() {
        return this.cancellable.isEnabled();
    }

    public void setAggregatedDfs(AggregatedDfs aggregatedDfs) {
        this.aggregatedDfs = aggregatedDfs;
    }

    public Query rewrite(Query original) throws IOException {
        if (this.profiler != null) {
            this.profiler.startRewriteTime();
        }
        try {
            Query query = super.rewrite(original);
            return query;
        }
        finally {
            if (this.profiler != null) {
                this.profiler.stopAndAddRewriteTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (this.profiler != null) {
            Weight weight;
            QueryProfileBreakdown profile = (QueryProfileBreakdown)this.profiler.getQueryBreakdown(query);
            Timer timer = profile.getNewTimer(QueryTimingType.CREATE_WEIGHT);
            timer.start();
            try {
                weight = query.createWeight((IndexSearcher)this, scoreMode, boost);
            }
            finally {
                timer.stop();
                this.profiler.pollLastElement();
            }
            return new ProfileWeight(query, weight, profile);
        }
        return super.createWeight(query, scoreMode, boost);
    }

    protected IndexSearcher.LeafSlice[] slices(List<LeafReaderContext> leaves) {
        return IndexSearcher.slices(leaves, (int)Math.max(1, leaves.size()), (int)1);
    }

    final IndexSearcher.LeafSlice[] getSlicesForCollection() {
        return this.leafSlices;
    }

    public static IndexSearcher.LeafSlice[] computeSlices(List<LeafReaderContext> leaves, int maxSliceNum, int minDocsPerSlice) {
        if (maxSliceNum < 1) {
            throw new IllegalArgumentException("maxSliceNum must be >= 1 (got " + maxSliceNum + ")");
        }
        if (maxSliceNum == 1) {
            return new IndexSearcher.LeafSlice[]{new IndexSearcher.LeafSlice(new ArrayList<LeafReaderContext>(leaves))};
        }
        int numDocs = leaves.stream().mapToInt(l -> l.reader().maxDoc()).sum();
        double percentageDocsPerThread = Math.max(0.1, 1.0 / (double)maxSliceNum);
        return ContextIndexSearcher.computeSlices(leaves, Math.max(minDocsPerSlice, (int)(percentageDocsPerThread * (double)numDocs)));
    }

    private static IndexSearcher.LeafSlice[] computeSlices(List<LeafReaderContext> leaves, int minDocsPerSlice) {
        ArrayList<LeafReaderContext> sortedLeaves = new ArrayList<LeafReaderContext>(leaves);
        Comparator<LeafReaderContext> leafComparator = Comparator.comparingInt(l -> l.reader().maxDoc());
        Collections.sort(sortedLeaves, leafComparator.reversed());
        Comparator<List> groupComparator = Comparator.comparingInt(l -> l.stream().mapToInt(lr -> lr.reader().maxDoc()).sum());
        PriorityQueue<List> queue = new PriorityQueue<List>(groupComparator);
        long docSum = 0L;
        ArrayList<LeafReaderContext> group = new ArrayList<LeafReaderContext>();
        for (LeafReaderContext ctx : sortedLeaves) {
            group.add(ctx);
            if ((docSum += (long)ctx.reader().maxDoc()) <= (long)minDocsPerSlice) continue;
            queue.add(group);
            group = new ArrayList();
            docSum = 0L;
        }
        if (group.size() > 0) {
            if (queue.size() == 0) {
                queue.add(group);
            } else {
                for (LeafReaderContext context : group) {
                    List head = queue.poll();
                    head.add(context);
                    queue.add(head);
                }
            }
        }
        IndexSearcher.LeafSlice[] slices = new IndexSearcher.LeafSlice[queue.size()];
        int upto = 0;
        for (List currentLeaf : queue) {
            slices[upto++] = new IndexSearcher.LeafSlice(currentLeaf);
        }
        return slices;
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        Weight weight;
        Collector firstCollector = collectorManager.newCollector();
        try {
            query = firstCollector.scoreMode().needsScores() ? this.rewrite(query) : this.rewrite((Query)new ConstantScoreQuery(query));
            weight = this.createWeight(query, firstCollector.scoreMode(), 1.0f);
        }
        catch (TimeExceededException e) {
            this.timeExceeded = true;
            return (T)collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        return this.search(weight, collectorManager, firstCollector);
    }

    private <C extends Collector, T> T search(Weight weight, CollectorManager<C, T> collectorManager, C firstCollector) throws IOException {
        if (this.getExecutor() == null) {
            this.search(this.leafContexts, weight, firstCollector);
            return (T)collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        if (this.leafSlices.length == 0) {
            assert (this.leafContexts.isEmpty());
            this.doAggregationPostCollection(firstCollector);
            return (T)collectorManager.reduce(Collections.singletonList(firstCollector));
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>(this.leafSlices.length);
        collectors.add(firstCollector);
        ScoreMode scoreMode = firstCollector.scoreMode();
        for (int i = 1; i < this.leafSlices.length; ++i) {
            Collector collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        ArrayList<1> listTasks = new ArrayList<1>();
        for (int i = 0; i < this.leafSlices.length; ++i) {
            LeafReaderContext[] leafReaderContextArray = this.leafSlices[i].leaves;
            Collector collector = (Collector)collectors.get(i);
            final AtomicInteger state = new AtomicInteger(0);
            FutureTask futureTask = new FutureTask<C>(() -> {
                if (state.compareAndSet(0, 1)) {
                    try {
                        this.search(Arrays.asList(leaves), weight, collector);
                        if (this.timeExceeded) {
                            for (Future future : listTasks) {
                                FutureUtils.cancel(future);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (Future future : listTasks) {
                            FutureUtils.cancel(future);
                        }
                        throw e;
                    }
                    return collector;
                }
                throw new CancellationException();
            }){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return state.compareAndSet(0, -1);
                }

                @Override
                public boolean isCancelled() {
                    return state.get() == -1;
                }
            };
            listTasks.add(futureTask);
        }
        logger.trace("Collecting using " + listTasks.size() + " tasks.");
        for (Runnable runnable : listTasks) {
            this.getExecutor().execute(runnable);
        }
        Object exception = null;
        ArrayList<Collector> arrayList = new ArrayList<Collector>();
        boolean cancellation = false;
        for (Future future : listTasks) {
            try {
                arrayList.add((Collector)future.get());
            }
            catch (InterruptedException e) {
                if (exception != null) continue;
                exception = new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                if (exception != null) continue;
                if (e.getCause() instanceof CancellationException) {
                    cancellation = true;
                    continue;
                }
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    exception = runtimeException;
                    continue;
                }
                throwable = e.getCause();
                if (throwable instanceof IOException) {
                    IOException ioException = (IOException)throwable;
                    throw ioException;
                }
                exception = new RuntimeException(e.getCause());
            }
        }
        assert (!cancellation || exception != null || this.timeExceeded) : "cancellation without an exception or timeout?";
        if (exception != null) {
            throw exception;
        }
        return (T)collectorManager.reduce(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        collector.setWeight(weight);
        try {
            for (LeafReaderContext ctx : leaves) {
                this.searchLeaf(ctx, weight, collector);
            }
        }
        catch (TimeExceededException e) {
            this.timeExceeded = true;
        }
        finally {
            this.doAggregationPostCollection(collector);
        }
    }

    private void doAggregationPostCollection(Collector collector) throws IOException {
        if (collector instanceof QueryPhaseCollector) {
            QueryPhaseCollector queryPhaseCollector = (QueryPhaseCollector)collector;
            queryPhaseCollector.doPostCollection();
        } else if (collector instanceof InternalProfileCollector) {
            InternalProfileCollector profilerCollector = (InternalProfileCollector)collector;
            profilerCollector.doPostCollection();
        }
    }

    public boolean timeExceeded() {
        return this.timeExceeded;
    }

    public void throwTimeExceededException() {
        throw new TimeExceededException();
    }

    private void searchLeaf(LeafReaderContext ctx, Weight weight, Collector collector) throws IOException {
        LeafCollector leafCollector;
        this.cancellable.checkCancelled();
        try {
            leafCollector = collector.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        Bits liveDocs = ctx.reader().getLiveDocs();
        BitSet liveDocsBitSet = ContextIndexSearcher.getSparseBitSetOrNull(liveDocs);
        if (liveDocsBitSet == null) {
            BulkScorer bulkScorer = weight.bulkScorer(ctx);
            if (bulkScorer != null) {
                if (this.cancellable.isEnabled()) {
                    bulkScorer = new CancellableBulkScorer(bulkScorer, this.cancellable::checkCancelled);
                }
                try {
                    bulkScorer.score(leafCollector, liveDocs);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {}
            }
        } else {
            Scorer scorer = weight.scorer(ctx);
            if (scorer != null) {
                try {
                    ContextIndexSearcher.intersectScorerAndBitSet(scorer, liveDocsBitSet, leafCollector, this.cancellable.isEnabled() ? this.cancellable::checkCancelled : () -> {});
                }
                catch (CollectionTerminatedException collectionTerminatedException) {
                    // empty catch block
                }
            }
        }
    }

    private static BitSet getSparseBitSetOrNull(Bits liveDocs) {
        if (liveDocs instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        if (liveDocs instanceof CombinedBitSet && ((CombinedBitSet)liveDocs).getFirst() instanceof SparseFixedBitSet) {
            return (BitSet)liveDocs;
        }
        return null;
    }

    static void intersectScorerAndBitSet(Scorer scorer, BitSet acceptDocs, LeafCollector collector, Runnable checkCancelled) throws IOException {
        collector.setScorer((Scorable)scorer);
        DocIdSetIterator iterator = ConjunctionUtils.intersectIterators(Arrays.asList(new BitSetIterator(acceptDocs, (long)acceptDocs.approximateCardinality()), scorer.iterator()));
        int seen = 0;
        checkCancelled.run();
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (++seen % 2048 == 0) {
                checkCancelled.run();
            }
            collector.collect(docId);
            docId = iterator.nextDoc();
        }
        checkCancelled.run();
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        TermStatistics termStatistics = this.aggregatedDfs.termStatistics().get(term);
        if (termStatistics == null) {
            return super.termStatistics(term, docFreq, totalTermFreq);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        if (this.aggregatedDfs == null) {
            return super.collectionStatistics(field);
        }
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public DirectoryReader getDirectoryReader() {
        IndexReader reader = this.getIndexReader();
        assert (reader instanceof DirectoryReader) : "expected an instance of DirectoryReader, got " + reader.getClass();
        return (DirectoryReader)reader;
    }

    private static class MutableQueryTimeout
    implements ExitableDirectoryReader.QueryCancellation {
        private final Set<Runnable> runnables = new HashSet<Runnable>();

        private MutableQueryTimeout() {
        }

        private Runnable add(Runnable action) {
            Objects.requireNonNull(action, "cancellation runnable should not be null");
            if (!this.runnables.add(action)) {
                throw new IllegalArgumentException("Cancellation runnable already added");
            }
            return action;
        }

        private void remove(Runnable action) {
            this.runnables.remove(action);
        }

        @Override
        public void checkCancelled() {
            for (Runnable timeout : this.runnables) {
                timeout.run();
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.runnables.isEmpty();
        }

        public void clear() {
            this.runnables.clear();
        }
    }

    private static class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

