/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.transport.RemoteClusterAware;

public record LookupField(String targetIndex, QueryBuilder query, List<FieldAndFormat> fetchFields, int size) implements Writeable
{
    public LookupField(StreamInput in) throws IOException {
        this(in.readString(), in.readNamedWriteable(QueryBuilder.class), in.readList(FieldAndFormat::new), in.readVInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.targetIndex);
        out.writeNamedWriteable(this.query);
        out.writeCollection(this.fetchFields);
        out.writeVInt(this.size);
    }

    public SearchRequest toSearchRequest(String clusterAlias) {
        SearchSourceBuilder source = new SearchSourceBuilder().query(this.query).trackScores(false).size(this.size).fetchSource(false);
        this.fetchFields.forEach(source::fetchField);
        return new SearchRequest().source(source).indices(RemoteClusterAware.buildRemoteIndexName(clusterAlias, this.targetIndex));
    }
}

