/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class Max
extends InternalNumericMetricsAggregation.SingleValue {
    private final double max;
    private final boolean nonEmpty;

    public Max(String name, double max, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.max = max;
        this.nonEmpty = true;
    }

    public static Max createEmptyMax(String name, DocValueFormat formatter, Map<String, Object> metadata) {
        return new Max(name, formatter, metadata);
    }

    private Max(String name, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.max = Double.NEGATIVE_INFINITY;
        this.nonEmpty = false;
    }

    public Max(StreamInput in) throws IOException {
        super(in);
        this.max = in.readDouble();
        this.nonEmpty = this.max != Double.NEGATIVE_INFINITY || this.format != DocValueFormat.RAW;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.max);
    }

    @Override
    public String getWriteableName() {
        return "max";
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    public double value() {
        return this.max;
    }

    @Override
    public Max reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        double max = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : aggregations) {
            max = Math.max(max, ((Max)aggregation).max);
        }
        return new Max(this.name, max, this.format, this.getMetadata());
    }

    @Override
    public boolean canLeadReduction() {
        return this.nonEmpty;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.max);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.max) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.max).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.max);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Max other = (Max)obj;
        return Objects.equals(this.max, other.max);
    }
}

