/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalExtendedStats;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xcontent.ParseField;

class ExtendedStatsAggregator
extends NumericMetricsAggregator.MultiValue {
    static final ParseField SIGMA_FIELD = new ParseField("sigma", new String[0]);
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final double sigma;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DoubleArray mins;
    DoubleArray maxes;
    DoubleArray sumOfSqrs;
    DoubleArray compensationOfSqrs;

    ExtendedStatsAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double sigma, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = (ValuesSource.Numeric)config.getValuesSource();
        this.format = config.format();
        this.sigma = sigma;
        BigArrays bigArrays = context.bigArrays();
        this.counts = bigArrays.newLongArray(1L, true);
        this.sums = bigArrays.newDoubleArray(1L, true);
        this.compensations = bigArrays.newDoubleArray(1L, true);
        this.mins = bigArrays.newDoubleArray(1L, false);
        this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        this.maxes = bigArrays.newDoubleArray(1L, false);
        this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        this.sumOfSqrs = bigArrays.newDoubleArray(1L, true);
        this.compensationOfSqrs = bigArrays.newDoubleArray(1L, true);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
        final CompensatedSum compensatedSum = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumOfSqr = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= ExtendedStatsAggregator.this.counts.size()) {
                    long from = ExtendedStatsAggregator.this.counts.size();
                    long overSize = BigArrays.overSize(bucket + 1L);
                    ExtendedStatsAggregator.this.counts = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.counts, overSize);
                    ExtendedStatsAggregator.this.sums = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.sums, overSize);
                    ExtendedStatsAggregator.this.compensations = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.compensations, overSize);
                    ExtendedStatsAggregator.this.mins = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.mins, overSize);
                    ExtendedStatsAggregator.this.maxes = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.maxes, overSize);
                    ExtendedStatsAggregator.this.sumOfSqrs = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.sumOfSqrs, overSize);
                    ExtendedStatsAggregator.this.compensationOfSqrs = ExtendedStatsAggregator.this.bigArrays().resize(ExtendedStatsAggregator.this.compensationOfSqrs, overSize);
                    ExtendedStatsAggregator.this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
                    ExtendedStatsAggregator.this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    ExtendedStatsAggregator.this.counts.increment(bucket, valuesCount);
                    double min = ExtendedStatsAggregator.this.mins.get(bucket);
                    double max = ExtendedStatsAggregator.this.maxes.get(bucket);
                    double sum = ExtendedStatsAggregator.this.sums.get(bucket);
                    double compensation = ExtendedStatsAggregator.this.compensations.get(bucket);
                    compensatedSum.reset(sum, compensation);
                    double sumOfSqr = ExtendedStatsAggregator.this.sumOfSqrs.get(bucket);
                    double compensationOfSqr = ExtendedStatsAggregator.this.compensationOfSqrs.get(bucket);
                    compensatedSumOfSqr.reset(sumOfSqr, compensationOfSqr);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        compensatedSum.add(value);
                        compensatedSumOfSqr.add(value * value);
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    ExtendedStatsAggregator.this.sums.set(bucket, compensatedSum.value());
                    ExtendedStatsAggregator.this.compensations.set(bucket, compensatedSum.delta());
                    ExtendedStatsAggregator.this.sumOfSqrs.set(bucket, compensatedSumOfSqr.value());
                    ExtendedStatsAggregator.this.compensationOfSqrs.set(bucket, compensatedSumOfSqr.delta());
                    ExtendedStatsAggregator.this.mins.set(bucket, min);
                    ExtendedStatsAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public boolean hasMetric(String name) {
        return InternalExtendedStats.Metrics.hasMetric(name);
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (owningBucketOrd >= this.counts.size()) {
            return switch (InternalExtendedStats.Metrics.resolve(name)) {
                case InternalExtendedStats.Metrics.count -> 0.0;
                case InternalExtendedStats.Metrics.sum -> 0.0;
                case InternalExtendedStats.Metrics.min -> Double.POSITIVE_INFINITY;
                case InternalExtendedStats.Metrics.max -> Double.NEGATIVE_INFINITY;
                case InternalExtendedStats.Metrics.avg -> Double.NaN;
                case InternalExtendedStats.Metrics.sum_of_squares -> 0.0;
                case InternalExtendedStats.Metrics.variance -> Double.NaN;
                case InternalExtendedStats.Metrics.variance_population -> Double.NaN;
                case InternalExtendedStats.Metrics.variance_sampling -> Double.NaN;
                case InternalExtendedStats.Metrics.std_deviation -> Double.NaN;
                case InternalExtendedStats.Metrics.std_deviation_population -> Double.NaN;
                case InternalExtendedStats.Metrics.std_deviation_sampling -> Double.NaN;
                case InternalExtendedStats.Metrics.std_upper -> Double.NaN;
                case InternalExtendedStats.Metrics.std_lower -> Double.NaN;
                default -> throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
            };
        }
        return switch (InternalExtendedStats.Metrics.resolve(name)) {
            case InternalExtendedStats.Metrics.count -> this.counts.get(owningBucketOrd);
            case InternalExtendedStats.Metrics.sum -> this.sums.get(owningBucketOrd);
            case InternalExtendedStats.Metrics.min -> this.mins.get(owningBucketOrd);
            case InternalExtendedStats.Metrics.max -> this.maxes.get(owningBucketOrd);
            case InternalExtendedStats.Metrics.avg -> this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            case InternalExtendedStats.Metrics.sum_of_squares -> this.sumOfSqrs.get(owningBucketOrd);
            case InternalExtendedStats.Metrics.variance -> this.variance(owningBucketOrd);
            case InternalExtendedStats.Metrics.variance_population -> this.variancePopulation(owningBucketOrd);
            case InternalExtendedStats.Metrics.variance_sampling -> this.varianceSampling(owningBucketOrd);
            case InternalExtendedStats.Metrics.std_deviation -> Math.sqrt(this.variance(owningBucketOrd));
            case InternalExtendedStats.Metrics.std_deviation_population -> Math.sqrt(this.variance(owningBucketOrd));
            case InternalExtendedStats.Metrics.std_deviation_sampling -> Math.sqrt(this.varianceSampling(owningBucketOrd));
            case InternalExtendedStats.Metrics.std_upper -> this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) + Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            case InternalExtendedStats.Metrics.std_lower -> this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) - Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            default -> throw new IllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
        };
    }

    private double variance(long owningBucketOrd) {
        return this.variancePopulation(owningBucketOrd);
    }

    private double variancePopulation(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        double variance = (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)count;
        return variance < 0.0 ? 0.0 : variance;
    }

    private double varianceSampling(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        double variance = (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)(count - 1L);
        return variance < 0.0 ? 0.0 : variance;
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalExtendedStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.sumOfSqrs.get(bucket), this.sigma, this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalExtendedStats.empty(this.name, this.sigma, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.maxes, this.mins, this.sumOfSqrs, this.compensationOfSqrs, this.sums, this.compensations});
    }
}

