/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.EmptyTDigestState;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

abstract class AbstractInternalTDigestPercentiles
extends InternalNumericMetricsAggregation.MultiValue {
    protected static final Iterator<Percentile> EMPTY_ITERATOR = Collections.emptyIterator();
    private static final TDigestState EMPTY_HISTOGRAM = new EmptyTDigestState();
    protected final double[] keys;
    protected final TDigestState state;
    final boolean keyed;

    AbstractInternalTDigestPercentiles(String name, double[] keys, TDigestState state, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.keys = keys;
        this.state = state;
        this.keyed = keyed;
        if (state != null) {
            state.compress();
        }
    }

    protected AbstractInternalTDigestPercentiles(StreamInput in) throws IOException {
        super(in);
        this.keys = in.readDoubleArray();
        this.state = in.getTransportVersion().onOrAfter(TransportVersion.V_8_8_0) ? (in.readBoolean() ? TDigestState.read(in) : null) : TDigestState.read(in);
        this.keyed = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.keys);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_8_0)) {
            if (this.state != null) {
                out.writeBoolean(true);
                TDigestState.write(this.state, out);
            } else {
                out.writeBoolean(false);
            }
        } else {
            TDigestState state = this.state != null ? this.state : EMPTY_HISTOGRAM;
            TDigestState.write(state, out);
        }
        out.writeBoolean(this.keyed);
    }

    @Override
    public double value(String name) {
        if (this.keys.length == 1 && this.name.equals(name)) {
            return this.value(this.keys[0]);
        }
        return this.value(Double.parseDouble(name));
    }

    @Override
    public Iterable<String> valueNames() {
        return Arrays.stream(this.getKeys()).mapToObj(d -> String.valueOf(d)).toList();
    }

    public abstract double value(double var1);

    public DocValueFormat formatter() {
        return this.format;
    }

    public TDigestState getState() {
        return this.state;
    }

    public double[] getKeys() {
        return this.keys;
    }

    public boolean keyed() {
        return this.keyed;
    }

    @Override
    public AbstractInternalTDigestPercentiles reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        TDigestState merged = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTDigestPercentiles percentiles = (AbstractInternalTDigestPercentiles)aggregation;
            if (percentiles.state == null) continue;
            if (merged == null) {
                merged = TDigestState.createUsingParamsFrom(percentiles.state);
            }
            merged = this.merge(merged, percentiles.state);
        }
        if (merged == null) {
            merged = EMPTY_HISTOGRAM;
        }
        return this.createReduced(this.getName(), this.keys, merged, this.keyed, this.getMetadata());
    }

    private TDigestState merge(TDigestState digest1, TDigestState digest2) {
        TDigestState largerCompression = digest1;
        TDigestState smallerCompression = digest2;
        if (digest2.compression() > digest1.compression()) {
            largerCompression = digest2;
            smallerCompression = digest1;
        }
        largerCompression.add(smallerCompression);
        return largerCompression;
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    protected abstract AbstractInternalTDigestPercentiles createReduced(String var1, double[] var2, TDigestState var3, boolean var4, Map<String, Object> var5);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        TDigestState state;
        TDigestState tDigestState = state = this.state != null ? this.state : EMPTY_HISTOGRAM;
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.VALUES.getPreferredName());
            for (int i = 0; i < this.keys.length; ++i) {
                String key = String.valueOf(this.keys[i]);
                double value = this.value(this.keys[i]);
                builder.field(key, state.size() == 0L ? null : Double.valueOf(value));
                if (this.format == DocValueFormat.RAW || state.size() <= 0L) continue;
                builder.field(key + "_as_string", this.format.format(value).toString());
            }
            builder.endObject();
        } else {
            builder.startArray(Aggregation.CommonFields.VALUES.getPreferredName());
            for (int i = 0; i < this.keys.length; ++i) {
                double value = this.value(this.keys[i]);
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.keys[i]);
                builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), state.size() == 0L ? null : Double.valueOf(value));
                if (this.format != DocValueFormat.RAW && state.size() > 0L) {
                    builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(value).toString());
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractInternalTDigestPercentiles that = (AbstractInternalTDigestPercentiles)obj;
        return this.keyed == that.keyed && Arrays.equals(this.keys, that.keys) && Objects.equals(this.state, that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyed, Arrays.hashCode(this.keys), this.state);
    }
}

