/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.prefix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.prefix.InternalIpPrefix;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public final class IpPrefixAggregator
extends BucketsAggregator {
    final ValuesSourceConfig config;
    final long minDocCount;
    final boolean keyed;
    final BytesKeyedBucketOrds bucketOrds;
    final IpPrefix ipPrefix;

    public IpPrefixAggregator(String name, AggregatorFactories factories, ValuesSourceConfig config, boolean keyed, long minDocCount, IpPrefix ipPrefix, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.config = config;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.bucketOrds = BytesKeyedBucketOrds.build(this.bigArrays(), cardinality);
        this.ipPrefix = ipPrefix;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        return new IpPrefixLeafCollector(sub, this.config.getValuesSource().bytesValues(aggCtx.getLeafReaderContext()), this.ipPrefix);
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        long totalOrdsToCollect = 0L;
        int[] bucketsInOrd = new int[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            long bucketCount = this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
            bucketsInOrd[ordIdx] = (int)bucketCount;
            totalOrdsToCollect += bucketCount;
        }
        long[] bucketOrdsToCollect = new long[(int)totalOrdsToCollect];
        int b = 0;
        for (long owningBucketOrd : owningBucketOrds) {
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrd);
            while (ordsEnum.next()) {
                bucketOrdsToCollect[b++] = ordsEnum.ord();
            }
        }
        InternalAggregations[] subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        b = 0;
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            ArrayList<InternalIpPrefix.Bucket> buckets = new ArrayList<InternalIpPrefix.Bucket>(bucketsInOrd[ordIdx]);
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            while (ordsEnum.next()) {
                long ordinal = ordsEnum.ord();
                if (bucketOrdsToCollect[b] != ordinal) {
                    throw new AggregationExecutionException("Iteration order of [" + this.bucketOrds + "] changed without mutating. [" + ordinal + "] should have been [" + bucketOrdsToCollect[b] + "]");
                }
                BytesRef ipAddress = new BytesRef();
                ordsEnum.readValue(ipAddress);
                long docCount = this.bucketDocCount(ordinal);
                buckets.add(new InternalIpPrefix.Bucket(this.config.format(), BytesRef.deepCopyOf((BytesRef)ipAddress), this.keyed, this.ipPrefix.isIpv6, this.ipPrefix.prefixLength, this.ipPrefix.appendPrefixLength, docCount, subAggregationResults[b++]));
                CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator());
            }
            results[ordIdx] = new InternalIpPrefix(this.name, this.config.format(), this.keyed, this.minDocCount, buckets, this.metadata());
        }
        return results;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalIpPrefix(this.name, this.config.format(), this.keyed, this.minDocCount, Collections.emptyList(), this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    public static class IpPrefix {
        final boolean isIpv6;
        final int prefixLength;
        final boolean appendPrefixLength;
        final BytesRef netmask;

        public IpPrefix(boolean isIpv6, int prefixLength, boolean appendPrefixLength, BytesRef netmask) {
            this.isIpv6 = isIpv6;
            this.prefixLength = prefixLength;
            this.appendPrefixLength = appendPrefixLength;
            this.netmask = netmask;
        }

        public boolean isIpv6() {
            return this.isIpv6;
        }

        public int getPrefixLength() {
            return this.prefixLength;
        }

        public boolean appendPrefixLength() {
            return this.appendPrefixLength;
        }

        public BytesRef getNetmask() {
            return this.netmask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpPrefix ipPrefix = (IpPrefix)o;
            return this.isIpv6 == ipPrefix.isIpv6 && this.prefixLength == ipPrefix.prefixLength && this.appendPrefixLength == ipPrefix.appendPrefixLength && Objects.equals(this.netmask, ipPrefix.netmask);
        }

        public int hashCode() {
            return Objects.hash(this.isIpv6, this.prefixLength, this.appendPrefixLength, this.netmask);
        }
    }

    private class IpPrefixLeafCollector
    extends LeafBucketCollectorBase {
        private final IpPrefix ipPrefix;
        private final LeafBucketCollector sub;
        private final SortedBinaryDocValues values;

        IpPrefixLeafCollector(LeafBucketCollector sub, SortedBinaryDocValues values, IpPrefix ipPrefix) {
            super(sub, values);
            this.sub = sub;
            this.values = values;
            this.ipPrefix = ipPrefix;
        }

        @Override
        public void collect(int doc, long owningBucketOrd) throws IOException {
            BytesRef previousSubnet = null;
            BytesRef subnet = new BytesRef(new byte[this.ipPrefix.netmask.length]);
            if (this.values.advanceExact(doc)) {
                int valuesCount = this.values.docValueCount();
                for (int i = 0; i < valuesCount; ++i) {
                    BytesRef ipAddress = this.values.nextValue();
                    IpPrefixLeafCollector.maskIpAddress(ipAddress, this.ipPrefix.netmask, subnet);
                    if (previousSubnet != null && subnet.bytesEquals(previousSubnet)) continue;
                    long bucketOrd = IpPrefixAggregator.this.bucketOrds.add(owningBucketOrd, subnet);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        IpPrefixAggregator.this.collectExistingBucket(this.sub, doc, bucketOrd);
                    } else {
                        IpPrefixAggregator.this.collectBucket(this.sub, doc, bucketOrd);
                    }
                    previousSubnet = subnet;
                }
            }
        }

        private static void maskIpAddress(BytesRef ipAddress, BytesRef subnetMask, BytesRef subnet) {
            assert (ipAddress.length == 16) : "Invalid length for ip address [" + ipAddress.length + "] expected 16 bytes";
            int offset = subnetMask.length == 4 ? 12 : 0;
            for (int i = 0; i < subnetMask.length; ++i) {
                subnet.bytes[i] = (byte)(ipAddress.bytes[i + offset] & subnetMask.bytes[i]);
            }
        }
    }

    public static class Unmapped
    extends NonCollectingAggregator {
        private final ValuesSourceConfig config;
        private final boolean keyed;
        private final long minDocCount;

        protected Unmapped(String name, AggregatorFactories factories, ValuesSourceConfig config, boolean keyed, long minDocCount, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
            this.config = config;
            this.keyed = keyed;
            this.minDocCount = minDocCount;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return new InternalIpPrefix(this.name, this.config.format(), this.keyed, this.minDocCount, Collections.emptyList(), this.metadata());
        }
    }
}

