/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.support.TimeSeriesIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhase;

public class AggregationPhase {
    private AggregationPhase() {
    }

    public static void preProcess(SearchContext context) {
        Supplier<Collector> collectorSupplier;
        if (context.aggregations() == null) {
            return;
        }
        if (context.aggregations().isInSortOrderExecutionRequired()) {
            AggregationPhase.executeInSortOrder(context, AggregationPhase.newBucketCollector(context));
            collectorSupplier = () -> BucketCollector.NO_OP_COLLECTOR;
        } else {
            collectorSupplier = () -> AggregationPhase.newBucketCollector(context).asCollector();
        }
        context.aggregations().registerAggsCollectorManager(new CollectorManager<Collector, Void>(){

            public Collector newCollector() {
                return (Collector)collectorSupplier.get();
            }

            public Void reduce(Collection<Collector> collectors) {
                return null;
            }
        });
    }

    private static BucketCollector newBucketCollector(SearchContext context) {
        try {
            Aggregator[] aggregators = context.aggregations().factories().createTopLevelAggregators();
            context.aggregations().aggregators(aggregators);
            BucketCollector bucketCollector = MultiBucketCollector.wrap(true, List.of(aggregators));
            bucketCollector.preCollection();
            return bucketCollector;
        }
        catch (IOException e) {
            throw new AggregationInitializationException("Could not initialize aggregators", e);
        }
    }

    private static void executeInSortOrder(SearchContext context, BucketCollector collector) {
        TimeSeriesIndexSearcher searcher = new TimeSeriesIndexSearcher(context.searcher(), AggregationPhase.getCancellationChecks(context));
        searcher.setMinimumScore(context.minimumScore());
        searcher.setProfiler(context);
        try {
            searcher.search(context.rewrittenQuery(), collector);
        }
        catch (IOException e) {
            throw new AggregationExecutionException("Could not perform time series aggregation", e);
        }
    }

    private static List<Runnable> getCancellationChecks(SearchContext context) {
        Runnable timeoutRunnable;
        ArrayList<Runnable> cancellationChecks = new ArrayList<Runnable>();
        if (context.lowLevelCancellation()) {
            cancellationChecks.add(() -> {
                SearchShardTask task = context.getTask();
                if (task != null) {
                    task.ensureNotCancelled();
                }
            });
        }
        if ((timeoutRunnable = QueryPhase.getTimeoutCheck(context)) != null) {
            cancellationChecks.add(timeoutRunnable);
        }
        return cancellationChecks;
    }

    public static void execute(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().hasAggs()) {
            return;
        }
        ArrayList<InternalAggregations> internalAggregations = new ArrayList<InternalAggregations>(context.aggregations().aggregators().size());
        for (Aggregator[] aggregators : context.aggregations().aggregators()) {
            ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>(aggregators.length);
            for (Aggregator aggregator : aggregators) {
                try {
                    aggregations.add(aggregator.buildTopLevel());
                }
                catch (IOException e) {
                    throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
                }
                aggregator.releaseAggregations();
            }
            internalAggregations.add(InternalAggregations.from(aggregations));
        }
        if (internalAggregations.size() > 1) {
            context.queryResult().aggregations(InternalAggregations.topLevelReduce(internalAggregations, context.aggregations().getAggregationReduceContextBuilder().forPartialReduction()));
        } else {
            context.queryResult().aggregations((InternalAggregations)internalAggregations.get(0));
        }
        context.aggregations(null);
    }
}

