/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.reservedstate.NonStateTransformResult;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTask;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTaskExecutor;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTaskExecutor;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class ReservedClusterStateService {
    private static final Logger logger = LogManager.getLogger(ReservedClusterStateService.class);
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    final Map<String, ReservedClusterStateHandler<?>> handlers;
    final ClusterService clusterService;
    private final MasterServiceTaskQueue<ReservedStateUpdateTask> updateTaskQueue;
    private final MasterServiceTaskQueue<ReservedStateErrorTask> errorTaskQueue;
    private final ConstructingObjectParser<ReservedStateChunk, Void> stateChunkParser = new ConstructingObjectParser("reserved_state_chunk", a -> {
        List tuples = (List)a[0];
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        for (Tuple tuple : tuples) {
            stateMap.put((String)tuple.v1(), tuple.v2());
        }
        return new ReservedStateChunk(stateMap, (ReservedStateVersion)a[1]);
    });

    public ReservedClusterStateService(ClusterService clusterService, List<ReservedClusterStateHandler<?>> handlerList) {
        this.clusterService = clusterService;
        this.updateTaskQueue = clusterService.createTaskQueue("reserved state update", Priority.URGENT, new ReservedStateUpdateTaskExecutor(clusterService.getRerouteService()));
        this.errorTaskQueue = clusterService.createTaskQueue("reserved state error", Priority.URGENT, new ReservedStateErrorTaskExecutor());
        this.handlers = handlerList.stream().collect(Collectors.toMap(ReservedClusterStateHandler::name, Function.identity()));
        this.stateChunkParser.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> {
            if (!this.handlers.containsKey(name)) {
                throw new IllegalStateException("Missing handler definition for content key [" + name + "]");
            }
            p.nextToken();
            return new Tuple((Object)name, this.handlers.get(name).fromXContent(p));
        }, STATE_FIELD);
        this.stateChunkParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ReservedStateVersion.parse(p), METADATA_FIELD);
    }

    ReservedStateChunk parse(String namespace, XContentParser parser) {
        try {
            return (ReservedStateChunk)this.stateChunkParser.apply(parser, null);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, (Long)-1L, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            throw new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + errorState, e);
        }
    }

    public void process(String namespace, XContentParser parser, Consumer<Exception> errorListener) {
        ReservedStateChunk stateChunk;
        try {
            stateChunk = this.parse(namespace, parser);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, (Long)-1L, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + errorState, e));
            return;
        }
        this.process(namespace, stateChunk, errorListener);
    }

    public void process(final String namespace, final ReservedStateChunk reservedStateChunk, final Consumer<Exception> errorListener) {
        LinkedHashSet<String> orderedHandlers;
        Map<String, Object> reservedState = reservedStateChunk.state();
        final ReservedStateVersion reservedStateVersion = reservedStateChunk.metadata();
        try {
            orderedHandlers = this.orderedStateHandlers(reservedState.keySet());
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, reservedStateVersion.version(), e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + errorState, e));
            return;
        }
        ClusterState state = this.clusterService.state();
        final ReservedStateMetadata existingMetadata = state.metadata().reservedStateMetadata().get(namespace);
        if (!ReservedStateUpdateTask.checkMetadataVersion(namespace, existingMetadata, reservedStateVersion)) {
            errorListener.accept(null);
            return;
        }
        TrialRunResult trialRunResult = this.trialRun(namespace, state, reservedStateChunk, orderedHandlers);
        Exception error = this.checkAndReportError(namespace, trialRunResult.errors, reservedStateVersion);
        if (error != null) {
            errorListener.accept(error);
            return;
        }
        this.executeNonStateTransformationSteps(trialRunResult.nonStateTransforms, new ActionListener<Collection<NonStateTransformResult>>(){

            @Override
            public void onResponse(Collection<NonStateTransformResult> nonStateTransformResults) {
                ReservedClusterStateService.this.updateTaskQueue.submitTask("reserved cluster state [" + namespace + "]", new ReservedStateUpdateTask(namespace, reservedStateChunk, nonStateTransformResults, ReservedClusterStateService.this.handlers, orderedHandlers, ReservedClusterStateService.this::updateErrorState, new ActionListener<ActionResponse.Empty>(){

                    @Override
                    public void onResponse(ActionResponse.Empty empty) {
                        logger.info("Successfully applied new reserved cluster state for namespace [{}]", (Object)namespace);
                        errorListener.accept(null);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (ReservedStateErrorTask.isNewError(existingMetadata, reservedStateVersion.version())) {
                            logger.debug("Failed to apply reserved cluster state", (Throwable)e);
                            errorListener.accept(e);
                        } else {
                            errorListener.accept(null);
                        }
                    }
                }), null);
            }

            @Override
            public void onFailure(Exception e) {
                errorListener.accept(ReservedClusterStateService.this.checkAndReportError(namespace, List.of(e.getMessage()), reservedStateVersion));
            }
        });
    }

    Exception checkAndReportError(String namespace, List<String> errors, ReservedStateVersion reservedStateVersion) {
        if (!errors.isEmpty()) {
            logger.debug("Error processing state change request for [{}] with the following errors [{}]", (Object)namespace, errors);
            ErrorState errorState = new ErrorState(namespace, reservedStateVersion.version(), errors, ReservedStateErrorMetadata.ErrorKind.VALIDATION);
            this.updateErrorState(errorState);
            return new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + errorState);
        }
        return null;
    }

    void updateErrorState(ErrorState errorState) {
        if (!ReservedStateErrorTask.checkErrorVersion(this.clusterService.state(), errorState)) {
            return;
        }
        this.submitErrorUpdateTask(errorState);
    }

    private void submitErrorUpdateTask(final ErrorState errorState) {
        this.errorTaskQueue.submitTask("reserved cluster state update error for [ " + errorState.namespace() + "]", new ReservedStateErrorTask(errorState, new ActionListener<ActionResponse.Empty>(){

            @Override
            public void onResponse(ActionResponse.Empty empty) {
                logger.info("Successfully applied new reserved error state for namespace [{}]", (Object)errorState.namespace());
            }

            @Override
            public void onFailure(Exception e) {
                logger.error("Failed to apply reserved error cluster state", (Throwable)e);
            }
        }), null);
    }

    TrialRunResult trialRun(String namespace, ClusterState currentState, ReservedStateChunk stateChunk, LinkedHashSet<String> orderedHandlers) {
        ReservedStateMetadata existingMetadata = currentState.metadata().reservedStateMetadata().get(namespace);
        Map<String, Object> reservedState = stateChunk.state();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<Consumer<ActionListener<NonStateTransformResult>>> nonStateTransforms = new ArrayList<Consumer<ActionListener<NonStateTransformResult>>>();
        ClusterState state = currentState;
        for (String handlerName : orderedHandlers) {
            ReservedClusterStateHandler<?> handler = this.handlers.get(handlerName);
            try {
                Set<String> existingKeys = ReservedStateUpdateTask.keysForHandler(existingMetadata, handlerName);
                TransformState transformState = handler.transform(reservedState.get(handlerName), new TransformState(state, existingKeys));
                state = transformState.state();
                if (transformState.nonStateTransform() == null) continue;
                nonStateTransforms.add(transformState.nonStateTransform());
            }
            catch (Exception e) {
                errors.add(Strings.format((String)"Error processing %s state change: %s", (Object[])new Object[]{handler.name(), ExceptionsHelper.stackTrace(e)}));
            }
        }
        return new TrialRunResult(nonStateTransforms, errors);
    }

    void executeNonStateTransformationSteps(List<Consumer<ActionListener<NonStateTransformResult>>> nonStateTransforms, ActionListener<Collection<NonStateTransformResult>> listener) {
        List result = Collections.synchronizedList(new ArrayList(nonStateTransforms.size()));
        try (RefCountingListener listeners = new RefCountingListener(listener.map(ignored -> result));){
            for (Consumer<ActionListener<NonStateTransformResult>> transform : nonStateTransforms) {
                transform.accept(listeners.acquire(result::add));
            }
        }
    }

    LinkedHashSet<String> orderedStateHandlers(Set<String> handlerNames) {
        LinkedHashSet<String> orderedHandlers = new LinkedHashSet<String>();
        LinkedHashSet<String> dependencyStack = new LinkedHashSet<String>();
        for (String key : handlerNames) {
            this.addStateHandler(key, handlerNames, orderedHandlers, dependencyStack);
        }
        return orderedHandlers;
    }

    private void addStateHandler(String key, Set<String> keys, LinkedHashSet<String> ordered, LinkedHashSet<String> visited) {
        if (visited.contains(key)) {
            StringBuilder msg = new StringBuilder("Cycle found in settings dependencies: ");
            visited.forEach(s -> {
                msg.append((String)s);
                msg.append(" -> ");
            });
            msg.append(key);
            throw new IllegalStateException(msg.toString());
        }
        if (ordered.contains(key)) {
            return;
        }
        visited.add(key);
        ReservedClusterStateHandler<?> handler = this.handlers.get(key);
        if (handler == null) {
            throw new IllegalStateException("Unknown handler type: " + key);
        }
        for (String dependency : handler.dependencies()) {
            if (!keys.contains(dependency)) {
                throw new IllegalStateException("Missing handler dependency definition: " + key + " -> " + dependency);
            }
            this.addStateHandler(dependency, keys, ordered, visited);
        }
        for (String dependency : handler.optionalDependencies()) {
            if (!keys.contains(dependency)) continue;
            this.addStateHandler(dependency, keys, ordered, visited);
        }
        visited.remove(key);
        ordered.add(key);
    }

    public void installStateHandler(ReservedClusterStateHandler<?> handler) {
        this.handlers.put(handler.name(), handler);
    }

    record TrialRunResult(List<Consumer<ActionListener<NonStateTransformResult>>> nonStateTransforms, List<String> errors) {
    }
}

