/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RepositoriesStats
implements Writeable,
ToXContentFragment {
    private final Map<String, ThrottlingStats> repositoryThrottlingStats;

    public RepositoriesStats(StreamInput in) throws IOException {
        this.repositoryThrottlingStats = in.getTransportVersion().onOrAfter(TransportVersion.V_8_500_011) ? in.readMap(ThrottlingStats::new) : new HashMap<String, ThrottlingStats>();
    }

    public RepositoriesStats(Map<String, ThrottlingStats> repositoryThrottlingStats) {
        this.repositoryThrottlingStats = new HashMap<String, ThrottlingStats>(repositoryThrottlingStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_500_011)) {
            out.writeMap(this.repositoryThrottlingStats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("repositories", this.repositoryThrottlingStats);
        return builder;
    }

    public Map<String, ThrottlingStats> getRepositoryThrottlingStats() {
        return Collections.unmodifiableMap(this.repositoryThrottlingStats);
    }

    public record ThrottlingStats(long totalReadThrottledNanos, long totalWriteThrottledNanos) implements ToXContentObject,
    Writeable
    {
        ThrottlingStats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (builder.humanReadable()) {
                builder.field("total_read_throttled_time", (Object)new TimeValue(this.totalReadThrottledNanos, TimeUnit.NANOSECONDS));
                builder.field("total_write_throttled_time", (Object)new TimeValue(this.totalWriteThrottledNanos, TimeUnit.NANOSECONDS));
            }
            builder.field("total_read_throttled_time_nanos", this.totalReadThrottledNanos);
            builder.field("total_write_throttled_time_nanos", this.totalWriteThrottledNanos);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.totalReadThrottledNanos);
            out.writeVLong(this.totalWriteThrottledNanos);
        }
    }
}

