/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.plugins.PluginApiInfo;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record PluginRuntimeInfo(PluginDescriptor descriptor, @Nullable Boolean isOfficial, @Nullable PluginApiInfo pluginApiInfo) implements Writeable,
ToXContentObject
{
    public PluginRuntimeInfo(PluginDescriptor descriptor) {
        this(descriptor, false, null);
    }

    public PluginRuntimeInfo(StreamInput in) throws IOException {
        this(new PluginDescriptor(in), PluginRuntimeInfo.readIsOfficial(in), PluginRuntimeInfo.readApiInfo(in));
    }

    private static Boolean readIsOfficial(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_3_0)) {
            return in.readBoolean();
        }
        return null;
    }

    private static PluginApiInfo readApiInfo(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_3_0)) {
            return in.readOptionalWriteable(PluginApiInfo::new);
        }
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.descriptor.toXContentFragment(builder, params);
        if (this.isOfficial != null) {
            builder.field("is_official", this.isOfficial);
        }
        if (this.pluginApiInfo != null) {
            this.pluginApiInfo.toXContent(builder, params);
        }
        builder.endObject();
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.descriptor.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_3_0)) {
            out.writeBoolean(this.isOfficial);
            out.writeOptionalWriteable(this.pluginApiInfo);
        }
    }
}

