/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.internal;

import java.util.List;
import java.util.ServiceLoader;
import org.elasticsearch.Build;

public interface BuildExtension {
    public Build getCurrentBuild();

    public static BuildExtension load() {
        ServiceLoader<BuildExtension> loader = ServiceLoader.load(BuildExtension.class);
        List<ServiceLoader.Provider<BuildExtension>> extensions = loader.stream().toList();
        if (extensions.size() > 1) {
            throw new IllegalStateException("More than one build extension found");
        }
        if (extensions.size() == 0) {
            return null;
        }
        return extensions.get(0).get();
    }
}

