/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AdjustableSemaphore;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.node.NodeRoleSettings;

public class RecoverySettings {
    public static final Version SNAPSHOT_RECOVERIES_SUPPORTED_VERSION = Version.V_7_15_0;
    public static final IndexVersion SNAPSHOT_RECOVERIES_SUPPORTED_INDEX_VERSION = IndexVersion.V_7_15_0;
    public static final TransportVersion SNAPSHOT_RECOVERIES_SUPPORTED_TRANSPORT_VERSION = TransportVersion.V_7_15_0;
    public static final IndexVersion SEQ_NO_SNAPSHOT_RECOVERIES_SUPPORTED_VERSION = IndexVersion.V_7_16_0;
    public static final TransportVersion SNAPSHOT_FILE_DOWNLOAD_THROTTLING_SUPPORTED_TRANSPORT_VERSION = TransportVersion.V_7_16_0;
    private static final Logger logger = LogManager.getLogger(RecoverySettings.class);
    static final Setting<ByteSizeValue> TOTAL_PHYSICAL_MEMORY_OVERRIDING_TEST_SETTING = Setting.byteSizeSetting("recovery_settings.total_physical_memory_override", settings -> ByteSizeValue.ofBytes(OsProbe.getInstance().getTotalPhysicalMemorySize()).getStringRep(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> NODE_BANDWIDTH_RECOVERY_DISK_WRITE_SETTING = RecoverySettings.bandwidthSetting("node.bandwidth.recovery.disk.write");
    public static final Setting<ByteSizeValue> NODE_BANDWIDTH_RECOVERY_DISK_READ_SETTING = RecoverySettings.bandwidthSetting("node.bandwidth.recovery.disk.read");
    public static final Setting<ByteSizeValue> NODE_BANDWIDTH_RECOVERY_NETWORK_SETTING = RecoverySettings.bandwidthSetting("node.bandwidth.recovery.network");
    static final double DEFAULT_FACTOR_VALUE = 0.4;
    public static final Setting<Double> NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_SETTING = RecoverySettings.operatorFactorSetting("node.bandwidth.recovery.operator.factor", 0.4);
    public static final Setting<Double> NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_WRITE_SETTING = RecoverySettings.operatorFactorSetting("node.bandwidth.recovery.operator.factor.write");
    public static final Setting<Double> NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_READ_SETTING = RecoverySettings.operatorFactorSetting("node.bandwidth.recovery.operator.factor.read");
    public static final Setting<Double> NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_MAX_OVERCOMMIT_SETTING = Setting.doubleSetting("node.bandwidth.recovery.operator.factor.max_overcommit", 100.0, 1.0, Double.MAX_VALUE, Setting.Property.NodeScope, Setting.Property.OperatorDynamic);
    public static final Setting<Double> NODE_BANDWIDTH_RECOVERY_FACTOR_WRITE_SETTING = RecoverySettings.factorSetting("node.bandwidth.recovery.factor.write", NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_WRITE_SETTING);
    public static final Setting<Double> NODE_BANDWIDTH_RECOVERY_FACTOR_READ_SETTING = RecoverySettings.factorSetting("node.bandwidth.recovery.factor.read", NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_READ_SETTING);
    static final List<Setting<?>> NODE_BANDWIDTH_RECOVERY_SETTINGS = List.of(NODE_BANDWIDTH_RECOVERY_NETWORK_SETTING, NODE_BANDWIDTH_RECOVERY_DISK_READ_SETTING, NODE_BANDWIDTH_RECOVERY_DISK_WRITE_SETTING);
    static final ByteSizeValue DEFAULT_MAX_BYTES_PER_SEC = new ByteSizeValue(40L, ByteSizeUnit.MB);
    public static final Setting<ByteSizeValue> INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("indices.recovery.max_bytes_per_sec", s -> {
        List<DiscoveryNodeRole> roles = NodeRoleSettings.NODE_ROLES_SETTING.get((Settings)s);
        List<DiscoveryNodeRole> dataRoles = roles.stream().filter(DiscoveryNodeRole::canContainData).toList();
        if (dataRoles.isEmpty()) {
            return DEFAULT_MAX_BYTES_PER_SEC.getStringRep();
        }
        if (!dataRoles.stream().allMatch(dn -> dn.equals(DiscoveryNodeRole.DATA_COLD_NODE_ROLE) || dn.equals(DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE))) {
            return DEFAULT_MAX_BYTES_PER_SEC.getStringRep();
        }
        ByteSizeValue totalPhysicalMemory = TOTAL_PHYSICAL_MEMORY_OVERRIDING_TEST_SETTING.get((Settings)s);
        ByteSizeValue maxBytesPerSec = totalPhysicalMemory.compareTo(new ByteSizeValue(4L, ByteSizeUnit.GB)) <= 0 ? new ByteSizeValue(40L, ByteSizeUnit.MB) : (totalPhysicalMemory.compareTo(new ByteSizeValue(8L, ByteSizeUnit.GB)) <= 0 ? new ByteSizeValue(60L, ByteSizeUnit.MB) : (totalPhysicalMemory.compareTo(new ByteSizeValue(16L, ByteSizeUnit.GB)) <= 0 ? new ByteSizeValue(90L, ByteSizeUnit.MB) : (totalPhysicalMemory.compareTo(new ByteSizeValue(32L, ByteSizeUnit.GB)) <= 0 ? new ByteSizeValue(125L, ByteSizeUnit.MB) : new ByteSizeValue(250L, ByteSizeUnit.MB))));
        return maxBytesPerSec.getStringRep();
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING = Setting.intSetting("indices.recovery.max_concurrent_file_chunks", 2, 1, 8, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING = Setting.intSetting("indices.recovery.max_concurrent_operations", 1, 1, 4, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING = Setting.positiveTimeSetting("indices.recovery.retry_delay_state_sync", TimeValue.timeValueMillis((long)500L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING = Setting.positiveTimeSetting("indices.recovery.retry_delay_network", TimeValue.timeValueSeconds((long)5L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.recovery.internal_action_timeout", TimeValue.timeValueMinutes((long)15L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_INTERNAL_ACTION_RETRY_TIMEOUT_SETTING = Setting.positiveTimeSetting("indices.recovery.internal_action_retry_timeout", TimeValue.timeValueMinutes((long)1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING = Setting.timeSetting("indices.recovery.internal_action_long_timeout", s -> TimeValue.timeValueMillis((long)(INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING.get((Settings)s).millis() * 2L)), TimeValue.timeValueSeconds((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING = Setting.timeSetting("indices.recovery.recovery_activity_timeout", INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING::get, TimeValue.timeValueSeconds((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_RECOVERY_USE_SNAPSHOTS_SETTING = Setting.boolSetting("indices.recovery.use_snapshots", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS = Setting.intSetting("indices.recovery.max_concurrent_snapshot_file_downloads", 5, 1, 20, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS_PER_NODE = new Setting<Integer>("indices.recovery.max_concurrent_snapshot_file_downloads_per_node", "25", s -> Setting.parseInt(s, 1, 25, "indices.recovery.max_concurrent_snapshot_file_downloads_per_node", false), new Setting.Validator<Integer>(){
        private final Collection<Setting<?>> dependencies = Collections.singletonList(INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS);

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxConcurrentSnapshotFileDownloadsPerNode, Map<Setting<?>, Object> settings) {
            int maxConcurrentSnapshotFileDownloads = (Integer)settings.get(INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS);
            if (maxConcurrentSnapshotFileDownloadsPerNode < maxConcurrentSnapshotFileDownloads) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s]=%d is less than [%s]=%d", INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS_PER_NODE.getKey(), maxConcurrentSnapshotFileDownloadsPerNode, INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS.getKey(), maxConcurrentSnapshotFileDownloads));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return this.dependencies.iterator();
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ByteSizeValue DEFAULT_CHUNK_SIZE = new ByteSizeValue(512L, ByteSizeUnit.KB);
    private volatile ByteSizeValue maxBytesPerSec;
    private volatile int maxConcurrentFileChunks;
    private volatile int maxConcurrentOperations;
    private volatile RateLimiter.SimpleRateLimiter rateLimiter;
    private volatile TimeValue retryDelayStateSync;
    private volatile TimeValue retryDelayNetwork;
    private volatile TimeValue activityTimeout;
    private volatile TimeValue internalActionTimeout;
    private volatile TimeValue internalActionRetryTimeout;
    private volatile TimeValue internalActionLongTimeout;
    private volatile boolean useSnapshotsDuringRecovery;
    private final boolean nodeBandwidthSettingsExist;
    private volatile int maxConcurrentSnapshotFileDownloads;
    private volatile int maxConcurrentSnapshotFileDownloadsPerNode;
    private volatile int maxConcurrentIncomingRecoveries;
    private final AdjustableSemaphore maxSnapshotFileDownloadsPerNodeSemaphore;
    private volatile ByteSizeValue chunkSize = DEFAULT_CHUNK_SIZE;
    private final ByteSizeValue availableNetworkBandwidth;
    private final ByteSizeValue availableDiskReadBandwidth;
    private final ByteSizeValue availableDiskWriteBandwidth;

    private static Setting<ByteSizeValue> bandwidthSetting(String key) {
        return new Setting<ByteSizeValue>(key, ByteSizeValue.MINUS_ONE.getStringRep(), s -> {
            ByteSizeValue value = ByteSizeValue.parseBytesSizeValue(s, key);
            if (ByteSizeValue.MINUS_ONE.equals(value)) {
                return value;
            }
            if (value.getBytes() <= 0L) {
                throw new IllegalArgumentException("Failed to parse value [" + s + "] for bandwidth setting [" + key + "], must be > [" + ByteSizeValue.ZERO.getStringRep() + "]");
            }
            if (value.getBytes() >= Long.MAX_VALUE) {
                throw new IllegalArgumentException("Failed to parse value [" + s + "] for bandwidth setting [" + key + "], must be < [" + ByteSizeValue.ofBytes(Long.MAX_VALUE).getStringRep() + "]");
            }
            return value;
        }, Setting.Property.NodeScope);
    }

    private static Setting<Double> operatorFactorSetting(String key, double defaultValue) {
        return new Setting<Double>(key, Double.toString(defaultValue), s -> Setting.parseDouble(s, 0.0, 1.0, key, new Setting.Property[0]), v -> {
            if (v == 0.0) {
                throw new IllegalArgumentException("Failed to validate value [" + v + "] for factor setting [" + key + "] must be > [0]");
            }
        }, Setting.Property.NodeScope, Setting.Property.OperatorDynamic);
    }

    private static Setting<Double> operatorFactorSetting(String key) {
        return new Setting<Double>(key, NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_SETTING, s -> Setting.parseDouble(s, 0.0, 1.0, key, new Setting.Property[0]), v -> {
            if (v == 0.0) {
                throw new IllegalArgumentException("Failed to validate value [" + v + "] for factor setting [" + key + "] must be > [0]");
            }
        }, Setting.Property.NodeScope, Setting.Property.OperatorDynamic);
    }

    private static Setting<Double> factorSetting(String key, Setting<Double> operatorFallback) {
        return new Setting<Double>(key, operatorFallback, s -> Setting.parseDouble(s, 0.0, 1.0, key, new Setting.Property[0]), v -> {
            if (v == 0.0) {
                throw new IllegalArgumentException("Failed to validate value [" + v + "] for factor setting [" + key + "] must be > [0]");
            }
        }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    }

    public RecoverySettings(Settings settings, ClusterSettings clusterSettings) {
        this.retryDelayStateSync = INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING.get(settings);
        this.maxConcurrentFileChunks = INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING.get(settings);
        this.maxConcurrentOperations = INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING.get(settings);
        this.retryDelayNetwork = INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING.get(settings);
        this.internalActionTimeout = INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING.get(settings);
        this.internalActionRetryTimeout = INDICES_RECOVERY_INTERNAL_ACTION_RETRY_TIMEOUT_SETTING.get(settings);
        this.internalActionLongTimeout = INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING.get(settings);
        this.activityTimeout = INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING.get(settings);
        this.useSnapshotsDuringRecovery = INDICES_RECOVERY_USE_SNAPSHOTS_SETTING.get(settings);
        this.maxConcurrentSnapshotFileDownloads = INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS.get(settings);
        this.maxConcurrentSnapshotFileDownloadsPerNode = INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS_PER_NODE.get(settings);
        this.maxConcurrentIncomingRecoveries = ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.get(settings);
        this.maxSnapshotFileDownloadsPerNodeSemaphore = new AdjustableSemaphore(this.maxConcurrentSnapshotFileDownloadsPerNode, true);
        this.availableNetworkBandwidth = NODE_BANDWIDTH_RECOVERY_NETWORK_SETTING.get(settings);
        this.availableDiskReadBandwidth = NODE_BANDWIDTH_RECOVERY_DISK_READ_SETTING.get(settings);
        this.availableDiskWriteBandwidth = NODE_BANDWIDTH_RECOVERY_DISK_WRITE_SETTING.get(settings);
        RecoverySettings.validateNodeBandwidthRecoverySettings(settings);
        this.nodeBandwidthSettingsExist = RecoverySettings.hasNodeBandwidthRecoverySettings(settings);
        this.computeMaxBytesPerSec(settings);
        if (DiscoveryNode.canContainData(settings)) {
            clusterSettings.addSettingsUpdateConsumer(this::computeMaxBytesPerSec, List.of(INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING, NODE_BANDWIDTH_RECOVERY_FACTOR_READ_SETTING, NODE_BANDWIDTH_RECOVERY_FACTOR_WRITE_SETTING, NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_SETTING, NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_READ_SETTING, NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_WRITE_SETTING, NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_MAX_OVERCOMMIT_SETTING, NODE_BANDWIDTH_RECOVERY_DISK_WRITE_SETTING, NODE_BANDWIDTH_RECOVERY_DISK_READ_SETTING, NODE_BANDWIDTH_RECOVERY_NETWORK_SETTING, NodeRoleSettings.NODE_ROLES_SETTING));
        }
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING, this::setMaxConcurrentFileChunks);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING, this::setMaxConcurrentOperations);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING, this::setRetryDelayStateSync);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING, this::setRetryDelayNetwork);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING, this::setInternalActionTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_INTERNAL_LONG_ACTION_TIMEOUT_SETTING, this::setInternalActionLongTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_INTERNAL_ACTION_RETRY_TIMEOUT_SETTING, this::setInternalActionRetryTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING, this::setActivityTimeout);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_USE_SNAPSHOTS_SETTING, this::setUseSnapshotsDuringRecovery);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS, this::setMaxConcurrentSnapshotFileDownloads);
        clusterSettings.addSettingsUpdateConsumer(INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS_PER_NODE, this::setMaxConcurrentSnapshotFileDownloadsPerNode);
        clusterSettings.addSettingsUpdateConsumer(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING, this::setMaxConcurrentIncomingRecoveries);
    }

    private void computeMaxBytesPerSec(Settings settings) {
        long writeBytesPerSec;
        long readBytesPerSec;
        long defaultBytesPerSec = Math.max(INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.get(settings).getBytes(), 0L);
        long networkBandwidthBytesPerSec = Math.max(this.availableNetworkBandwidth.getBytes(), 0L);
        if (this.availableDiskReadBandwidth.getBytes() > 0L && networkBandwidthBytesPerSec > 0L) {
            double readFactor = NODE_BANDWIDTH_RECOVERY_FACTOR_READ_SETTING.get(settings);
            readBytesPerSec = Math.round((double)Math.min(this.availableDiskReadBandwidth.getBytes(), networkBandwidthBytesPerSec) * readFactor);
        } else {
            readBytesPerSec = 0L;
        }
        if (this.availableDiskWriteBandwidth.getBytes() > 0L && networkBandwidthBytesPerSec > 0L) {
            double writeFactor = NODE_BANDWIDTH_RECOVERY_FACTOR_WRITE_SETTING.get(settings);
            writeBytesPerSec = Math.round((double)Math.min(this.availableDiskWriteBandwidth.getBytes(), networkBandwidthBytesPerSec) * writeFactor);
        } else {
            writeBytesPerSec = 0L;
        }
        long availableBytesPerSec = Math.min(readBytesPerSec, writeBytesPerSec);
        assert (this.nodeBandwidthSettingsExist == (availableBytesPerSec != 0L));
        long maxBytesPerSec = availableBytesPerSec == 0L || INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.exists(settings) || !DiscoveryNode.canContainData(settings) ? defaultBytesPerSec : Math.max(defaultBytesPerSec, availableBytesPerSec);
        long maxAllowedBytesPerSec = Math.round((double)Math.max(Math.min(Math.min(this.availableDiskReadBandwidth.getBytes(), this.availableDiskWriteBandwidth.getBytes()), networkBandwidthBytesPerSec), 0L) * NODE_BANDWIDTH_RECOVERY_OPERATOR_FACTOR_MAX_OVERCOMMIT_SETTING.get(settings));
        ByteSizeValue finalMaxBytesPerSec = maxAllowedBytesPerSec > 0L ? (maxBytesPerSec > 0L ? ByteSizeValue.ofBytes(Math.min(maxBytesPerSec, maxAllowedBytesPerSec)) : ByteSizeValue.ofBytes(maxAllowedBytesPerSec)) : ByteSizeValue.ofBytes(maxBytesPerSec);
        logger.info(() -> Strings.format((String)"using rate limit [%s] with [default=%s, read=%s, write=%s, max=%s]", (Object[])new Object[]{finalMaxBytesPerSec, ByteSizeValue.ofBytes(defaultBytesPerSec), ByteSizeValue.ofBytes(readBytesPerSec), ByteSizeValue.ofBytes(writeBytesPerSec), ByteSizeValue.ofBytes(maxAllowedBytesPerSec)}));
        this.setMaxBytesPerSec(finalMaxBytesPerSec);
    }

    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    public TimeValue retryDelayNetwork() {
        return this.retryDelayNetwork;
    }

    public TimeValue retryDelayStateSync() {
        return this.retryDelayStateSync;
    }

    public TimeValue activityTimeout() {
        return this.activityTimeout;
    }

    public TimeValue internalActionTimeout() {
        return this.internalActionTimeout;
    }

    public TimeValue internalActionRetryTimeout() {
        return this.internalActionRetryTimeout;
    }

    public TimeValue internalActionLongTimeout() {
        return this.internalActionLongTimeout;
    }

    public ByteSizeValue getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(ByteSizeValue chunkSize) {
        if (chunkSize.bytesAsInt() <= 0) {
            throw new IllegalArgumentException("chunkSize must be > 0");
        }
        this.chunkSize = chunkSize;
    }

    public void setRetryDelayStateSync(TimeValue retryDelayStateSync) {
        this.retryDelayStateSync = retryDelayStateSync;
    }

    public void setRetryDelayNetwork(TimeValue retryDelayNetwork) {
        this.retryDelayNetwork = retryDelayNetwork;
    }

    public void setActivityTimeout(TimeValue activityTimeout) {
        this.activityTimeout = activityTimeout;
    }

    public void setInternalActionTimeout(TimeValue internalActionTimeout) {
        this.internalActionTimeout = internalActionTimeout;
    }

    public void setInternalActionLongTimeout(TimeValue internalActionLongTimeout) {
        this.internalActionLongTimeout = internalActionLongTimeout;
    }

    public void setInternalActionRetryTimeout(TimeValue internalActionRetryTimeout) {
        this.internalActionRetryTimeout = internalActionRetryTimeout;
    }

    private void setMaxBytesPerSec(ByteSizeValue maxBytesPerSec) {
        this.maxBytesPerSec = maxBytesPerSec;
        if (maxBytesPerSec.getBytes() <= 0L) {
            this.rateLimiter = null;
        } else if (this.rateLimiter != null) {
            this.rateLimiter.setMBPerSec(maxBytesPerSec.getMbFrac());
        } else {
            this.rateLimiter = new RateLimiter.SimpleRateLimiter(maxBytesPerSec.getMbFrac());
        }
    }

    public ByteSizeValue getMaxBytesPerSec() {
        return this.maxBytesPerSec;
    }

    public int getMaxConcurrentFileChunks() {
        return this.maxConcurrentFileChunks;
    }

    private void setMaxConcurrentFileChunks(int maxConcurrentFileChunks) {
        this.maxConcurrentFileChunks = maxConcurrentFileChunks;
    }

    public int getMaxConcurrentOperations() {
        return this.maxConcurrentOperations;
    }

    private void setMaxConcurrentOperations(int maxConcurrentOperations) {
        this.maxConcurrentOperations = maxConcurrentOperations;
    }

    public boolean nodeBandwidthSettingsExist() {
        return this.nodeBandwidthSettingsExist;
    }

    public boolean getUseSnapshotsDuringRecovery() {
        return this.useSnapshotsDuringRecovery;
    }

    private void setUseSnapshotsDuringRecovery(boolean useSnapshotsDuringRecovery) {
        this.useSnapshotsDuringRecovery = useSnapshotsDuringRecovery;
    }

    public int getMaxConcurrentSnapshotFileDownloads() {
        return this.maxConcurrentSnapshotFileDownloads;
    }

    public void setMaxConcurrentSnapshotFileDownloads(int maxConcurrentSnapshotFileDownloads) {
        this.maxConcurrentSnapshotFileDownloads = maxConcurrentSnapshotFileDownloads;
    }

    private void setMaxConcurrentIncomingRecoveries(int maxConcurrentIncomingRecoveries) {
        this.maxConcurrentIncomingRecoveries = maxConcurrentIncomingRecoveries;
    }

    private void setMaxConcurrentSnapshotFileDownloadsPerNode(int maxConcurrentSnapshotFileDownloadsPerNode) {
        this.maxConcurrentSnapshotFileDownloadsPerNode = maxConcurrentSnapshotFileDownloadsPerNode;
        this.maxSnapshotFileDownloadsPerNodeSemaphore.setMaxPermits(maxConcurrentSnapshotFileDownloadsPerNode);
    }

    @Nullable
    Releasable tryAcquireSnapshotDownloadPermits() {
        if (!this.getUseSnapshotsDuringRecovery()) {
            return null;
        }
        int maxConcurrentSnapshotFileDownloads = this.getMaxConcurrentSnapshotFileDownloads();
        boolean permitAcquired = this.maxSnapshotFileDownloadsPerNodeSemaphore.tryAcquire(maxConcurrentSnapshotFileDownloads);
        if (!permitAcquired) {
            if (this.maxConcurrentIncomingRecoveries <= this.maxConcurrentSnapshotFileDownloadsPerNode) {
                logger.warn(String.format(Locale.ROOT, "Unable to acquire permit to use snapshot files during recovery, so this recovery will recover index files from the source node. Ensure snapshot files can be used during recovery by setting [%s] to be no greater than [%d]. Current values of [%s] = [%d], [%s] = [%d]\n", INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS.getKey(), this.maxConcurrentSnapshotFileDownloadsPerNode / Math.max(1, this.maxConcurrentIncomingRecoveries), INDICES_RECOVERY_MAX_CONCURRENT_SNAPSHOT_FILE_DOWNLOADS_PER_NODE.getKey(), this.maxConcurrentSnapshotFileDownloadsPerNode, ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), this.maxConcurrentIncomingRecoveries));
            } else {
                logger.warn(String.format(Locale.ROOT, "Unable to acquire permit to use snapshot files during recovery, so this recovery will recover index files from the source node. Ensure snapshot files can be used during recovery by reducing [%s] from its current value of [%d] to be no greater than [%d], or disable snapshot-based recovery by setting [%s] to [false]\n", ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), this.maxConcurrentIncomingRecoveries, this.maxConcurrentSnapshotFileDownloadsPerNode, INDICES_RECOVERY_USE_SNAPSHOTS_SETTING.getKey()));
            }
            return null;
        }
        return Releasables.releaseOnce(() -> this.maxSnapshotFileDownloadsPerNodeSemaphore.release(maxConcurrentSnapshotFileDownloads));
    }

    private static void validateNodeBandwidthRecoverySettings(Settings settings) {
        List<String> nonDefaults = NODE_BANDWIDTH_RECOVERY_SETTINGS.stream().filter(setting -> setting.get(settings) != ByteSizeValue.MINUS_ONE).map(Setting::getKey).toList();
        if (!nonDefaults.isEmpty() && nonDefaults.size() != NODE_BANDWIDTH_RECOVERY_SETTINGS.size()) {
            throw new IllegalArgumentException("Settings " + NODE_BANDWIDTH_RECOVERY_SETTINGS.stream().map(Setting::getKey).toList() + " must all be defined or all be undefined; but only settings " + nonDefaults + " are configured.");
        }
    }

    private static boolean hasNodeBandwidthRecoverySettings(Settings settings) {
        return NODE_BANDWIDTH_RECOVERY_SETTINGS.stream().filter(setting -> setting.get(settings) != ByteSizeValue.MINUS_ONE).count() == (long)NODE_BANDWIDTH_RECOVERY_SETTINGS.size();
    }
}

