/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.ShardCoreKeyMap;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.shard.ShardId;

public class IndicesQueryCache
implements QueryCache,
Closeable {
    private static final Logger logger = LogManager.getLogger(IndicesQueryCache.class);
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE_SETTING = Setting.memorySizeSetting("indices.queries.cache.size", "10%", Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_CACHE_QUERY_COUNT_SETTING = Setting.intSetting("indices.queries.cache.count", 10000, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING = Setting.boolSetting("indices.queries.cache.all_segments", false, Setting.Property.NodeScope);
    private final LRUQueryCache cache;
    private final ShardCoreKeyMap shardKeyMap = new ShardCoreKeyMap();
    private final Map<ShardId, Stats> shardStats = new ConcurrentHashMap<ShardId, Stats>();
    private volatile long sharedRamBytesUsed;
    private final Map<Object, StatsAndCount> stats2 = Collections.synchronizedMap(new IdentityHashMap());

    public IndicesQueryCache(Settings settings) {
        ByteSizeValue size = INDICES_CACHE_QUERY_SIZE_SETTING.get(settings);
        int count = INDICES_CACHE_QUERY_COUNT_SETTING.get(settings);
        logger.debug("using [node] query cache with size [{}] max filter count [{}]", (Object)size, (Object)count);
        this.cache = INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING.get(settings) != false ? new ElasticsearchLRUQueryCache(count, size.getBytes(), context -> true, 10.0f) : new ElasticsearchLRUQueryCache(count, size.getBytes());
        this.sharedRamBytesUsed = 0L;
    }

    public QueryCacheStats getStats(ShardId shard) {
        HashMap<ShardId, QueryCacheStats> stats = new HashMap<ShardId, QueryCacheStats>();
        for (Map.Entry<ShardId, Stats> entry : this.shardStats.entrySet()) {
            stats.put(entry.getKey(), entry.getValue().toQueryCacheStats());
        }
        QueryCacheStats shardStats = new QueryCacheStats();
        QueryCacheStats info = (QueryCacheStats)stats.get(shard);
        if (info == null) {
            info = new QueryCacheStats();
        }
        shardStats.add(info);
        if (!stats.isEmpty()) {
            long totalSize = 0L;
            for (QueryCacheStats s : stats.values()) {
                totalSize += s.getCacheSize();
            }
            double weight = totalSize == 0L ? 1.0 / (double)stats.size() : (double)shardStats.getCacheSize() / (double)totalSize;
            long additionalRamBytesUsed = Math.round(weight * (double)this.sharedRamBytesUsed);
            assert (additionalRamBytesUsed >= 0L) : additionalRamBytesUsed;
            shardStats.add(new QueryCacheStats(additionalRamBytesUsed, 0L, 0L, 0L, 0L));
        }
        return shardStats;
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        while (weight instanceof CachingWeightWrapper) {
            weight = ((CachingWeightWrapper)weight).in;
        }
        Weight in = this.cache.doCache(weight, policy);
        return new CachingWeightWrapper(in);
    }

    public void clearIndex(String index) {
        Set<Object> coreCacheKeys = this.shardKeyMap.getCoreKeysForIndex(index);
        for (Object coreKey : coreCacheKeys) {
            this.cache.clearCoreCacheKey(coreKey);
        }
        if (this.cache.getCacheSize() == 0L) {
            this.cache.clear();
        }
    }

    @Override
    public void close() {
        assert (this.shardKeyMap.size() == 0) : this.shardKeyMap.size();
        assert (this.shardStats.isEmpty()) : this.shardStats.keySet();
        assert (this.stats2.isEmpty()) : this.stats2;
        this.cache.clear();
    }

    private static boolean empty(Stats stats) {
        if (stats == null) {
            return true;
        }
        return stats.cacheSize == 0L && stats.ramBytesUsed == 0L;
    }

    public void onClose(ShardId shardId) {
        assert (IndicesQueryCache.empty(this.shardStats.get(shardId)));
        this.shardStats.remove(shardId);
    }

    private class ElasticsearchLRUQueryCache
    extends LRUQueryCache {
        ElasticsearchLRUQueryCache(int maxSize, long maxRamBytesUsed, Predicate<LeafReaderContext> leavesToCache, float skipFactor) {
            super(maxSize, maxRamBytesUsed, leavesToCache, skipFactor);
        }

        ElasticsearchLRUQueryCache(int maxSize, long maxRamBytesUsed) {
            super(maxSize, maxRamBytesUsed);
        }

        private Stats getStats(Object coreKey) {
            ShardId shardId = IndicesQueryCache.this.shardKeyMap.getShardId(coreKey);
            if (shardId == null) {
                return null;
            }
            return IndicesQueryCache.this.shardStats.get(shardId);
        }

        private Stats getOrCreateStats(Object coreKey) {
            return IndicesQueryCache.this.shardStats.computeIfAbsent(IndicesQueryCache.this.shardKeyMap.getShardId(coreKey), Stats::new);
        }

        protected void onClear() {
            super.onClear();
            for (Stats stats : IndicesQueryCache.this.shardStats.values()) {
                stats.cacheSize = 0L;
                stats.ramBytesUsed = 0L;
            }
            IndicesQueryCache.this.stats2.clear();
            IndicesQueryCache.this.sharedRamBytesUsed = 0L;
        }

        protected void onQueryCache(Query filter, long ramBytesUsed) {
            super.onQueryCache(filter, ramBytesUsed);
            IndicesQueryCache.this.sharedRamBytesUsed += ramBytesUsed;
        }

        protected void onQueryEviction(Query filter, long ramBytesUsed) {
            super.onQueryEviction(filter, ramBytesUsed);
            IndicesQueryCache.this.sharedRamBytesUsed -= ramBytesUsed;
        }

        protected void onDocIdSetCache(Object readerCoreKey, long ramBytesUsed) {
            super.onDocIdSetCache(readerCoreKey, ramBytesUsed);
            Stats shardStats = this.getOrCreateStats(readerCoreKey);
            ++shardStats.cacheSize;
            ++shardStats.cacheCount;
            shardStats.ramBytesUsed += ramBytesUsed;
            StatsAndCount statsAndCount = IndicesQueryCache.this.stats2.get(readerCoreKey);
            if (statsAndCount == null) {
                statsAndCount = new StatsAndCount(shardStats);
                IndicesQueryCache.this.stats2.put(readerCoreKey, statsAndCount);
            }
            ++statsAndCount.count;
        }

        protected void onDocIdSetEviction(Object readerCoreKey, int numEntries, long sumRamBytesUsed) {
            super.onDocIdSetEviction(readerCoreKey, numEntries, sumRamBytesUsed);
            if (numEntries > 0) {
                StatsAndCount statsAndCount = IndicesQueryCache.this.stats2.get(readerCoreKey);
                Stats shardStats = statsAndCount.stats;
                shardStats.cacheSize -= (long)numEntries;
                shardStats.ramBytesUsed -= sumRamBytesUsed;
                statsAndCount.count -= numEntries;
                if (statsAndCount.count == 0) {
                    IndicesQueryCache.this.stats2.remove(readerCoreKey);
                }
            }
        }

        protected void onHit(Object readerCoreKey, Query filter) {
            super.onHit(readerCoreKey, filter);
            Stats shardStats = this.getStats(readerCoreKey);
            ++shardStats.hitCount;
        }

        protected void onMiss(Object readerCoreKey, Query filter) {
            super.onMiss(readerCoreKey, filter);
            Stats shardStats = this.getOrCreateStats(readerCoreKey);
            ++shardStats.missCount;
        }
    }

    private static class Stats
    implements Cloneable {
        final ShardId shardId;
        volatile long ramBytesUsed;
        volatile long hitCount;
        volatile long missCount;
        volatile long cacheCount;
        volatile long cacheSize;

        Stats(ShardId shardId) {
            this.shardId = shardId;
        }

        QueryCacheStats toQueryCacheStats() {
            return new QueryCacheStats(this.ramBytesUsed, this.hitCount, this.missCount, this.cacheCount, this.cacheSize);
        }

        public String toString() {
            return "{shardId=" + this.shardId + ", ramBytedUsed=" + this.ramBytesUsed + ", hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", cacheCount=" + this.cacheCount + ", cacheSize=" + this.cacheSize + "}";
        }
    }

    private class CachingWeightWrapper
    extends Weight {
        private final Weight in;

        protected CachingWeightWrapper(Weight in) {
            super(in.getQuery());
            this.in = in;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.explain(context, doc);
        }

        public int count(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.count(context);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.scorer(context);
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.scorerSupplier(context);
        }

        public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.bulkScorer(context);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }
    }

    private static class StatsAndCount {
        volatile int count;
        final Stats stats;

        StatsAndCount(Stats stats) {
            this.stats = stats;
            this.count = 0;
        }

        public String toString() {
            return "{stats=" + this.stats + " ,count=" + this.count + "}";
        }
    }
}

