/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GlobalCheckpointSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static String ACTION_NAME = "indices:admin/seq_no/global_checkpoint_sync";
    public static ActionType<ReplicationResponse> TYPE = new ActionType<ReplicationResponse>(ACTION_NAME, ReplicationResponse::new);

    @Inject
    public GlobalCheckpointSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, Request::new, Request::new, "write", false, true);
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard indexShard, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        GlobalCheckpointSyncAction.maybeSyncTranslog(indexShard, listener.map(v -> new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse())));
    }

    @Override
    protected void shardOperationOnReplica(Request shardRequest, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        GlobalCheckpointSyncAction.maybeSyncTranslog(replica, listener.map(v -> new TransportReplicationAction.ReplicaResult()));
    }

    private static <T> void maybeSyncTranslog(IndexShard indexShard, ActionListener<Void> listener) {
        if (indexShard.getTranslogDurability() == Translog.Durability.REQUEST && indexShard.getLastSyncedGlobalCheckpoint() < indexShard.getLastKnownGlobalCheckpoint()) {
            indexShard.syncGlobalCheckpoint(indexShard.getLastKnownGlobalCheckpoint(), e -> {
                if (e == null) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Exception)e);
                }
            });
        } else {
            listener.onResponse(null);
        }
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(ShardId shardId) {
            super(shardId);
        }

        @Override
        public String toString() {
            return "GlobalCheckpointSyncAction.Request{shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + "', waitForActiveShards=" + this.waitForActiveShards + "}";
        }
    }
}

