/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.elasticsearch.common.Strings;

public class MapperBuilderContext {
    private final String path;
    private final BooleanSupplier isSourceSynthetic;

    public static MapperBuilderContext root(boolean isSourceSynthetic) {
        return new MapperBuilderContext(null, () -> isSourceSynthetic);
    }

    public static MapperBuilderContext forMetadata() {
        return new MapperBuilderContext(null, () -> {
            throw new UnsupportedOperationException("metadata fields can't check if _source is synthetic");
        });
    }

    MapperBuilderContext(String path, boolean isSourceSynthetic) {
        this(Objects.requireNonNull(path), () -> isSourceSynthetic);
    }

    private MapperBuilderContext(String path, BooleanSupplier isSourceSynthetic) {
        this.path = path;
        this.isSourceSynthetic = isSourceSynthetic;
    }

    public MapperBuilderContext createChildContext(String name) {
        return new MapperBuilderContext(this.buildFullName(name), this.isSourceSynthetic);
    }

    public String buildFullName(String name) {
        if (Strings.isEmpty(this.path)) {
            return name;
        }
        return this.path + "." + name;
    }

    public boolean isSourceSynthetic() {
        return this.isSourceSynthetic.getAsBoolean();
    }
}

