/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeometryNormalizer;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;

public interface GeoShapeQueryable {
    public Query geoShapeQuery(SearchExecutionContext var1, String var2, ShapeRelation var3, LatLonGeometry ... var4);

    default public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, Geometry shape) {
        LatLonGeometry[] luceneGeometries;
        try {
            luceneGeometries = GeoShapeQueryable.toQuantizeLuceneGeometry(shape, relation);
        }
        catch (IllegalArgumentException e) {
            throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
        }
        if (luceneGeometries.length == 0) {
            return new MatchNoDocsQuery();
        }
        return this.geoShapeQuery(context, fieldName, relation, luceneGeometries);
    }

    @Deprecated
    default public Query geoShapeQuery(SearchExecutionContext context, String fieldName, SpatialStrategy strategy, ShapeRelation relation, Geometry shape) {
        return this.geoShapeQuery(context, fieldName, relation, shape);
    }

    private static double quantizeLat(double lat) {
        return GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)lat));
    }

    private static double[] quantizeLats(double[] lats) {
        return Arrays.stream(lats).map(GeoShapeQueryable::quantizeLat).toArray();
    }

    private static double quantizeLon(double lon) {
        return GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)lon));
    }

    private static double[] quantizeLons(double[] lons) {
        return Arrays.stream(lons).map(GeoShapeQueryable::quantizeLon).toArray();
    }

    public static LatLonGeometry[] toQuantizeLuceneGeometry(Geometry geometry, final ShapeRelation relation) {
        if (geometry == null) {
            return new LatLonGeometry[0];
        }
        if (GeometryNormalizer.needsNormalize(Orientation.CCW, geometry)) {
            geometry = GeometryNormalizer.apply(Orientation.CCW, geometry);
        }
        if (geometry.isEmpty()) {
            return new LatLonGeometry[0];
        }
        final ArrayList geometries = new ArrayList();
        geometry.visit((GeometryVisitor)new GeometryVisitor<Object, RuntimeException>(){

            public Void visit(Circle circle) {
                if (!circle.isEmpty()) {
                    geometries.add(new org.apache.lucene.geo.Circle(GeoShapeQueryable.quantizeLat(circle.getLat()), GeoShapeQueryable.quantizeLon(circle.getLon()), circle.getRadiusMeters()));
                }
                return null;
            }

            public Void visit(GeometryCollection<?> collection) {
                if (!collection.isEmpty()) {
                    for (Geometry shape : collection) {
                        shape.visit((GeometryVisitor)this);
                    }
                }
                return null;
            }

            public Void visit(Line line) {
                if (!line.isEmpty()) {
                    if (relation == ShapeRelation.WITHIN) {
                        throw new IllegalArgumentException("found an unsupported shape Line");
                    }
                    geometries.add(new org.apache.lucene.geo.Line(GeoShapeQueryable.quantizeLats(line.getLats()), GeoShapeQueryable.quantizeLons(line.getLons())));
                }
                return null;
            }

            public Void visit(LinearRing ring) {
                throw new IllegalArgumentException("Found an unsupported shape LinearRing");
            }

            public Void visit(MultiLine multiLine) {
                if (!multiLine.isEmpty()) {
                    for (Line line : multiLine) {
                        this.visit(line);
                    }
                }
                return null;
            }

            public Void visit(MultiPoint multiPoint) {
                if (!multiPoint.isEmpty()) {
                    for (org.elasticsearch.geometry.Point point : multiPoint) {
                        this.visit(point);
                    }
                }
                return null;
            }

            public Void visit(MultiPolygon multiPolygon) {
                if (!multiPolygon.isEmpty()) {
                    for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                        this.visit(polygon);
                    }
                }
                return null;
            }

            public Void visit(org.elasticsearch.geometry.Point point) {
                if (!point.isEmpty()) {
                    geometries.add(new Point(GeoShapeQueryable.quantizeLat(point.getLat()), GeoShapeQueryable.quantizeLon(point.getLon())));
                }
                return null;
            }

            public Void visit(org.elasticsearch.geometry.Polygon polygon) {
                if (!polygon.isEmpty()) {
                    Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
                    for (int i = 0; i < holes.length; ++i) {
                        holes[i] = new Polygon(GeoShapeQueryable.quantizeLats(polygon.getHole(i).getY()), GeoShapeQueryable.quantizeLons(polygon.getHole(i).getX()), new Polygon[0]);
                    }
                    geometries.add(new Polygon(GeoShapeQueryable.quantizeLats(polygon.getPolygon().getY()), GeoShapeQueryable.quantizeLons(polygon.getPolygon().getX()), holes));
                }
                return null;
            }

            public Void visit(org.elasticsearch.geometry.Rectangle r) {
                if (!r.isEmpty()) {
                    geometries.add(new Rectangle(GeoShapeQueryable.quantizeLat(r.getMinLat()), GeoShapeQueryable.quantizeLat(r.getMaxLat()), GeoShapeQueryable.quantizeLon(r.getMinLon()), GeoShapeQueryable.quantizeLon(r.getMaxLon())));
                }
                return null;
            }
        });
        return geometries.toArray(new LatLonGeometry[0]);
    }
}

