/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.geo.GeometryNormalizer;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.mapper.ShapeIndexer;

public class GeoShapeIndexer
implements ShapeIndexer {
    private final Orientation orientation;
    private final String name;

    public GeoShapeIndexer(Orientation orientation, String name) {
        this.orientation = orientation;
        this.name = name;
    }

    @Override
    public List<IndexableField> indexShape(Geometry geometry) {
        if (geometry == null) {
            return Collections.emptyList();
        }
        return this.getIndexableFields(this.normalize(geometry));
    }

    public Geometry normalize(Geometry geometry) {
        return GeometryNormalizer.needsNormalize(this.orientation, geometry) ? GeometryNormalizer.apply(this.orientation, geometry) : geometry;
    }

    public List<IndexableField> getIndexableFields(Geometry geometry) {
        LuceneGeometryIndexer visitor = new LuceneGeometryIndexer(this.name);
        geometry.visit((GeometryVisitor)visitor);
        return visitor.fields();
    }

    private static Polygon toLucenePolygon(org.elasticsearch.geometry.Polygon polygon) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(polygon.getHole(i).getY(), polygon.getHole(i).getX(), new Polygon[0]);
        }
        return new Polygon(polygon.getPolygon().getY(), polygon.getPolygon().getX(), holes);
    }

    private static Polygon toLucenePolygon(Rectangle r) {
        return new Polygon(new double[]{r.getMinLat(), r.getMinLat(), r.getMaxLat(), r.getMaxLat(), r.getMinLat()}, new double[]{r.getMinLon(), r.getMaxLon(), r.getMaxLon(), r.getMinLon(), r.getMinLon()}, new Polygon[0]);
    }

    private static org.apache.lucene.geo.Line toLuceneLine(Line line) {
        return new org.apache.lucene.geo.Line(line.getLats(), line.getLons());
    }

    private static class LuceneGeometryIndexer
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<IndexableField> fields = new ArrayList<IndexableField>();
        private final String name;

        private LuceneGeometryIndexer(String name) {
            this.name = name;
        }

        List<IndexableField> fields() {
            return this.fields;
        }

        public Void visit(Circle circle) {
            throw new UnsupportedOperationException(ShapeType.CIRCLE + " geometry is not supported");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (org.apache.lucene.geo.Line)GeoShapeIndexer.toLuceneLine(line)));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (org.elasticsearch.geometry.Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (double)point.getY(), (double)point.getX()));
            return null;
        }

        public Void visit(org.elasticsearch.geometry.Polygon polygon) {
            this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (Polygon)GeoShapeIndexer.toLucenePolygon(polygon), (boolean)true));
            return null;
        }

        public Void visit(Rectangle r) {
            int minLat = GeoEncodingUtils.encodeLatitude((double)r.getMinLat());
            int maxLat = GeoEncodingUtils.encodeLatitude((double)r.getMaxLat());
            int minLon = GeoEncodingUtils.encodeLongitude((double)r.getMinLon());
            int maxLon = GeoEncodingUtils.encodeLongitude((double)r.getMaxLon());
            if (r.getMinLon() > r.getMaxLon()) {
                Line line;
                if (minLon == Integer.MAX_VALUE) {
                    line = new Line(new double[]{180.0, 180.0}, new double[]{r.getMaxLat(), r.getMinLat()});
                    this.visit(line);
                } else {
                    Rectangle left = new Rectangle(r.getMinLon(), 180.0, r.getMaxLat(), r.getMinLat());
                    this.visit(left);
                }
                if (maxLon == Integer.MIN_VALUE) {
                    line = new Line(new double[]{-180.0, -180.0}, new double[]{r.getMaxLat(), r.getMinLat()});
                    this.visit(line);
                } else {
                    Rectangle right = new Rectangle(-180.0, r.getMaxLon(), r.getMaxLat(), r.getMinLat());
                    this.visit(right);
                }
            } else if (minLon == maxLon) {
                if (minLat == maxLat) {
                    this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (double)r.getMinLat(), (double)r.getMinLon()));
                } else {
                    Line line = new Line(new double[]{r.getMinLon(), r.getMaxLon()}, new double[]{r.getMaxLat(), r.getMinLat()});
                    this.visit(line);
                }
            } else if (minLat == maxLat) {
                Line line = new Line(new double[]{r.getMinLon(), r.getMaxLon()}, new double[]{r.getMaxLat(), r.getMinLat()});
                this.visit(line);
            } else {
                Rectangle qRectangle = new Rectangle(GeoEncodingUtils.decodeLongitude((int)minLon), GeoEncodingUtils.decodeLongitude((int)maxLon), GeoEncodingUtils.decodeLatitude((int)maxLat), GeoEncodingUtils.decodeLatitude((int)minLat));
                this.addFields((IndexableField[])LatLonShape.createIndexableFields((String)this.name, (Polygon)GeoShapeIndexer.toLucenePolygon(qRectangle)));
            }
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

