/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentDimensions;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.DotExpandingXContentParser;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.XContentParser;

public abstract class DocumentParserContext {
    private final MappingLookup mappingLookup;
    private final MappingParserContext mappingParserContext;
    private final SourceToParse sourceToParse;
    private final Set<String> ignoredFields;
    private final List<Mapper> dynamicMappers;
    private final Set<String> newFieldsSeen;
    private final Map<String, ObjectMapper> dynamicObjectMappers;
    private final List<RuntimeField> dynamicRuntimeFields;
    private final DocumentDimensions dimensions;
    private final ObjectMapper parent;
    private final ObjectMapper.Dynamic dynamic;
    private String id;
    private Field version;
    private SeqNoFieldMapper.SequenceIDFields seqID;

    private DocumentParserContext(MappingLookup mappingLookup, MappingParserContext mappingParserContext, SourceToParse sourceToParse, Set<String> ignoreFields, List<Mapper> dynamicMappers, Set<String> newFieldsSeen, Map<String, ObjectMapper> dynamicObjectMappers, List<RuntimeField> dynamicRuntimeFields, String id, Field version, SeqNoFieldMapper.SequenceIDFields seqID, DocumentDimensions dimensions, ObjectMapper parent, ObjectMapper.Dynamic dynamic) {
        this.mappingLookup = mappingLookup;
        this.mappingParserContext = mappingParserContext;
        this.sourceToParse = sourceToParse;
        this.ignoredFields = ignoreFields;
        this.dynamicMappers = dynamicMappers;
        this.newFieldsSeen = newFieldsSeen;
        this.dynamicObjectMappers = dynamicObjectMappers;
        this.dynamicRuntimeFields = dynamicRuntimeFields;
        this.id = id;
        this.version = version;
        this.seqID = seqID;
        this.dimensions = dimensions;
        this.parent = parent;
        this.dynamic = dynamic;
    }

    private DocumentParserContext(ObjectMapper parent, ObjectMapper.Dynamic dynamic, DocumentParserContext in) {
        this(in.mappingLookup, in.mappingParserContext, in.sourceToParse, in.ignoredFields, in.dynamicMappers, in.newFieldsSeen, in.dynamicObjectMappers, in.dynamicRuntimeFields, in.id, in.version, in.seqID, in.dimensions, parent, dynamic);
    }

    protected DocumentParserContext(MappingLookup mappingLookup, MappingParserContext mappingParserContext, SourceToParse source, ObjectMapper parent, ObjectMapper.Dynamic dynamic) {
        this(mappingLookup, mappingParserContext, source, new HashSet<String>(), new ArrayList<Mapper>(), new HashSet<String>(), new HashMap<String, ObjectMapper>(), new ArrayList<RuntimeField>(), null, null, null, DocumentDimensions.fromIndexSettings(mappingParserContext.getIndexSettings()), parent, dynamic);
    }

    public final IndexSettings indexSettings() {
        return this.mappingParserContext.getIndexSettings();
    }

    public final IndexAnalyzers indexAnalyzers() {
        return this.mappingParserContext.getIndexAnalyzers();
    }

    public final RootObjectMapper root() {
        return this.mappingLookup.getMapping().getRoot();
    }

    public final ObjectMapper parent() {
        return this.parent;
    }

    public final MappingLookup mappingLookup() {
        return this.mappingLookup;
    }

    public final MetadataFieldMapper getMetadataMapper(String mapperName) {
        return this.mappingLookup.getMapping().getMetadataMapperByName(mapperName);
    }

    public final MappingParserContext dynamicTemplateParserContext(DateFormatter dateFormatter) {
        return this.mappingParserContext.createDynamicTemplateContext(dateFormatter);
    }

    public final SourceToParse sourceToParse() {
        return this.sourceToParse;
    }

    public final void addIgnoredField(String field) {
        this.ignoredFields.add(field);
    }

    public final Collection<String> getIgnoredFields() {
        return Collections.unmodifiableCollection(this.ignoredFields);
    }

    public final void addToFieldNames(String field) {
        FieldNamesFieldMapper fieldNamesFieldMapper = (FieldNamesFieldMapper)this.getMetadataMapper("_field_names");
        if (fieldNamesFieldMapper != null) {
            fieldNamesFieldMapper.addFieldNames(this, field);
        }
    }

    public final Field version() {
        return this.version;
    }

    public final void version(Field version) {
        this.version = version;
    }

    public final String id() {
        if (this.id == null) {
            assert (false) : "id field mapper has not set the id";
            throw new IllegalStateException("id field mapper has not set the id");
        }
        return this.id;
    }

    public final void id(String id) {
        this.id = id;
    }

    public final SeqNoFieldMapper.SequenceIDFields seqID() {
        return this.seqID;
    }

    public final void seqID(SeqNoFieldMapper.SequenceIDFields seqID) {
        this.seqID = seqID;
    }

    public final String documentDescription() {
        IdFieldMapper idMapper = (IdFieldMapper)this.getMetadataMapper("_id");
        return idMapper.documentDescription(this);
    }

    public Mapper getMapper(String name) {
        return this.parent.getMapper(name);
    }

    public ObjectMapper.Dynamic dynamic() {
        return this.dynamic;
    }

    public final void addDynamicMapper(Mapper mapper) {
        if (mapper instanceof ObjectMapper) {
            MappingLookup.checkObjectDepthLimit(this.indexSettings().getMappingDepthLimit(), mapper.name());
        }
        if (this.mappingLookup.getMapper(mapper.name()) == null && !this.mappingLookup.objectMappers().containsKey(mapper.name()) && this.newFieldsSeen.add(mapper.name())) {
            this.mappingLookup.checkFieldLimit(this.indexSettings().getMappingTotalFieldsLimit(), this.newFieldsSeen.size());
        }
        if (mapper instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            this.dynamicObjectMappers.put(objectMapper.name(), objectMapper);
            for (Mapper submapper : objectMapper.mappers.values()) {
                this.addDynamicMapper(submapper);
            }
        }
        this.dynamicMappers.add(mapper);
    }

    public final List<Mapper> getDynamicMappers() {
        return this.dynamicMappers;
    }

    final ObjectMapper getDynamicObjectMapper(String name) {
        return this.dynamicObjectMappers.get(name);
    }

    final void addDynamicRuntimeField(RuntimeField runtimeField) {
        if (this.newFieldsSeen.add(runtimeField.name())) {
            this.mappingLookup.checkFieldLimit(this.indexSettings().getMappingTotalFieldsLimit(), this.newFieldsSeen.size());
        }
        this.dynamicRuntimeFields.add(runtimeField);
    }

    public final List<RuntimeField> getDynamicRuntimeFields() {
        return Collections.unmodifiableList(this.dynamicRuntimeFields);
    }

    public abstract Iterable<LuceneDocument> nonRootDocuments();

    public final RootObjectMapper.Builder updateRoot() {
        return this.mappingLookup.getMapping().getRoot().newBuilder(this.mappingParserContext.getIndexSettings().getIndexVersionCreated());
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final DocumentParserContext createChildContext(ObjectMapper parent) {
        return new Wrapper(parent, this);
    }

    public final DocumentParserContext createNestedContext(NestedObjectMapper nestedMapper) {
        if (this.isWithinCopyTo()) {
            return this;
        }
        LuceneDocument doc = new LuceneDocument(nestedMapper.fullPath(), this.doc());
        IndexableField idField = doc.getParent().getField("_id");
        if (idField == null) {
            throw new IllegalStateException("The root document of a nested document should have an _id field");
        }
        doc.add((IndexableField)new StringField("_id", idField.binaryValue(), Field.Store.NO));
        doc.add((IndexableField)NestedPathFieldMapper.field(this.indexSettings().getIndexVersionCreated(), nestedMapper.nestedTypePath()));
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final DocumentParserContext switchDoc(final LuceneDocument document) {
        return new Wrapper(this.parent, this){

            @Override
            public LuceneDocument doc() {
                return document;
            }
        };
    }

    public final DocumentParserContext createCopyToContext(String copyToField, final LuceneDocument doc) throws IOException {
        final ContentPath path = new ContentPath();
        final XContentParser parser = DotExpandingXContentParser.expandDots((XContentParser)new CopyToParser(copyToField, this.parser()), path);
        return new Wrapper(this.root(), this){

            @Override
            public ContentPath path() {
                return path;
            }

            @Override
            public XContentParser parser() {
                return parser;
            }

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }

            @Override
            public LuceneDocument doc() {
                return doc;
            }
        };
    }

    @Deprecated
    public final DocumentParserContext switchParser(final XContentParser parser) {
        return new Wrapper(this.parent, this){

            @Override
            public XContentParser parser() {
                return parser;
            }
        };
    }

    public DocumentDimensions getDimensions() {
        return this.dimensions;
    }

    public abstract ContentPath path();

    public final MapperBuilderContext createDynamicMapperBuilderContext() {
        String p = this.path().pathAsText("");
        if (p.endsWith(".")) {
            p = p.substring(0, p.length() - 1);
        }
        return new MapperBuilderContext(p, this.mappingLookup().isSourceSynthetic());
    }

    public abstract XContentParser parser();

    public abstract LuceneDocument rootDoc();

    public abstract LuceneDocument doc();

    protected abstract void addDoc(LuceneDocument var1);

    public final DynamicTemplate findDynamicTemplate(String fieldName, DynamicTemplate.XContentFieldType matchType) {
        String pathAsString = this.path().pathAsText(fieldName);
        String matchTemplateName = this.sourceToParse().dynamicTemplates().get(pathAsString);
        for (DynamicTemplate template : this.root().dynamicTemplates()) {
            if (!template.match(matchTemplateName, pathAsString, fieldName, matchType)) continue;
            return template;
        }
        if (matchTemplateName != null) {
            throw new DocumentParsingException(this.parser().getTokenLocation(), "Can't find dynamic template for dynamic template name [" + matchTemplateName + "] of field [" + pathAsString + "]");
        }
        return null;
    }

    private static class Wrapper
    extends DocumentParserContext {
        private final DocumentParserContext in;

        private Wrapper(ObjectMapper parent, DocumentParserContext in) {
            super(parent, parent.dynamic == null ? in.dynamic : parent.dynamic, in);
            this.in = in;
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public LuceneDocument doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            this.in.addDoc(doc);
        }
    }

    private static class CopyToParser
    extends FilterXContentParserWrapper {
        private State state = State.FIELD;
        private final String field;

        CopyToParser(String fieldName, XContentParser in) {
            super(in);
            this.field = fieldName;
            assert (in.currentToken().isValue() || in.currentToken() == XContentParser.Token.VALUE_NULL);
        }

        public XContentParser.Token nextToken() throws IOException {
            if (this.state == State.FIELD) {
                this.state = State.VALUE;
                return this.delegate().currentToken();
            }
            return XContentParser.Token.END_OBJECT;
        }

        public XContentParser.Token currentToken() {
            if (this.state == State.FIELD) {
                return XContentParser.Token.FIELD_NAME;
            }
            return this.delegate().currentToken();
        }

        public String currentName() throws IOException {
            return this.field;
        }

        static enum State {
            FIELD,
            VALUE;

        }
    }
}

