/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesEncoder;

public class ES87TSDBDocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES87TSDBDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block16: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields((IndexInput)in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ", data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this.data);
            }
        }
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        return this.getNumeric(entry);
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException("Unsupported binary doc values for field [" + field.name + "]");
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException("Unsupported sorted doc values for field [" + field.name + "]");
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericEntry entry = this.sortedNumerics.get(field.name);
        return this.getSortedNumeric(entry);
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        throw new UnsupportedOperationException("Unsupported sorted set doc values for field [" + field.name + "]");
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public void close() throws IOException {
        this.data.close();
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info.name, this.readNumeric(meta));
            } else {
                if (type == 1) {
                    throw new CorruptIndexException("unsupported type: " + type, (DataInput)meta);
                }
                if (type == 2) {
                    throw new CorruptIndexException("unsupported type: " + type, (DataInput)meta);
                }
                if (type == 3) {
                    throw new CorruptIndexException("unsupported type: " + type, (DataInput)meta);
                }
                if (type == 4) {
                    this.sortedNumerics.put(info.name, this.readSortedNumeric(meta));
                } else {
                    throw new CorruptIndexException("invalid type: " + type, (DataInput)meta);
                }
            }
            fieldNumber = meta.readInt();
        }
    }

    private NumericEntry readNumeric(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        this.readNumeric(meta, entry);
        return entry;
    }

    private void readNumeric(IndexInput meta, NumericEntry entry) throws IOException {
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numValues = meta.readLong();
        if (entry.numValues > 0L) {
            int indexBlockShift = meta.readInt();
            entry.indexMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(1L + (entry.numValues - 1L >>> 7)), (int)indexBlockShift);
            entry.indexOffset = meta.readLong();
            entry.indexLength = meta.readLong();
            entry.valuesOffset = meta.readLong();
            entry.valuesLength = meta.readLong();
        }
    }

    private SortedNumericEntry readSortedNumeric(IndexInput meta) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        this.readSortedNumeric(meta, entry);
        return entry;
    }

    private SortedNumericEntry readSortedNumeric(IndexInput meta, SortedNumericEntry entry) throws IOException {
        this.readNumeric(meta, entry);
        entry.numDocsWithField = meta.readInt();
        if ((long)entry.numDocsWithField != entry.numValues) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(entry.numDocsWithField + 1), (int)blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private NumericDocValues getNumeric(NumericEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        RandomAccessInput indexSlice = this.data.randomAccessSlice(entry.indexOffset, entry.indexLength);
        final DirectMonotonicReader indexReader = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.indexMeta, (RandomAccessInput)indexSlice);
        final IndexInput valuesData = this.data.slice("values", entry.valuesOffset, entry.valuesLength);
        if (entry.docsWithFieldOffset == -1L) {
            return new NumericDocValues(){
                private final int maxDoc;
                private int doc;
                private final ES87TSDBDocValuesEncoder decoder;
                private long currentBlockIndex;
                private final long[] currentBlock;
                {
                    this.maxDoc = ES87TSDBDocValuesProducer.this.maxDoc;
                    this.doc = -1;
                    this.decoder = new ES87TSDBDocValuesEncoder();
                    this.currentBlockIndex = -1L;
                    this.currentBlock = new long[128];
                }

                public int docID() {
                    return this.doc;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int advance(int target) throws IOException {
                    if (target >= this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = target;
                    return this.doc;
                }

                public boolean advanceExact(int target) {
                    this.doc = target;
                    return true;
                }

                public long cost() {
                    return this.maxDoc;
                }

                public long longValue() throws IOException {
                    int index = this.doc;
                    int blockIndex = index >>> 7;
                    int blockInIndex = index & 0x7F;
                    if ((long)blockIndex != this.currentBlockIndex) {
                        assert ((long)blockIndex > this.currentBlockIndex);
                        if ((long)(blockIndex - 1) > this.currentBlockIndex) {
                            valuesData.seek(indexReader.get((long)blockIndex));
                        }
                        this.currentBlockIndex = blockIndex;
                        this.decoder.decode((DataInput)valuesData, this.currentBlock);
                    }
                    return this.currentBlock[blockInIndex];
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
        return new NumericDocValues(){
            private final ES87TSDBDocValuesEncoder decoder = new ES87TSDBDocValuesEncoder();
            private long currentBlockIndex = -1L;
            private final long[] currentBlock = new long[128];

            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                return disi.advanceExact(target);
            }

            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            public int docID() {
                return disi.docID();
            }

            public long cost() {
                return disi.cost();
            }

            public long longValue() throws IOException {
                int index = disi.index();
                int blockIndex = index >>> 7;
                int blockInIndex = index & 0x7F;
                if ((long)blockIndex != this.currentBlockIndex) {
                    assert ((long)blockIndex > this.currentBlockIndex);
                    if ((long)(blockIndex - 1) > this.currentBlockIndex) {
                        valuesData.seek(indexReader.get((long)blockIndex));
                    }
                    this.currentBlockIndex = blockIndex;
                    this.decoder.decode((DataInput)valuesData, this.currentBlock);
                }
                return this.currentBlock[blockInIndex];
            }
        };
    }

    private NumericValues getValues(NumericEntry entry) throws IOException {
        assert (entry.numValues > 0L);
        RandomAccessInput indexSlice = this.data.randomAccessSlice(entry.indexOffset, entry.indexLength);
        final DirectMonotonicReader indexReader = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.indexMeta, (RandomAccessInput)indexSlice);
        final IndexInput valuesData = this.data.slice("values", entry.valuesOffset, entry.valuesLength);
        return new NumericValues(){
            private final ES87TSDBDocValuesEncoder decoder = new ES87TSDBDocValuesEncoder();
            private long currentBlockIndex = -1L;
            private final long[] currentBlock = new long[128];

            @Override
            long advance(long index) throws IOException {
                long blockIndex = index >>> 7;
                int blockInIndex = (int)(index & 0x7FL);
                if (blockIndex != this.currentBlockIndex) {
                    assert (blockIndex > this.currentBlockIndex);
                    if (blockIndex - 1L > this.currentBlockIndex) {
                        valuesData.seek(indexReader.get(blockIndex));
                    }
                    this.currentBlockIndex = blockIndex;
                    this.decoder.decode((DataInput)valuesData, this.currentBlock);
                }
                return this.currentBlock[blockInIndex];
            }
        };
    }

    private SortedNumericDocValues getSortedNumeric(SortedNumericEntry entry) throws IOException {
        if (entry.numValues == (long)entry.numDocsWithField) {
            return DocValues.singleton((NumericDocValues)this.getNumeric(entry));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesInput);
        final NumericValues values = this.getValues(entry);
        if (entry.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues((LongValues)addresses, values){
                int doc = -1;
                long start;
                long end;
                int count;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ NumericValues val$values;
                {
                    this.val$addresses = longValues;
                    this.val$values = numericValues;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return ES87TSDBDocValuesProducer.this.maxDoc;
                }

                public int advance(int target) throws IOException {
                    if (target >= ES87TSDBDocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                public long nextValue() throws IOException {
                    return this.val$values.advance(this.start++);
                }

                public int docValueCount() {
                    return this.count;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, (long)entry.numDocsWithField);
        return new SortedNumericDocValues((LongValues)addresses){
            boolean set;
            long start;
            long end;
            int count;
            final /* synthetic */ LongValues val$addresses;
            {
                this.val$addresses = longValues;
            }

            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            public int docID() {
                return disi.docID();
            }

            public long cost() {
                return disi.cost();
            }

            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            public long nextValue() throws IOException {
                this.set();
                return values.advance(this.start++);
            }

            public int docValueCount() {
                this.set();
                return this.count;
            }

            private void set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = this.val$addresses.get((long)index);
                    this.end = this.val$addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    private static class NumericEntry {
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        long numValues;
        long indexOffset;
        long indexLength;
        DirectMonotonicReader.Meta indexMeta;
        long valuesOffset;
        long valuesLength;

        private NumericEntry() {
        }
    }

    private static class SortedNumericEntry
    extends NumericEntry {
        int numDocsWithField;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedNumericEntry() {
        }
    }

    private static abstract class NumericValues {
        private NumericValues() {
        }

        abstract long advance(long var1) throws IOException;
    }
}

