/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene95.Lucene95Codec;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.bloomfilter.ES87BloomFilterPostingsFormat;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesFormat;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class PerFieldMapperCodec
extends Lucene95Codec {
    private final MapperService mapperService;
    private final DocValuesFormat docValuesFormat = new Lucene90DocValuesFormat();
    private final ES87BloomFilterPostingsFormat bloomFilterPostingsFormat;
    private final ES87TSDBDocValuesFormat tsdbDocValuesFormat;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMapperCodec(Lucene95Codec.Mode compressionMode, MapperService mapperService, BigArrays bigArrays) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.bloomFilterPostingsFormat = new ES87BloomFilterPostingsFormat(bigArrays, this::internalGetPostingsFormatForField);
        this.tsdbDocValuesFormat = new ES87TSDBDocValuesFormat();
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        if (this.useBloomFilter(field)) {
            return this.bloomFilterPostingsFormat;
        }
        return this.internalGetPostingsFormatForField(field);
    }

    private PostingsFormat internalGetPostingsFormatForField(String field) {
        PostingsFormat format = this.mapperService.mappingLookup().getPostingsFormat(field);
        if (format != null) {
            return format;
        }
        return super.getPostingsFormatForField(field);
    }

    boolean useBloomFilter(String field) {
        IndexSettings indexSettings = this.mapperService.getIndexSettings();
        if (this.mapperService.mappingLookup().isDataStreamTimestampFieldEnabled()) {
            return indexSettings.getMode() == IndexMode.TIME_SERIES && "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
        }
        return "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        DenseVectorFieldMapper vectorMapper;
        KnnVectorsFormat format;
        Mapper mapper = this.mapperService.mappingLookup().getMapper(field);
        if (mapper instanceof DenseVectorFieldMapper && (format = (vectorMapper = (DenseVectorFieldMapper)mapper).getKnnVectorsFormatForField()) != null) {
            return format;
        }
        return super.getKnnVectorsFormatForField(field);
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        if (this.useTSDBDocValuesFormat(field)) {
            return this.tsdbDocValuesFormat;
        }
        return this.docValuesFormat;
    }

    boolean useTSDBDocValuesFormat(String field) {
        return this.mapperService.getIndexSettings().isES87TSDBCodecEnabled() && this.isTimeSeriesModeIndex() && this.isNotSpecialField(field) && (this.isCounterOrGaugeMetricType(field) || this.isTimestampField(field));
    }

    private boolean isTimeSeriesModeIndex() {
        return IndexMode.TIME_SERIES.equals((Object)this.mapperService.getIndexSettings().getMode());
    }

    private boolean isCounterOrGaugeMetricType(String field) {
        MappingLookup mappingLookup;
        if (this.mapperService != null && (mappingLookup = this.mapperService.mappingLookup()).getMapper(field) instanceof NumberFieldMapper) {
            MappedFieldType fieldType = mappingLookup.getFieldType(field);
            return TimeSeriesParams.MetricType.COUNTER.equals((Object)fieldType.getMetricType()) || TimeSeriesParams.MetricType.GAUGE.equals((Object)fieldType.getMetricType());
        }
        return false;
    }

    private boolean isTimestampField(String field) {
        return "@timestamp".equals(field);
    }

    private boolean isNotSpecialField(String field) {
        return !field.startsWith("_");
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMapperCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName((String)"Lucene95").getClass().isAssignableFrom(PerFieldMapperCodec.class)) {
            throw new AssertionError((Object)"PerFieldMapperCodec must subclass the latest lucene codec: Lucene95");
        }
    }
}

