/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record IndexVersion(int id, Version luceneVersion) implements VersionId<IndexVersion>,
ToXContentFragment
{
    private static Map<String, Integer> IDS = new HashMap<String, Integer>();
    public static final IndexVersion ZERO = IndexVersion.registerIndexVersion(0, Version.LATEST, "00000000-0000-0000-0000-000000000000");
    public static final IndexVersion V_7_0_0 = IndexVersion.registerIndexVersion(7000099, Version.LUCENE_8_0_0, "b32be92d-c403-4858-a4a3-20d699a47ae6");
    public static final IndexVersion V_7_0_1 = IndexVersion.registerIndexVersion(7000199, Version.LUCENE_8_0_0, "a03ed728-eac8-4e50-bcce-864806bb10e0");
    public static final IndexVersion V_7_1_0 = IndexVersion.registerIndexVersion(7010099, Version.LUCENE_8_0_0, "f9964d87-9f20-4b26-af32-be1f979216ec");
    public static final IndexVersion V_7_1_1 = IndexVersion.registerIndexVersion(7010199, Version.LUCENE_8_0_0, "29a3fb69-55d0-4389-aea9-96c98ce23830");
    public static final IndexVersion V_7_2_0 = IndexVersion.registerIndexVersion(7020099, Version.LUCENE_8_0_0, "dba49448-87d4-45bb-ba19-f7b4eb85c757");
    public static final IndexVersion V_7_2_1 = IndexVersion.registerIndexVersion(7020199, Version.LUCENE_8_0_0, "58874b45-f9f8-4c04-92a9-67548a8b21c3");
    public static final IndexVersion V_7_3_0 = IndexVersion.registerIndexVersion(7030099, Version.LUCENE_8_1_0, "3d8a21df-58a4-4d7a-ba5d-438c92c16a7b");
    public static final IndexVersion V_7_3_1 = IndexVersion.registerIndexVersion(7030199, Version.LUCENE_8_1_0, "5687797f-448b-490d-94d4-d7e8cfac0c98");
    public static final IndexVersion V_7_3_2 = IndexVersion.registerIndexVersion(7030299, Version.LUCENE_8_1_0, "5a3462e5-d2fe-4b7b-9a7e-c0234412271f");
    public static final IndexVersion V_7_4_0 = IndexVersion.registerIndexVersion(7040099, Version.LUCENE_8_2_0, "c1fe73ba-0173-476c-aba2-855c2b31ac18");
    public static final IndexVersion V_7_4_1 = IndexVersion.registerIndexVersion(7040199, Version.LUCENE_8_2_0, "8a917374-bd4f-45e3-9052-575c4cf741cd");
    public static final IndexVersion V_7_4_2 = IndexVersion.registerIndexVersion(7040299, Version.LUCENE_8_2_0, "f073a867-cba2-41e4-8150-a2f2a96f1e0b");
    public static final IndexVersion V_7_5_0 = IndexVersion.registerIndexVersion(7050099, Version.LUCENE_8_3_0, "ab08ae25-ede2-4e57-a43f-89d96aa989e4");
    public static final IndexVersion V_7_5_1 = IndexVersion.registerIndexVersion(7050199, Version.LUCENE_8_3_0, "a386d62e-cb85-4a37-b5f9-c9468bbfc457");
    public static final IndexVersion V_7_5_2 = IndexVersion.registerIndexVersion(7050299, Version.LUCENE_8_3_0, "706715ca-3b91-40d2-8c2e-c34c459b5d0d");
    public static final IndexVersion V_7_6_0 = IndexVersion.registerIndexVersion(7060099, Version.LUCENE_8_4_0, "63acbdb9-51c8-4976-bb3d-e55052a4fbd4");
    public static final IndexVersion V_7_6_1 = IndexVersion.registerIndexVersion(7060199, Version.LUCENE_8_4_0, "1acc33d3-28dc-448d-953a-664dad3bf1f5");
    public static final IndexVersion V_7_6_2 = IndexVersion.registerIndexVersion(0x6BBB4B, Version.LUCENE_8_4_0, "3aa17069-fa04-4bf9-96af-fe8b903faa75");
    public static final IndexVersion V_7_7_0 = IndexVersion.registerIndexVersion(7070099, Version.LUCENE_8_5_1, "6fff8238-e6ce-4fb2-85de-196492026e49");
    public static final IndexVersion V_7_7_1 = IndexVersion.registerIndexVersion(7070199, Version.LUCENE_8_5_1, "4ce6641d-157b-4c59-8261-7997ac0f6e40");
    public static final IndexVersion V_7_8_0 = IndexVersion.registerIndexVersion(7080099, Version.LUCENE_8_5_1, "81d7d459-f386-4c20-8235-f8fce8af7f0e");
    public static final IndexVersion V_7_8_1 = IndexVersion.registerIndexVersion(7080199, Version.LUCENE_8_5_1, "a1b015bc-d020-453f-85a6-9413e169304a");
    public static final IndexVersion V_7_9_0 = IndexVersion.registerIndexVersion(7090099, Version.LUCENE_8_6_0, "0fa951a2-43ce-4f76-91bf-066c1ecf8a93");
    public static final IndexVersion V_7_9_1 = IndexVersion.registerIndexVersion(7090199, Version.LUCENE_8_6_2, "5fc4aabc-080e-4840-af4f-a724deba98b1");
    public static final IndexVersion V_7_9_2 = IndexVersion.registerIndexVersion(7090299, Version.LUCENE_8_6_2, "ef824617-332e-4b63-969e-ebb73a868462");
    public static final IndexVersion V_7_9_3 = IndexVersion.registerIndexVersion(7090399, Version.LUCENE_8_6_2, "499c810a-0f37-4dfd-92ad-55e4936f3578");
    public static final IndexVersion V_7_10_0 = IndexVersion.registerIndexVersion(7100099, Version.LUCENE_8_7_0, "92ccd91c-0251-4263-8873-9f1abfac3c10");
    public static final IndexVersion V_7_10_1 = IndexVersion.registerIndexVersion(7100199, Version.LUCENE_8_7_0, "8ce37467-964f-43eb-ad2d-a51a50116868");
    public static final IndexVersion V_7_10_2 = IndexVersion.registerIndexVersion(7100299, Version.LUCENE_8_7_0, "cb277ccb-3081-4238-be2c-c3167316a435");
    public static final IndexVersion V_7_11_0 = IndexVersion.registerIndexVersion(7110099, Version.LUCENE_8_7_0, "e6d65f96-26d5-4669-ac5a-2964b9b1699f");
    public static final IndexVersion V_7_11_1 = IndexVersion.registerIndexVersion(7110199, Version.LUCENE_8_7_0, "e3655b78-14f7-4432-aa28-34cd1ef2d229");
    public static final IndexVersion V_7_11_2 = IndexVersion.registerIndexVersion(7110299, Version.LUCENE_8_7_0, "1ecfd0ee-4868-4384-b2a0-af6ecb01e496");
    public static final IndexVersion V_7_12_0 = IndexVersion.registerIndexVersion(7120099, Version.LUCENE_8_8_0, "39e2989a-a9a4-4f1a-b185-2e6015f74b1c");
    public static final IndexVersion V_7_12_1 = IndexVersion.registerIndexVersion(7120199, Version.LUCENE_8_8_0, "a8307f67-8295-4567-a7eb-2a6e69046282");
    public static final IndexVersion V_7_13_0 = IndexVersion.registerIndexVersion(7130099, Version.LUCENE_8_8_2, "28b21fe0-4d1f-4c04-95cc-74df494ae0cf");
    public static final IndexVersion V_7_13_1 = IndexVersion.registerIndexVersion(7130199, Version.LUCENE_8_8_2, "4952d7a7-d9f5-443b-b362-8c5ebdc57f81");
    public static final IndexVersion V_7_13_2 = IndexVersion.registerIndexVersion(0x6CCCBB, Version.LUCENE_8_8_2, "d77c4245-9d26-4da3-aa61-78ab34c3c792");
    public static final IndexVersion V_7_13_3 = IndexVersion.registerIndexVersion(7130399, Version.LUCENE_8_8_2, "a263a47e-4075-4c68-8a42-15a37455c30f");
    public static final IndexVersion V_7_13_4 = IndexVersion.registerIndexVersion(7130499, Version.LUCENE_8_8_2, "d17644c8-3144-495d-8f6c-42cd36698e98");
    public static final IndexVersion V_7_14_0 = IndexVersion.registerIndexVersion(7140099, Version.LUCENE_8_9_0, "b45bb223-bb73-4379-a46f-7dc74d38aaca");
    public static final IndexVersion V_7_14_1 = IndexVersion.registerIndexVersion(7140199, Version.LUCENE_8_9_0, "ee4a6d62-9e05-490b-93dd-b316f9a62d71");
    public static final IndexVersion V_7_14_2 = IndexVersion.registerIndexVersion(7140299, Version.LUCENE_8_9_0, "285d3293-2896-431c-97dd-180890840947");
    public static final IndexVersion V_7_15_0 = IndexVersion.registerIndexVersion(7150099, Version.LUCENE_8_9_0, "ab666b02-b866-4b64-9ba3-d511e86c55b5");
    public static final IndexVersion V_7_15_1 = IndexVersion.registerIndexVersion(7150199, Version.LUCENE_8_9_0, "5643957d-9b68-414a-8917-ea75cf549f67");
    public static final IndexVersion V_7_15_2 = IndexVersion.registerIndexVersion(7150299, Version.LUCENE_8_9_0, "1a618039-d665-47ce-b6ca-886e88c64051");
    public static final IndexVersion V_7_16_0 = IndexVersion.registerIndexVersion(7160099, Version.LUCENE_8_10_1, "a582e900-2d92-474c-9be3-2e08fa88be4b");
    public static final IndexVersion V_7_16_1 = IndexVersion.registerIndexVersion(7160199, Version.LUCENE_8_10_1, "bf666306-9b0d-468b-99dc-f2706dae9c11");
    public static final IndexVersion V_7_16_2 = IndexVersion.registerIndexVersion(7160299, Version.LUCENE_8_10_1, "167c6d69-cae2-4281-8f37-984231620ee9");
    public static final IndexVersion V_7_16_3 = IndexVersion.registerIndexVersion(7160399, Version.LUCENE_8_10_1, "5d25a795-2be6-4663-93dc-10d88efb7e3d");
    public static final IndexVersion V_7_17_0 = IndexVersion.registerIndexVersion(7170099, Version.LUCENE_8_11_1, "18766ab8-4691-40a2-94f1-526f3b71420c");
    public static final IndexVersion V_7_17_1 = IndexVersion.registerIndexVersion(7170199, Version.LUCENE_8_11_1, "8ad49144-4a1c-4322-b33d-614a569fba9b");
    public static final IndexVersion V_7_17_2 = IndexVersion.registerIndexVersion(7170299, Version.LUCENE_8_11_1, "50033cde-c905-4923-83d6-8139f3f110e1");
    public static final IndexVersion V_7_17_3 = IndexVersion.registerIndexVersion(7170399, Version.LUCENE_8_11_1, "460b91d1-4f3d-4f56-8dca-8d9e15f5b862");
    public static final IndexVersion V_7_17_4 = IndexVersion.registerIndexVersion(7170499, Version.LUCENE_8_11_1, "26e40d6f-ac7c-43a3-bd0c-1ec6c3093f66");
    public static final IndexVersion V_7_17_5 = IndexVersion.registerIndexVersion(7170599, Version.LUCENE_8_11_1, "d80bc13c-7139-4ff9-979d-42701d480e33");
    public static final IndexVersion V_7_17_6 = IndexVersion.registerIndexVersion(7170699, Version.LUCENE_8_11_1, "0b47328e-341a-4f97-927d-c49f5050778d");
    public static final IndexVersion V_7_17_7 = IndexVersion.registerIndexVersion(7170799, Version.LUCENE_8_11_1, "b672ff6b-8078-4f6e-b426-6fcf7f8687b4");
    public static final IndexVersion V_7_17_8 = IndexVersion.registerIndexVersion(7170899, Version.LUCENE_8_11_1, "0faffa1b-5fb3-4439-9367-f154fb25395f");
    public static final IndexVersion V_7_17_9 = IndexVersion.registerIndexVersion(7170999, Version.LUCENE_8_11_1, "8044989f-77ef-4d6d-9dd8-1bdd805cef74");
    public static final IndexVersion V_7_17_10 = IndexVersion.registerIndexVersion(7171099, Version.LUCENE_8_11_1, "66b743fb-8be6-443f-8920-d8c5ed561857");
    public static final IndexVersion V_7_17_11 = IndexVersion.registerIndexVersion(7171199, Version.LUCENE_8_11_1, "f1935acc-1af9-44b0-97e9-67112d333753");
    public static final IndexVersion V_7_17_12 = IndexVersion.registerIndexVersion(7171299, Version.LUCENE_8_11_1, "1a0719f2-96f4-4df5-b20d-62244e27d7d4");
    public static final IndexVersion V_7_17_13 = IndexVersion.registerIndexVersion(7171399, Version.LUCENE_8_11_1, "171a73c6-3ece-4f10-804f-7104a97b557c");
    public static final IndexVersion V_7_17_14 = IndexVersion.registerIndexVersion(7171499, Version.LUCENE_8_11_1, "3012f344-15f5-4971-a5ff-56a792d9b263");
    public static final IndexVersion V_7_17_15 = IndexVersion.registerIndexVersion(7171599, Version.LUCENE_8_11_1, "ec433c7a-2b35-4321-bf4a-d1766ee32b2f");
    public static final IndexVersion V_8_0_0 = IndexVersion.registerIndexVersion(8000099, Version.LUCENE_9_0_0, "ff18a13c-1fa7-4cf7-a3b1-4fdcd9461d5b");
    public static final IndexVersion V_8_0_1 = IndexVersion.registerIndexVersion(8000199, Version.LUCENE_9_0_0, "4bd5650f-3eff-418f-a7a6-ad46b2a9c941");
    public static final IndexVersion V_8_1_0 = IndexVersion.registerIndexVersion(8010099, Version.LUCENE_9_0_0, "b4742461-ee43-4fd0-a260-29f8388b82ec");
    public static final IndexVersion V_8_1_1 = IndexVersion.registerIndexVersion(8010199, Version.LUCENE_9_0_0, "3883e088-9a1c-4494-8d71-768820485f33");
    public static final IndexVersion V_8_1_2 = IndexVersion.registerIndexVersion(8010299, Version.LUCENE_9_0_0, "859a745a-81d3-463e-af58-615179a22d4f");
    public static final IndexVersion V_8_1_3 = IndexVersion.registerIndexVersion(8010399, Version.LUCENE_9_0_0, "27a49f3f-d3ac-4b0e-8bba-1be24daf4a56");
    public static final IndexVersion V_8_2_0 = IndexVersion.registerIndexVersion(8020099, Version.LUCENE_9_1_0, "af0ed990-2f32-42b5-aaf3-59d21a3dca7a");
    public static final IndexVersion V_8_2_1 = IndexVersion.registerIndexVersion(8020199, Version.LUCENE_9_1_0, "6e2a3812-062a-4d08-8c35-ddc930e8e246");
    public static final IndexVersion V_8_2_2 = IndexVersion.registerIndexVersion(8020299, Version.LUCENE_9_1_0, "93d1434c-3956-408b-8204-93be8ab78856");
    public static final IndexVersion V_8_2_3 = IndexVersion.registerIndexVersion(8020399, Version.LUCENE_9_1_0, "026f6904-2a04-4476-8097-02a75e37e0f7");
    public static final IndexVersion V_8_3_0 = IndexVersion.registerIndexVersion(8030099, Version.LUCENE_9_2_0, "eca8e8a3-0724-4247-a58d-e4eafcec4b3f");
    public static final IndexVersion V_8_3_1 = IndexVersion.registerIndexVersion(8030199, Version.LUCENE_9_2_0, "dac08798-c0b5-46c9-bf27-d82c617ce41f");
    public static final IndexVersion V_8_3_2 = IndexVersion.registerIndexVersion(8030299, Version.LUCENE_9_2_0, "2a0c5fb9-e8a5-4788-89f8-f5723bd68cee");
    public static final IndexVersion V_8_3_3 = IndexVersion.registerIndexVersion(8030399, Version.LUCENE_9_2_0, "440a5f5c-767a-49f7-8593-dc7627b30397");
    public static final IndexVersion V_8_4_0 = IndexVersion.registerIndexVersion(8040099, Version.LUCENE_9_3_0, "d27324da-b36c-452a-93a8-9b69a6c302a1");
    public static final IndexVersion V_8_4_1 = IndexVersion.registerIndexVersion(8040199, Version.LUCENE_9_3_0, "44108ecd-839b-423e-9ef1-9d457f244fff");
    public static final IndexVersion V_8_4_2 = IndexVersion.registerIndexVersion(8040299, Version.LUCENE_9_3_0, "9c20ed39-8c32-4cf0-9f06-42735cbf604e");
    public static final IndexVersion V_8_4_3 = IndexVersion.registerIndexVersion(8040399, Version.LUCENE_9_3_0, "e7d17607-47c0-4662-b308-beeb9a8ec552");
    public static final IndexVersion V_8_5_0 = IndexVersion.registerIndexVersion(8050099, Version.LUCENE_9_4_1, "c5284b51-7fee-4f34-a837-241bb57a7aa6");
    public static final IndexVersion V_8_5_1 = IndexVersion.registerIndexVersion(8050199, Version.LUCENE_9_4_1, "b23a983c-9630-4a2b-8352-0f52b55ff87e");
    public static final IndexVersion V_8_5_2 = IndexVersion.registerIndexVersion(8050299, Version.LUCENE_9_4_1, "cfc80b6f-cb5c-4a4c-b3af-5fa1000508a8");
    public static final IndexVersion V_8_5_3 = IndexVersion.registerIndexVersion(8050399, Version.LUCENE_9_4_2, "f8ac8061-1b17-4cab-b2f6-94df31f7552e");
    public static final IndexVersion V_8_6_0 = IndexVersion.registerIndexVersion(8060099, Version.LUCENE_9_4_2, "5e78c76c-74aa-464e-9383-89bdffb74db9");
    public static final IndexVersion V_8_6_1 = IndexVersion.registerIndexVersion(8060199, Version.LUCENE_9_4_2, "8dc502be-ef27-43b3-a27b-1cb925cbef7d");
    public static final IndexVersion V_8_6_2 = IndexVersion.registerIndexVersion(8060299, Version.LUCENE_9_4_2, "e1e73b88-d188-4d82-b5e1-dee261418783");
    public static final IndexVersion V_8_7_0 = IndexVersion.registerIndexVersion(8070099, Version.LUCENE_9_5_0, "f9227941-d6f4-462b-957f-2bcd36c28382");
    public static final IndexVersion V_8_7_1 = IndexVersion.registerIndexVersion(8070199, Version.LUCENE_9_5_0, "758780b8-4b0c-44c6-af5d-fdac10b6093a");
    public static final IndexVersion V_8_8_0 = IndexVersion.registerIndexVersion(8080099, Version.LUCENE_9_6_0, "d6ffc8d7-f6bd-469b-8495-01688c310000");
    public static final IndexVersion V_8_8_1 = IndexVersion.registerIndexVersion(0x7B4B47, Version.LUCENE_9_6_0, "a613499e-ec1a-4b0b-81d3-a766aff3c27c");
    public static final IndexVersion V_8_8_2 = IndexVersion.registerIndexVersion(8080299, Version.LUCENE_9_6_0, "9db9d888-6be8-4a58-825c-f423fd8c6b00");
    public static final IndexVersion V_8_9_0 = IndexVersion.registerIndexVersion(8090099, Version.LUCENE_9_7_0, "32f6dbab-cc24-4f5b-87b5-015a848480d9");
    public static final IndexVersion V_8_9_1 = IndexVersion.registerIndexVersion(8090199, Version.LUCENE_9_7_0, "955a80ac-f70c-40a5-9399-1d8a1e5d342d");
    public static final IndexVersion V_8_9_2 = IndexVersion.registerIndexVersion(0x7B72BB, Version.LUCENE_9_7_0, "14c7d64c-9e25-4265-b4fa-e0c5aca67f14");
    public static final IndexVersion V_8_10_0 = IndexVersion.registerIndexVersion(8100099, Version.LUCENE_9_7_0, "2e107286-12ad-4c51-9a6f-f8943663b6e7");
    public static final IndexVersion V_8_10_1 = IndexVersion.registerIndexVersion(8100199, Version.LUCENE_9_7_0, "5f4ccc3d-3769-4aef-819d-945c47b9a08b");
    public static final IndexVersion V_8_10_2 = IndexVersion.registerIndexVersion(8100299, Version.LUCENE_9_7_0, "afcbbc72-deae-4bb8-82ff-48a5c7eea074");
    public static final IndexVersion V_8_10_3 = IndexVersion.registerIndexVersion(8100399, Version.LUCENE_9_7_0, "8b688969-619f-4941-bd69-8d97905374b1");
    public static final IndexVersion V_8_10_4 = IndexVersion.registerIndexVersion(8100499, Version.LUCENE_9_7_0, "ba2619f3-e303-47ee-b30c-31de233e5294");
    public static final IndexVersion MINIMUM_COMPATIBLE = V_7_0_0;
    private static final NavigableMap<Integer, IndexVersion> VERSION_IDS;

    private static IndexVersion registerIndexVersion(int id, Version luceneVersion, String uniqueId) {
        if (IDS == null) {
            throw new IllegalStateException("The IDS map needs to be present to call this method");
        }
        Strings.requireNonEmpty(uniqueId, "Each IndexVersion needs a unique string id");
        Integer existing = IDS.put(uniqueId, id);
        if (existing != null) {
            throw new IllegalArgumentException("Versions " + id + " and " + existing + " have the same unique id");
        }
        return new IndexVersion(id, luceneVersion);
    }

    static NavigableMap<Integer, IndexVersion> getAllVersionIds(Class<?> cls) {
        HashMap<Integer, String> versionIdFields = new HashMap<Integer, String>();
        TreeMap<Integer, IndexVersion> builder = new TreeMap<Integer, IndexVersion>();
        Set<String> ignore = Set.of("ZERO", "CURRENT", "MINIMUM_COMPATIBLE");
        for (Field declaredField : cls.getFields()) {
            IndexVersion version;
            String fieldName;
            if (!declaredField.getType().equals(IndexVersion.class) || ignore.contains(fieldName = declaredField.getName())) continue;
            try {
                version = (IndexVersion)declaredField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            builder.put(version.id, version);
            if (!Assertions.ENABLED) continue;
            String sameVersionNumber = versionIdFields.put(version.id, fieldName);
            assert (sameVersionNumber == null) : "Versions [" + sameVersionNumber + "] and [" + fieldName + "] have the same version number [" + version.id + "]. Each IndexVersion should have a different version number";
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    static Collection<IndexVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    public static IndexVersion readVersion(StreamInput in) throws IOException {
        return IndexVersion.fromId(in.readVInt());
    }

    public static IndexVersion fromId(int id) {
        IndexVersion known = (IndexVersion)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        Map.Entry<Integer, IndexVersion> prev = VERSION_IDS.floorEntry(id);
        Version luceneVersion = prev != null ? prev.getValue().luceneVersion : Version.fromBits((int)(IndexVersion.VERSION_IDS.firstEntry().getValue().luceneVersion.major - 1), (int)0, (int)0);
        return new IndexVersion(id, luceneVersion);
    }

    public static void writeVersion(IndexVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static IndexVersion min(IndexVersion version1, IndexVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static IndexVersion max(IndexVersion version1, IndexVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static IndexVersion current() {
        return CurrentHolder.CURRENT;
    }

    public boolean isLegacyIndexVersion() {
        return this.before(MINIMUM_COMPATIBLE);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexVersion version = (IndexVersion)o;
        return this.id == version.id;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    static {
        IDS = null;
        VERSION_IDS = IndexVersion.getAllVersionIds(IndexVersion.class);
    }

    private static class CurrentHolder {
        private static final IndexVersion CURRENT = CurrentHolder.findCurrent(V_8_10_4);

        private CurrentHolder() {
        }

        private static IndexVersion findCurrent(IndexVersion fallback) {
            VersionExtension versionExtension = VersionExtension.load();
            if (versionExtension == null) {
                return fallback;
            }
            IndexVersion version = versionExtension.getCurrentIndexVersion();
            assert (version.onOrAfter(fallback));
            assert (version.luceneVersion.equals((Object)Version.LATEST)) : "IndexVersion must be upgraded to [" + Version.LATEST + "] is still set to [" + version.luceneVersion + "]";
            return version;
        }
    }
}

