/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.io.IOException;
import java.util.Comparator;
import java.util.Locale;
import java.util.stream.Stream;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum HealthStatus implements Writeable
{
    GREEN(0),
    UNKNOWN(1),
    YELLOW(2),
    RED(3);

    private final byte value;

    private HealthStatus(byte value) {
        this.value = value;
    }

    public static HealthStatus read(StreamInput in) throws IOException {
        byte value = in.readByte();
        return switch (value) {
            case 0 -> GREEN;
            case 1 -> UNKNOWN;
            case 2 -> YELLOW;
            case 3 -> RED;
            default -> throw new IllegalArgumentException("unknown value for health status [" + value + "]");
        };
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public byte value() {
        return this.value;
    }

    public boolean indicatesHealthProblem() {
        return this.value > UNKNOWN.value();
    }

    public static HealthStatus merge(Stream<HealthStatus> statuses) {
        return statuses.max(Comparator.comparing(HealthStatus::value)).orElseThrow(() -> new IllegalArgumentException("Cannot merge empty health status stream."));
    }

    public String xContentValue() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static HealthStatus fromCoordinationDiagnosticsStatus(CoordinationDiagnosticsService.CoordinationDiagnosticsStatus coordinationDiagnosticsStatus) {
        return switch (coordinationDiagnosticsStatus) {
            default -> throw new IncompatibleClassChangeError();
            case CoordinationDiagnosticsService.CoordinationDiagnosticsStatus.GREEN -> GREEN;
            case CoordinationDiagnosticsService.CoordinationDiagnosticsStatus.YELLOW -> YELLOW;
            case CoordinationDiagnosticsService.CoordinationDiagnosticsStatus.RED -> RED;
            case CoordinationDiagnosticsService.CoordinationDiagnosticsStatus.UNKNOWN -> UNKNOWN;
        };
    }
}

