/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class GatewayService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(GatewayService.class);
    public static final Setting<Integer> EXPECTED_DATA_NODES_SETTING = Setting.intSetting("gateway.expected_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RECOVER_AFTER_TIME_SETTING = Setting.positiveTimeSetting("gateway.recover_after_time", TimeValue.timeValueMillis((long)0L), Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_DATA_NODES_SETTING = Setting.intSetting("gateway.recover_after_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final ClusterBlock STATE_NOT_RECOVERED_BLOCK = new ClusterBlock(1, "state not recovered / initialized", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    static final TimeValue DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET = TimeValue.timeValueMinutes((long)5L);
    private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;
    private final ThreadPool threadPool;
    private final RerouteService rerouteService;
    private final ClusterService clusterService;
    private final TimeValue recoverAfterTime;
    private final int recoverAfterDataNodes;
    private final int expectedDataNodes;
    private final AtomicBoolean recoveryInProgress = new AtomicBoolean();
    private final AtomicBoolean scheduledRecovery = new AtomicBoolean();
    private static final String TASK_SOURCE = "local-gateway-elected-state";

    @Inject
    public GatewayService(Settings settings, RerouteService rerouteService, ClusterService clusterService, ShardRoutingRoleStrategy shardRoutingRoleStrategy, ThreadPool threadPool) {
        this.rerouteService = rerouteService;
        this.clusterService = clusterService;
        this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
        this.threadPool = threadPool;
        this.expectedDataNodes = EXPECTED_DATA_NODES_SETTING.get(settings);
        this.recoverAfterTime = RECOVER_AFTER_TIME_SETTING.exists(settings) ? RECOVER_AFTER_TIME_SETTING.get(settings) : (this.expectedDataNodes >= 0 ? DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET : null);
        this.recoverAfterDataNodes = RECOVER_AFTER_DATA_NODES_SETTING.get(settings);
    }

    @Override
    protected void doStart() {
        if (DiscoveryNode.isMasterNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (!state.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNodes nodes = state.nodes();
        if (state.nodes().getMasterNodeId() == null) {
            logger.debug("not recovering from gateway, no master elected yet");
        } else if (this.recoverAfterDataNodes != -1 && nodes.getDataNodes().size() < this.recoverAfterDataNodes) {
            logger.debug("not recovering from gateway, nodes_size (data) [{}] < recover_after_data_nodes [{}]", (Object)nodes.getDataNodes().size(), (Object)this.recoverAfterDataNodes);
        } else {
            Object reason;
            boolean enforceRecoverAfterTime;
            if (this.expectedDataNodes == -1) {
                enforceRecoverAfterTime = true;
                reason = "recover_after_time was set to [" + this.recoverAfterTime + "]";
            } else if (this.expectedDataNodes <= nodes.getDataNodes().size()) {
                enforceRecoverAfterTime = false;
                reason = "";
            } else {
                enforceRecoverAfterTime = true;
                reason = "expecting [" + this.expectedDataNodes + "] data nodes, but only have [" + nodes.getDataNodes().size() + "]";
            }
            this.performStateRecovery(enforceRecoverAfterTime, (String)reason);
        }
    }

    private void performStateRecovery(boolean enforceRecoverAfterTime, String reason) {
        if (enforceRecoverAfterTime && this.recoverAfterTime != null) {
            if (this.scheduledRecovery.compareAndSet(false, true)) {
                logger.info("delaying initial state recovery for [{}]. {}", (Object)this.recoverAfterTime, (Object)reason);
                this.threadPool.schedule(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("delayed state recovery failed", (Throwable)e);
                        GatewayService.this.resetRecoveredFlags();
                    }

                    @Override
                    protected void doRun() {
                        if (GatewayService.this.recoveryInProgress.compareAndSet(false, true)) {
                            logger.info("recover_after_time [{}] elapsed. performing state recovery...", (Object)GatewayService.this.recoverAfterTime);
                            GatewayService.this.runRecovery();
                        }
                    }
                }, this.recoverAfterTime, "generic");
            }
        } else if (this.recoveryInProgress.compareAndSet(false, true)) {
            try {
                logger.debug("performing state recovery...");
                this.runRecovery();
            }
            catch (Exception e) {
                logger.warn("state recovery failed", (Throwable)e);
                this.resetRecoveredFlags();
            }
        }
    }

    private void resetRecoveredFlags() {
        this.recoveryInProgress.set(false);
        this.scheduledRecovery.set(false);
    }

    TimeValue recoverAfterTime() {
        return this.recoverAfterTime;
    }

    private void runRecovery() {
        this.submitUnbatchedTask(TASK_SOURCE, new RecoverStateUpdateTask());
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    class RecoverStateUpdateTask
    extends ClusterStateUpdateTask {
        RecoverStateUpdateTask() {
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            if (!currentState.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
                logger.debug("cluster is already recovered");
                return currentState;
            }
            return ClusterStateUpdaters.removeStateNotRecoveredBlock(ClusterStateUpdaters.updateRoutingTable(currentState, GatewayService.this.shardRoutingRoleStrategy));
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            logger.info("recovered [{}] indices into cluster_state", (Object)newState.metadata().indices().size());
            GatewayService.this.rerouteService.reroute("state recovered", Priority.NORMAL, ActionListener.running(GatewayService.this::resetRecoveredFlags));
        }

        @Override
        public void onFailure(Exception e) {
            logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.INFO, () -> "unexpected failure during [local-gateway-elected-state]", (Throwable)e);
            GatewayService.this.resetRecoveredFlags();
        }
    }
}

