/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public abstract class EsRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final CounterMetric rejected = new CounterMetric();

    public long rejected() {
        return this.rejected.count();
    }

    protected void incrementRejections() {
        this.rejected.inc();
    }

    protected static EsRejectedExecutionException newRejectedException(Runnable r, ThreadPoolExecutor executor, boolean isExecutorShutdown) {
        StringBuilder builder = new StringBuilder("rejected execution of ").append(r).append(" on ").append(executor);
        if (isExecutorShutdown) {
            builder.append(" (shutdown)");
        }
        return new EsRejectedExecutionException(builder.toString(), isExecutorShutdown);
    }
}

