/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.common.Strings;

@Deprecated(since="v8")
@Plugin(name="ESJsonLayout", category="Core", elementType="layout", printObject=true)
public class ESJsonLayout
extends AbstractStringLayout {
    private final PatternLayout patternLayout;
    private String esmessagefields;

    protected ESJsonLayout(String typeName, Charset charset, String[] overrideFields, Configuration config) {
        super(charset);
        this.esmessagefields = String.join((CharSequence)",", overrideFields);
        this.patternLayout = PatternLayout.newBuilder().withPattern(ESJsonLayout.pattern(typeName, overrideFields)).withAlwaysWriteExceptions(false).withConfiguration(config).build();
    }

    private static String pattern(String type, String[] esmessagefields) {
        if (Strings.isEmpty(type)) {
            throw new IllegalArgumentException("layout parameter 'type_name' cannot be empty");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", ESJsonLayout.inQuotes(type));
        map.put("timestamp", ESJsonLayout.inQuotes("%d{yyyy-MM-dd'T'HH:mm:ss,SSSZZ}"));
        map.put("level", ESJsonLayout.inQuotes("%p"));
        map.put("component", ESJsonLayout.inQuotes("%c{1.}"));
        map.put("cluster.name", ESJsonLayout.inQuotes("${sys:es.logs.cluster_name}"));
        map.put("node.name", ESJsonLayout.inQuotes("%node_name"));
        map.put("message", ESJsonLayout.inQuotes("%notEmpty{%enc{%marker}{JSON} }%enc{%.-10000m}{JSON}"));
        for (String key : esmessagefields) {
            map.remove(key);
        }
        return ESJsonLayout.createPattern(map, Set.of(esmessagefields));
    }

    private static String createPattern(Map<String, Object> map, Set<String> esmessagefields) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String separator = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!esmessagefields.contains(entry.getKey())) {
                sb.append(separator);
                ESJsonLayout.appendField(sb, entry);
            }
            separator = ", ";
        }
        sb.append(ESJsonLayout.notEmpty(", %node_and_cluster_id "));
        sb.append(ESJsonLayout.notEmpty(", %CustomMapFields "));
        sb.append("%exceptionAsJson ");
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private static void appendField(StringBuilder sb, Map.Entry<String, Object> entry) {
        sb.append(ESJsonLayout.jsonKey(entry.getKey()));
        sb.append(entry.getValue().toString());
    }

    private static String notEmpty(String value) {
        return "%notEmpty{" + value + "}";
    }

    private static CharSequence jsonKey(String s) {
        return ESJsonLayout.inQuotes(s) + ": ";
    }

    private static String inQuotes(String s) {
        return "\"" + s + "\"";
    }

    @PluginFactory
    public static ESJsonLayout createLayout(String type, Charset charset, String[] overrideFields, Configuration configuration) {
        return new ESJsonLayout(type, charset, overrideFields, configuration);
    }

    PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public String toSerializable(LogEvent event) {
        return this.patternLayout.toSerializable(event);
    }

    public Map<String, String> getContentFormat() {
        return this.patternLayout.getContentFormat();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        this.patternLayout.encode(event, destination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ESJsonLayout{");
        sb.append("patternLayout=").append(this.patternLayout);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ESJsonLayout> {
        @PluginAttribute(value="type_name")
        String type;
        @PluginAttribute(value="charset", defaultString="UTF-8")
        Charset charset;
        @PluginAttribute(value="esmessagefields")
        private String overrideFields;
        @PluginConfiguration
        private Configuration config;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public ESJsonLayout build() {
            String[] split = Strings.isNullOrEmpty(this.overrideFields) ? new String[]{} : this.overrideFields.split(",");
            return ESJsonLayout.createLayout(this.type, this.charset, split, (Configuration)new DefaultConfiguration());
        }

        public Charset getCharset() {
            return this.charset;
        }

        public B setCharset(Charset charset) {
            this.charset = charset;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getType() {
            return this.type;
        }

        public B setType(String type) {
            this.type = type;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getOverrideFields() {
            return this.overrideFields;
        }

        public B setOverrideFields(String overrideFields) {
            this.overrideFields = overrideFields;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

