/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;

public class ByteArrayStreamInput
extends StreamInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayStreamInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public ByteArrayStreamInput(byte[] bytes) {
        this.reset(bytes);
    }

    @Override
    public int read() throws IOException {
        if (this.limit - this.pos <= 0) {
            return -1;
        }
        return this.readByte() & 0xFF;
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public int length() {
        return this.limit;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public void skipBytes(long count) {
        this.pos += (int)count;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.limit - this.pos;
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        int available = this.limit - this.pos;
        if (length > available) {
            ByteArrayStreamInput.throwEOF(length, available);
        }
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }
}

