/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1) throws IOException;

    public InputStream readBlob(String var1) throws IOException;

    public InputStream readBlob(String var1, long var2, long var4) throws IOException;

    default public long readBlobPreferredLength() {
        throw new UnsupportedOperationException();
    }

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    default public void writeBlob(String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, bytes.streamInput(), bytes.length(), failIfAlreadyExists);
    }

    public void writeMetadataBlob(String var1, boolean var2, boolean var3, CheckedConsumer<OutputStream, IOException> var4) throws IOException;

    public void writeBlobAtomic(String var1, BytesReference var2, boolean var3) throws IOException;

    public DeleteResult delete() throws IOException;

    public void deleteBlobsIgnoringIfNotExists(Iterator<String> var1) throws IOException;

    public Map<String, BlobMetadata> listBlobs() throws IOException;

    public Map<String, BlobContainer> children() throws IOException;

    public Map<String, BlobMetadata> listBlobsByPrefix(String var1) throws IOException;

    public void compareAndExchangeRegister(String var1, BytesReference var2, BytesReference var3, ActionListener<OptionalBytesReference> var4);

    default public void compareAndSetRegister(String key, BytesReference expected, BytesReference updated, ActionListener<Boolean> listener) {
        this.compareAndExchangeRegister(key, expected, updated, listener.map(witness -> witness.isPresent() && witness.bytesReference().equals(expected)));
    }

    default public void getRegister(String key, ActionListener<OptionalBytesReference> listener) {
        this.compareAndExchangeRegister(key, BytesArray.EMPTY, BytesArray.EMPTY, listener);
    }
}

