/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_version";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            if (shardRouting.currentNodeId() == null) {
                if (shardRouting.recoverySource() != null && shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
                    return NodeVersionAllocationDecider.isVersionCompatible((RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource(), node, allocation);
                }
                return allocation.decision(Decision.YES, NAME, "the primary shard is new or already existed on the node", new Object[0]);
            }
            return NodeVersionAllocationDecider.isVersionCompatibleRelocatePrimary(allocation.routingNodes(), shardRouting.currentNodeId(), node, allocation);
        }
        ShardRouting primary = allocation.routingNodes().activePrimary(shardRouting.shardId());
        if (primary != null) {
            return NodeVersionAllocationDecider.isVersionCompatibleAllocatingReplica(allocation.routingNodes(), primary.currentNodeId(), node, allocation);
        }
        return allocation.decision(Decision.YES, NAME, "no active primary shard yet", new Object[0]);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static Decision isVersionCompatibleRelocatePrimary(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getVersion().onOrAfter(source.node().getVersion())) {
            return allocation.decision(Decision.YES, NAME, "can relocate primary shard from a node with version [%s] to a node with equal-or-newer version [%s]", source.node().getVersion(), target.node().getVersion());
        }
        return allocation.decision(Decision.NO, NAME, "cannot relocate primary shard from a node with version [%s] to a node with older version [%s]", source.node().getVersion(), target.node().getVersion());
    }

    private static Decision isVersionCompatibleAllocatingReplica(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().getVersion().onOrAfter(source.node().getVersion())) {
            return allocation.decision(Decision.YES, NAME, "can allocate replica shard to a node with version [%s] since this is equal-or-newer than the primary version [%s]", target.node().getVersion(), source.node().getVersion());
        }
        return allocation.decision(Decision.NO, NAME, "cannot allocate replica shard to a node with version [%s] since this is older than the primary version [%s]", target.node().getVersion(), source.node().getVersion());
    }

    private static Decision isVersionCompatible(RecoverySource.SnapshotRecoverySource recoverySource, RoutingNode target, RoutingAllocation allocation) {
        if (target.node().getMaxIndexVersion().onOrAfter(recoverySource.version())) {
            return allocation.decision(Decision.YES, NAME, "max supported index version [%s] is the same or newer than snapshot version [%s]", target.node().getMaxIndexVersion(), recoverySource.version());
        }
        return allocation.decision(Decision.NO, NAME, "max supported index version [%s] is older than the snapshot version [%s]", target.node().getMaxIndexVersion(), recoverySource.version());
    }
}

