/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record DesiredBalanceStats(long lastConvergedIndex, boolean computationActive, long computationSubmitted, long computationExecuted, long computationConverged, long computationIterations, long computedShardMovements, long cumulativeComputationTime, long cumulativeReconciliationTime) implements Writeable,
ToXContentObject
{
    private static final TransportVersion COMPUTED_SHARD_MOVEMENTS_VERSION = TransportVersion.V_8_8_0;

    public static DesiredBalanceStats readFrom(StreamInput in) throws IOException {
        return new DesiredBalanceStats(in.readVLong(), in.readBoolean(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.getTransportVersion().onOrAfter(COMPUTED_SHARD_MOVEMENTS_VERSION) ? in.readVLong() : -1L, in.readVLong(), in.readVLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.lastConvergedIndex);
        out.writeBoolean(this.computationActive);
        out.writeVLong(this.computationSubmitted);
        out.writeVLong(this.computationExecuted);
        out.writeVLong(this.computationConverged);
        out.writeVLong(this.computationIterations);
        if (out.getTransportVersion().onOrAfter(COMPUTED_SHARD_MOVEMENTS_VERSION)) {
            out.writeVLong(this.computedShardMovements);
        }
        out.writeVLong(this.cumulativeComputationTime);
        out.writeVLong(this.cumulativeReconciliationTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("computation_converged_index", this.lastConvergedIndex);
        builder.field("computation_active", this.computationActive);
        builder.field("computation_submitted", this.computationSubmitted);
        builder.field("computation_executed", this.computationExecuted);
        builder.field("computation_converged", this.computationConverged);
        builder.field("computation_iterations", this.computationIterations);
        builder.field("computed_shard_movements", this.computedShardMovements);
        builder.humanReadableField("computation_time_in_millis", "computation_time", (Object)new TimeValue(this.cumulativeComputationTime));
        builder.humanReadableField("reconciliation_time_in_millis", "reconciliation_time", (Object)new TimeValue(this.cumulativeReconciliationTime));
        builder.endObject();
        return builder;
    }
}

