/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class AllocateUnassignedDecision
extends AbstractAllocationDecision {
    public static final AllocateUnassignedDecision NOT_TAKEN = new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.NO_ATTEMPT, null, null, null, false, 0L, 0L);
    private static final Map<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision> CACHED_DECISIONS;
    @Nullable
    private final UnassignedInfo.AllocationStatus allocationStatus;
    @Nullable
    private final String allocationId;
    private final boolean reuseStore;
    private final long remainingDelayInMillis;
    private final long configuredDelayInMillis;

    private AllocateUnassignedDecision(UnassignedInfo.AllocationStatus allocationStatus, DiscoveryNode assignedNode, String allocationId, List<NodeAllocationResult> nodeDecisions, boolean reuseStore, long remainingDelayInMillis, long configuredDelayInMillis) {
        super(assignedNode, nodeDecisions);
        assert (assignedNode != null || allocationStatus != null) : "a yes decision must have a node to assign the shard to";
        assert (allocationId == null || assignedNode != null) : "allocation id can only be null if the assigned node is null";
        this.allocationStatus = allocationStatus;
        this.allocationId = allocationId;
        this.reuseStore = reuseStore;
        this.remainingDelayInMillis = remainingDelayInMillis;
        this.configuredDelayInMillis = configuredDelayInMillis;
    }

    public AllocateUnassignedDecision(StreamInput in) throws IOException {
        super(in);
        this.allocationStatus = in.readOptionalWriteable(UnassignedInfo.AllocationStatus::readFrom);
        this.allocationId = in.readOptionalString();
        this.reuseStore = in.readBoolean();
        this.remainingDelayInMillis = in.readVLong();
        this.configuredDelayInMillis = in.readVLong();
    }

    public static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable List<NodeAllocationResult> decisions) {
        return AllocateUnassignedDecision.no(allocationStatus, decisions, false);
    }

    public static AllocateUnassignedDecision delayed(long remainingDelay, long totalDelay, @Nullable List<NodeAllocationResult> decisions) {
        return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, decisions, false, remainingDelay, totalDelay);
    }

    public static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable List<NodeAllocationResult> decisions, boolean reuseStore) {
        return AllocateUnassignedDecision.no(allocationStatus, decisions, reuseStore, 0L, 0L);
    }

    private static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable List<NodeAllocationResult> decisions, boolean reuseStore, long remainingDelay, long totalDelay) {
        if (decisions != null) {
            return new AllocateUnassignedDecision(allocationStatus, null, null, decisions, reuseStore, remainingDelay, totalDelay);
        }
        return AllocateUnassignedDecision.getCachedDecision(allocationStatus);
    }

    public static AllocateUnassignedDecision throttle(@Nullable List<NodeAllocationResult> decisions) {
        if (decisions != null) {
            return new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, null, null, decisions, false, 0L, 0L);
        }
        return AllocateUnassignedDecision.getCachedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED);
    }

    public static AllocateUnassignedDecision yes(DiscoveryNode assignedNode, @Nullable String allocationId, @Nullable List<NodeAllocationResult> decisions, boolean reuseStore) {
        return new AllocateUnassignedDecision(null, assignedNode, allocationId, decisions, reuseStore, 0L, 0L);
    }

    public static AllocateUnassignedDecision fromDecision(Decision decision, @Nullable DiscoveryNode assignedNode, @Nullable List<NodeAllocationResult> nodeDecisions) {
        Decision.Type decisionType = decision.type();
        UnassignedInfo.AllocationStatus allocationStatus = decisionType != Decision.Type.YES ? UnassignedInfo.AllocationStatus.fromDecision(decisionType) : null;
        return new AllocateUnassignedDecision(allocationStatus, assignedNode, null, nodeDecisions, false, 0L, 0L);
    }

    private static AllocateUnassignedDecision getCachedDecision(UnassignedInfo.AllocationStatus allocationStatus) {
        AllocateUnassignedDecision decision = CACHED_DECISIONS.get(allocationStatus);
        return Objects.requireNonNull(decision, "precomputed decision not found for " + allocationStatus);
    }

    @Override
    public boolean isDecisionTaken() {
        return this.allocationStatus != UnassignedInfo.AllocationStatus.NO_ATTEMPT;
    }

    public AllocationDecision getAllocationDecision() {
        this.checkDecisionState();
        return AllocationDecision.fromAllocationStatus(this.allocationStatus);
    }

    @Nullable
    public UnassignedInfo.AllocationStatus getAllocationStatus() {
        this.checkDecisionState();
        return this.allocationStatus;
    }

    @Nullable
    public String getAllocationId() {
        this.checkDecisionState();
        return this.allocationId;
    }

    public long getRemainingDelayInMillis() {
        this.checkDecisionState();
        return this.remainingDelayInMillis;
    }

    public long getConfiguredDelayInMillis() {
        this.checkDecisionState();
        return this.configuredDelayInMillis;
    }

    @Override
    public String getExplanation() {
        this.checkDecisionState();
        return switch (this.getAllocationDecision()) {
            default -> throw new IncompatibleClassChangeError();
            case AllocationDecision.YES -> "Elasticsearch can allocate the shard.";
            case AllocationDecision.THROTTLED -> "Elasticsearch is currently busy with other activities. It expects to be able to allocate this shard when those activities finish. Please wait.";
            case AllocationDecision.AWAITING_INFO -> "Elasticsearch is retrieving information about this shard from one or more nodes. It will make an allocation decision after it receives this information. Please wait.";
            case AllocationDecision.NO_VALID_SHARD_COPY -> {
                if (this.hasNodeWithStaleOrCorruptShard()) {
                    yield "Elasticsearch can't allocate this shard because all the copies of its data in the cluster are stale or corrupt. Elasticsearch will allocate this shard when a node containing a good copy of its data joins the cluster. If no such node is available, restore this index from a recent snapshot.";
                }
                yield "Elasticsearch can't allocate this shard because there are no copies of its data in the cluster. Elasticsearch will allocate this shard when a node holding a good copy of its data joins the cluster. If no such node is available, restore this index from a recent snapshot.";
            }
            case AllocationDecision.ALLOCATION_DELAYED -> String.format(Locale.ROOT, this.atLeastOneNodeWithYesDecision() ? "The node containing this shard copy recently left the cluster. Elasticsearch is waiting for it to return. If the node does not return within [%s] then Elasticsearch will allocate this shard to another node. Please wait." : "The node holding this shard copy recently left the cluster. Elasticsearch is waiting for it to return. If the node does not return within [%s] then Elasticsearch will attempt to allocate this shard to another node, but it cannot be allocated to any other node currently in the cluster. If you expect this shard to be allocated to another node, find this node in the node-by-node explanation and address the reasons which prevent Elasticsearch from allocating this shard there.", TimeValue.timeValueMillis((long)this.remainingDelayInMillis));
            case AllocationDecision.NO -> {
                if (this.reuseStore) {
                    yield "Elasticsearch isn't allowed to allocate this shard to any of the nodes in the cluster that hold an in-sync copy of its data. Choose a node to which you expect this shard to be allocated, find this node in the node-by-node explanation, and address the reasons which prevent Elasticsearch from allocating this shard there.";
                }
                yield "Elasticsearch isn't allowed to allocate this shard to any of the nodes in the cluster. Choose a node to which you expect this shard to be allocated, find this node in the node-by-node explanation, and address the reasons which prevent Elasticsearch from allocating this shard there.";
            }
            case AllocationDecision.WORSE_BALANCE, AllocationDecision.NO_ATTEMPT -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.getAllocationDecision());
                }
                yield this.getAllocationDecision().toString();
            }
        };
    }

    private boolean hasNodeWithStaleOrCorruptShard() {
        return this.getNodeDecisions() != null && this.getNodeDecisions().stream().anyMatch(result -> result.getShardStoreInfo() != null && (result.getShardStoreInfo().getAllocationId() != null || result.getShardStoreInfo().getStoreException() != null));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.checkDecisionState();
        builder.field("can_allocate", (Enum)this.getAllocationDecision());
        builder.field("allocate_explanation", this.getExplanation());
        if (this.targetNode != null) {
            builder.startObject("target_node");
            AllocateUnassignedDecision.discoveryNodeToXContent(this.targetNode, true, builder);
            builder.endObject();
        }
        if (this.allocationId != null) {
            builder.field("allocation_id", this.allocationId);
        }
        if (this.allocationStatus == UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION) {
            builder.humanReadableField("configured_delay_in_millis", "configured_delay", (Object)TimeValue.timeValueMillis((long)this.configuredDelayInMillis));
            builder.humanReadableField("remaining_delay_in_millis", "remaining_delay", (Object)TimeValue.timeValueMillis((long)this.remainingDelayInMillis));
        }
        AllocateUnassignedDecision.nodeDecisionsToXContent(this.nodeDecisions, builder, params);
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.allocationStatus);
        out.writeOptionalString(this.allocationId);
        out.writeBoolean(this.reuseStore);
        out.writeVLong(this.remainingDelayInMillis);
        out.writeVLong(this.configuredDelayInMillis);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof AllocateUnassignedDecision)) {
            return false;
        }
        AllocateUnassignedDecision that = (AllocateUnassignedDecision)other;
        return Objects.equals(this.allocationStatus, that.allocationStatus) && Objects.equals(this.allocationId, that.allocationId) && this.reuseStore == that.reuseStore && this.configuredDelayInMillis == that.configuredDelayInMillis && this.remainingDelayInMillis == that.remainingDelayInMillis;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.allocationStatus, this.allocationId, this.reuseStore, this.configuredDelayInMillis, this.remainingDelayInMillis);
    }

    static {
        EnumMap<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision> cachedDecisions = new EnumMap<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision>(UnassignedInfo.AllocationStatus.class);
        cachedDecisions.put(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DECIDERS_NO, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DECIDERS_NO, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, null, null, null, false, 0L, 0L));
        CACHED_DECISIONS = Collections.unmodifiableMap(cachedDecisions);
    }
}

