/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

public enum Preference {
    SHARDS("_shards"),
    PREFER_NODES("_prefer_nodes"),
    LOCAL("_local"),
    ONLY_LOCAL("_only_local"),
    ONLY_NODES("_only_nodes");

    private final String type;

    private Preference(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public static Preference parse(String preference) {
        int colonIndex = preference.indexOf(58);
        String preferenceType = colonIndex == -1 ? preference : preference.substring(0, colonIndex);
        return switch (preferenceType) {
            case "_shards" -> SHARDS;
            case "_prefer_nodes" -> PREFER_NODES;
            case "_local" -> LOCAL;
            case "_only_local", "_onlyLocal" -> ONLY_LOCAL;
            case "_only_nodes" -> ONLY_NODES;
            default -> throw new IllegalArgumentException("no Preference for [" + preferenceType + "]");
        };
    }
}

