/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record ReservedStateErrorMetadata(Long version, ErrorKind errorKind, List<String> errors) implements SimpleDiffable<ReservedStateErrorMetadata>,
ToXContentFragment
{
    static final ParseField ERRORS = new ParseField("errors", new String[0]);
    static final ParseField VERSION = new ParseField("version", new String[0]);
    static final ParseField ERROR_KIND = new ParseField("error_kind", new String[0]);
    private static final ConstructingObjectParser<ReservedStateErrorMetadata, Void> PARSER = new ConstructingObjectParser("reserved_state_error_metadata", a -> new ReservedStateErrorMetadata((Long)a[0], ErrorKind.of((String)a[1]), (List)a[2]));

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.errorKind.getKindValue());
        out.writeCollection(this.errors, StreamOutput::writeString);
    }

    public static ReservedStateErrorMetadata readFrom(StreamInput in) throws IOException {
        return new ReservedStateErrorMetadata(in.readLong(), ErrorKind.of(in.readString()), in.readList(StreamInput::readString));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VERSION.getPreferredName(), this.version);
        builder.field(ERROR_KIND.getPreferredName(), this.errorKind.getKindValue());
        builder.stringListField(ERRORS.getPreferredName(), this.errors);
        builder.endObject();
        return builder;
    }

    public static ReservedStateErrorMetadata fromXContent(XContentParser parser) {
        return (ReservedStateErrorMetadata)PARSER.apply(parser, null);
    }

    public static Diff<ReservedStateErrorMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ReservedStateErrorMetadata::readFrom, in);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ERROR_KIND);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ERRORS);
    }

    public static enum ErrorKind {
        PARSING("parsing"),
        VALIDATION("validation"),
        TRANSIENT("transient");

        private final String kind;

        private ErrorKind(String kind) {
            this.kind = kind;
        }

        public String getKindValue() {
            return this.kind;
        }

        public static ErrorKind of(String kind) {
            for (ErrorKind report : ErrorKind.values()) {
                if (!report.kind.equals(kind)) continue;
                return report;
            }
            throw new IllegalArgumentException("kind not supported [" + kind + "]");
        }
    }
}

