/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexClusterStateUpdateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;

public class MetadataDeleteIndexService {
    private static final Logger logger = LogManager.getLogger(MetadataDeleteIndexService.class);
    private final Settings settings;
    final ClusterStateTaskExecutor<DeleteIndexClusterStateUpdateRequest> executor;
    private final MasterServiceTaskQueue<DeleteIndexClusterStateUpdateRequest> taskQueue;

    @Inject
    public MetadataDeleteIndexService(Settings settings, ClusterService clusterService, final AllocationService allocationService) {
        this.settings = settings;
        this.executor = new SimpleBatchedAckListenerTaskExecutor<DeleteIndexClusterStateUpdateRequest>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(DeleteIndexClusterStateUpdateRequest task, ClusterState clusterState) {
                return Tuple.tuple((Object)MetadataDeleteIndexService.this.deleteIndices(clusterState, Sets.newHashSet(task.indices())), (Object)task);
            }

            @Override
            public ClusterState afterBatchExecution(ClusterState clusterState, boolean clusterStateChanged) {
                if (clusterStateChanged) {
                    return allocationService.reroute(clusterState, "deleted indices", AllocationActionListener.rerouteCompletionIsNotRequired());
                }
                return clusterState;
            }
        };
        this.taskQueue = clusterService.createTaskQueue("delete-index", Priority.URGENT, this.executor);
    }

    public void deleteIndices(DeleteIndexClusterStateUpdateRequest request) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.taskQueue.submitTask("delete-index " + Arrays.toString(request.indices()), request, request.masterNodeTimeout());
    }

    public ClusterState deleteIndices(ClusterState currentState, Set<Index> indices) {
        Metadata meta = currentState.metadata();
        HashSet<Index> indicesToDelete = new HashSet<Index>();
        HashMap<Index, DataStream> backingIndices = new HashMap<Index, DataStream>();
        for (Index index : indices) {
            IndexMetadata im = meta.getIndexSafe(index);
            DataStream parent = ((IndexAbstraction)meta.getIndicesLookup().get(im.getIndex().getName())).getParentDataStream();
            if (parent != null) {
                if (parent.getWriteIndex().equals(im.getIndex())) {
                    throw new IllegalArgumentException("index [" + index.getName() + "] is the write index for data stream [" + parent.getName() + "] and cannot be deleted");
                }
                backingIndices.put(index, parent);
            }
            indicesToDelete.add(im.getIndex());
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToDelete);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete indices that are being snapshotted: " + snapshottingIndices + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(meta);
        ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        IndexGraveyard.Builder graveyardBuilder = IndexGraveyard.builder(metadataBuilder.indexGraveyard());
        int previousGraveyardSize = graveyardBuilder.tombstones().size();
        for (Index index : indices) {
            String indexName = index.getName();
            logger.info("{} deleting index", (Object)index);
            routingTableBuilder.remove(indexName);
            clusterBlocksBuilder.removeIndexBlocks(indexName);
            metadataBuilder.remove(indexName);
            if (!backingIndices.containsKey(index)) continue;
            DataStream parent = metadataBuilder.dataStream(((DataStream)backingIndices.get(index)).getName());
            metadataBuilder.put(parent.removeBackingIndex(index));
        }
        IndexGraveyard currentGraveyard = graveyardBuilder.addTombstones(indices).build(this.settings);
        metadataBuilder.indexGraveyard(currentGraveyard);
        logger.trace("{} tombstones purged from the cluster state. Previous tombstone size: {}. Current tombstone size: {}.", (Object)graveyardBuilder.getNumPurged(), (Object)previousGraveyardSize, (Object)currentGraveyard.getTombstones().size());
        Metadata newMetadata = metadataBuilder.build();
        ClusterBlocks blocks = clusterBlocksBuilder.build();
        Map<String, ClusterState.Custom> customs = currentState.getCustoms();
        RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
        RestoreInProgress updatedRestoreInProgress = RestoreService.updateRestoreStateWithDeletedIndices(restoreInProgress, indices);
        if (updatedRestoreInProgress != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(customs);
            builder.put("restore", updatedRestoreInProgress);
            customs = builder.build();
        }
        return ClusterState.builder(currentState).routingTable(routingTableBuilder.build()).metadata(newMetadata).blocks(blocks).customs(customs).build();
    }
}

