/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataCreateDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataCreateDataStreamService.class);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final MetadataCreateIndexService metadataCreateIndexService;

    public MetadataCreateDataStreamService(ThreadPool threadPool, ClusterService clusterService, MetadataCreateIndexService metadataCreateIndexService) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.metadataCreateIndexService = metadataCreateIndexService;
    }

    public void createDataStream(final CreateDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        final AtomicReference firstBackingIndexRef = new AtomicReference();
        ActionListener<AcknowledgedResponse> listener = finalListener.delegateFailureAndWrap((l, response) -> {
            if (response.isAcknowledged()) {
                String firstBackingIndexName = (String)firstBackingIndexRef.get();
                assert (firstBackingIndexName != null);
                ActiveShardsObserver.waitForActiveShards(this.clusterService, new String[]{firstBackingIndexName}, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), l.map(shardsAcked -> AcknowledgedResponse.TRUE));
            } else {
                l.onResponse(AcknowledgedResponse.FALSE);
            }
        });
        final AllocationActionListener<AcknowledgedResponse> delegate = new AllocationActionListener<AcknowledgedResponse>(listener, this.threadPool.getThreadContext());
        this.submitUnbatchedTask("create-data-stream [" + request.name + "]", new AckedClusterStateUpdateTask(Priority.HIGH, request, delegate.clusterStateUpdate()){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataCreateDataStreamService.createDataStream(MetadataCreateDataStreamService.this.metadataCreateIndexService, currentState, request, delegate.reroute());
                firstBackingIndexRef.set(clusterState.metadata().dataStreams().get(request.name).getIndices().get(0).getName());
                return clusterState;
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public ClusterState createDataStream(CreateDataStreamClusterStateUpdateRequest request, ClusterState current, ActionListener<Void> listener) throws Exception {
        return MetadataCreateDataStreamService.createDataStream(this.metadataCreateIndexService, current, request, listener);
    }

    static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, ClusterState currentState, CreateDataStreamClusterStateUpdateRequest request, ActionListener<Void> listener) throws Exception {
        return MetadataCreateDataStreamService.createDataStream(metadataCreateIndexService, currentState, request, List.of(), null, listener);
    }

    static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, ClusterState currentState, CreateDataStreamClusterStateUpdateRequest request, List<IndexMetadata> backingIndices, IndexMetadata writeIndex, ActionListener<Void> listener) throws Exception {
        ComposableIndexTemplate template;
        String dataStreamName = request.name;
        SystemDataStreamDescriptor systemDataStreamDescriptor = request.getSystemDataStreamDescriptor();
        boolean isSystemDataStreamName = metadataCreateIndexService.getSystemIndices().isSystemDataStream(request.name);
        assert (isSystemDataStreamName && systemDataStreamDescriptor != null || !isSystemDataStreamName && systemDataStreamDescriptor == null) : "dataStream [" + request.name + "] is system but no system descriptor was provided!";
        Objects.requireNonNull(metadataCreateIndexService);
        Objects.requireNonNull(currentState);
        Objects.requireNonNull(backingIndices);
        if (currentState.metadata().dataStreams().containsKey(dataStreamName)) {
            throw new ResourceAlreadyExistsException("data_stream [" + dataStreamName + "] already exists", new Object[0]);
        }
        MetadataCreateIndexService.validateIndexOrAliasName(dataStreamName, (s1, s2) -> new IllegalArgumentException("data_stream [" + s1 + "] " + s2));
        if (!dataStreamName.toLowerCase(Locale.ROOT).equals(dataStreamName)) {
            throw new IllegalArgumentException("data_stream [" + dataStreamName + "] must be lowercase");
        }
        if (dataStreamName.startsWith(".ds-")) {
            throw new IllegalArgumentException("data_stream [" + dataStreamName + "] must not start with '.ds-'");
        }
        Metadata metadata = currentState.metadata();
        boolean isSystem = systemDataStreamDescriptor != null;
        ComposableIndexTemplate composableIndexTemplate = template = isSystem ? systemDataStreamDescriptor.getComposableIndexTemplate() : MetadataCreateDataStreamService.lookupTemplateForDataStream(dataStreamName, currentState.metadata());
        if (writeIndex == null) {
            String firstBackingIndexName = DataStream.getDefaultBackingIndexName(dataStreamName, 1L, request.startTime);
            CreateIndexClusterStateUpdateRequest createIndexRequest = new CreateIndexClusterStateUpdateRequest("initialize_data_stream", firstBackingIndexName, firstBackingIndexName).dataStreamName(dataStreamName).systemDataStreamDescriptor(systemDataStreamDescriptor).nameResolvedInstant(request.startTime).performReroute(request.performReroute()).setMatchingTemplate(template);
            if (isSystem) {
                createIndexRequest.settings(SystemIndexDescriptor.DEFAULT_SETTINGS);
            } else {
                createIndexRequest.settings(MetadataRolloverService.HIDDEN_INDEX_SETTINGS);
            }
            try {
                currentState = metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexRequest, false, listener);
            }
            catch (ResourceAlreadyExistsException e) {
                throw new ElasticsearchStatusException("data stream could not be created because backing index [{}] already exists", RestStatus.BAD_REQUEST, e, firstBackingIndexName);
            }
            writeIndex = currentState.metadata().index(firstBackingIndexName);
        } else {
            listener.onResponse(null);
        }
        assert (writeIndex != null);
        assert (writeIndex.mapping() != null) : "no mapping found for backing index [" + writeIndex.getIndex().getName() + "]";
        List dsBackingIndices = backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toCollection(ArrayList::new));
        dsBackingIndices.add(writeIndex.getIndex());
        boolean hidden = isSystem || template.getDataStreamTemplate().isHidden();
        IndexMode indexMode = metadata.isTimeSeriesTemplate(template) ? IndexMode.TIME_SERIES : null;
        DataStreamLifecycle lifecycle = isSystem ? MetadataIndexTemplateService.resolveLifecycle(template, systemDataStreamDescriptor.getComponentTemplates()) : MetadataIndexTemplateService.resolveLifecycle(template, metadata.componentTemplates());
        DataStream newDataStream = new DataStream(dataStreamName, dsBackingIndices, 1L, template.metadata() != null ? Map.copyOf(template.metadata()) : null, hidden, false, isSystem, template.getDataStreamTemplate().isAllowCustomRouting(), indexMode, lifecycle == null && DataStreamLifecycle.isFeatureEnabled() ? DataStreamLifecycle.DEFAULT : lifecycle);
        Metadata.Builder builder = Metadata.builder(currentState.metadata()).put(newDataStream);
        ArrayList<String> aliases = new ArrayList<String>();
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(currentState.metadata(), template);
        for (Map<String, AliasMetadata> resolvedAliasMap : resolvedAliases) {
            for (AliasMetadata alias : resolvedAliasMap.values()) {
                aliases.add(alias.getAlias());
                builder.put(alias.getAlias(), dataStreamName, alias.writeIndex(), alias.filter() == null ? null : alias.filter().string());
            }
        }
        logger.info("adding data stream [{}] with write index [{}], backing indices [{}], and aliases [{}]", (Object)dataStreamName, (Object)writeIndex.getIndex().getName(), (Object)Strings.arrayToCommaDelimitedString(backingIndices.stream().map(i -> i.getIndex().getName()).toArray()), (Object)Strings.collectionToCommaDelimitedString(aliases));
        return ClusterState.builder(currentState).metadata(builder).build();
    }

    public static ComposableIndexTemplate lookupTemplateForDataStream(String dataStreamName, Metadata metadata) {
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, dataStreamName, false);
        if (v2Template == null) {
            throw new IllegalArgumentException("no matching index template found for data stream [" + dataStreamName + "]");
        }
        ComposableIndexTemplate composableIndexTemplate = metadata.templatesV2().get(v2Template);
        if (composableIndexTemplate.getDataStreamTemplate() == null) {
            throw new IllegalArgumentException("matching index template [" + v2Template + "] for data stream [" + dataStreamName + "] has no data stream template");
        }
        return composableIndexTemplate;
    }

    public static void validateTimestampFieldMapping(MappingLookup mappingLookup) throws IOException {
        MetadataFieldMapper fieldMapper = (MetadataFieldMapper)mappingLookup.getMapper("_data_stream_timestamp");
        assert (fieldMapper != null) : "_data_stream_timestamp meta field mapper must exist";
        if (!mappingLookup.isDataStreamTimestampFieldEnabled()) {
            throw new IllegalStateException("[_data_stream_timestamp] meta field has been disabled");
        }
        fieldMapper.validate(mappingLookup);
    }

    public static final class CreateDataStreamClusterStateUpdateRequest
    extends ClusterStateUpdateRequest<CreateDataStreamClusterStateUpdateRequest> {
        private final boolean performReroute;
        private final String name;
        private final long startTime;
        private final SystemDataStreamDescriptor descriptor;

        public CreateDataStreamClusterStateUpdateRequest(String name) {
            this(name, System.currentTimeMillis(), null, TimeValue.ZERO, TimeValue.ZERO, true);
        }

        public CreateDataStreamClusterStateUpdateRequest(String name, SystemDataStreamDescriptor systemDataStreamDescriptor, TimeValue masterNodeTimeout, TimeValue timeout, boolean performReroute) {
            this(name, System.currentTimeMillis(), systemDataStreamDescriptor, masterNodeTimeout, timeout, performReroute);
        }

        public CreateDataStreamClusterStateUpdateRequest(String name, long startTime, SystemDataStreamDescriptor systemDataStreamDescriptor, TimeValue masterNodeTimeout, TimeValue timeout, boolean performReroute) {
            this.name = name;
            this.startTime = startTime;
            this.descriptor = systemDataStreamDescriptor;
            this.performReroute = performReroute;
            this.masterNodeTimeout(masterNodeTimeout);
            this.ackTimeout(timeout);
        }

        public boolean isSystem() {
            return this.descriptor != null;
        }

        public boolean performReroute() {
            return this.performReroute;
        }

        public SystemDataStreamDescriptor getSystemDataStreamDescriptor() {
            return this.descriptor;
        }
    }
}

