/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class DataStream
implements SimpleDiffable<DataStream>,
ToXContentObject,
IndexAbstraction {
    public static final String BACKING_INDEX_PREFIX = ".ds-";
    public static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
    public static final String TIMESTAMP_FIELD_NAME = "@timestamp";
    public static Comparator<LeafReader> TIMESERIES_LEAF_READERS_SORTER = Comparator.comparingLong(r -> {
        try {
            PointValues points = r.getPointValues(TIMESTAMP_FIELD_NAME);
            if (points != null) {
                byte[] sortValue = points.getMaxPackedValue();
                return LongPoint.decodeDimension((byte[])sortValue, (int)0);
            }
            return Long.MIN_VALUE;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Can't access [@timestamp] field for the index!", (Throwable)e, new Object[0]);
        }
    }).reversed();
    private final LongSupplier timeProvider;
    private final String name;
    private final List<Index> indices;
    private final long generation;
    private final Map<String, Object> metadata;
    private final boolean hidden;
    private final boolean replicated;
    private final boolean system;
    private final boolean allowCustomRouting;
    private final IndexMode indexMode;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("_meta", new String[0]);
    public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
    public static final ParseField REPLICATED_FIELD = new ParseField("replicated", new String[0]);
    public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
    public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
    public static final ParseField INDEX_MODE = new ParseField("index_mode", new String[0]);
    public static final ParseField LIFECYCLE = new ParseField("lifecycle", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> new DataStream((String)args[0], (List)args[1], (Long)args[2], (Map)args[3], args[4] != null && (Boolean)args[4] != false, args[5] != null && (Boolean)args[5] != false, args[6] != null && (Boolean)args[6] != false, args[7] != null && (Boolean)args[7] != false, args[8] != null ? IndexMode.fromString((String)args[8]) : null, DataStreamLifecycle.isFeatureEnabled() ? (DataStreamLifecycle)args[9] : null));
    public static final XContentParserConfiguration TS_EXTRACT_CONFIG;
    private static final DateFormatter TIMESTAMP_FORMATTER;

    public DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle) {
        this(name, indices, generation, metadata, hidden, replicated, system, System::currentTimeMillis, allowCustomRouting, indexMode, lifecycle);
    }

    DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, LongSupplier timeProvider, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle) {
        this.name = name;
        this.indices = List.copyOf(indices);
        this.generation = generation;
        this.metadata = metadata;
        assert (!system || hidden);
        this.hidden = hidden;
        this.replicated = replicated;
        this.timeProvider = timeProvider;
        this.system = system;
        this.allowCustomRouting = allowCustomRouting;
        this.indexMode = indexMode;
        DataStreamLifecycle dataStreamLifecycle = this.lifecycle = DataStreamLifecycle.isFeatureEnabled() ? lifecycle : null;
        assert (DataStream.assertConsistent(this.indices));
    }

    public DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, boolean allowCustomRouting, IndexMode indexMode) {
        this(name, indices, generation, metadata, hidden, replicated, system, allowCustomRouting, indexMode, null);
    }

    private static boolean assertConsistent(List<Index> indices) {
        assert (indices.size() > 0);
        HashSet<String> indexNames = new HashSet<String>();
        for (Index index : indices) {
            boolean added = indexNames.add(index.getName());
            assert (added) : "found duplicate index entries in " + indices;
        }
        return true;
    }

    @Override
    public IndexAbstraction.Type getType() {
        return IndexAbstraction.Type.DATA_STREAM;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDataStreamRelated() {
        return true;
    }

    @Override
    public List<Index> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    @Override
    public Index getWriteIndex() {
        return this.indices.get(this.indices.size() - 1);
    }

    public Index selectTimeSeriesWriteIndex(Instant timestamp, Metadata metadata) {
        for (int i = this.indices.size() - 1; i >= 0; --i) {
            Index index = this.indices.get(i);
            IndexMetadata im = metadata.index(index);
            if (im.getIndexMode() != IndexMode.TIME_SERIES) continue;
            Instant start = im.getTimeSeriesStart();
            Instant end = im.getTimeSeriesEnd();
            if (timestamp.compareTo(start) < 0 || timestamp.compareTo(end) >= 0) continue;
            return index;
        }
        return null;
    }

    public void validate(Function<String, IndexMetadata> imSupplier) {
        if (this.indexMode == IndexMode.TIME_SERIES) {
            List<Tuple> startAndEndTimes = this.indices.stream().map(index -> {
                IndexMetadata im = (IndexMetadata)imSupplier.apply(index.getName());
                if (im == null) {
                    throw new IllegalStateException("index [" + index.getName() + "] is not found in the index metadata supplier");
                }
                return im;
            }).filter(im -> im.getTimeSeriesStart() != null && im.getTimeSeriesEnd() != null).map(im -> {
                Instant start = im.getTimeSeriesStart();
                Instant end = im.getTimeSeriesEnd();
                assert (end.isAfter(start));
                return new Tuple((Object)im.getIndex().getName(), (Object)new Tuple((Object)start, (Object)end));
            }).sorted(Comparator.comparing(entry -> (Instant)((Tuple)entry.v2()).v1())).toList();
            Tuple previous = null;
            DateFormatter formatter = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
            for (Tuple current : startAndEndTimes) {
                if (previous == null) {
                    previous = current;
                    continue;
                }
                if (((Instant)((Tuple)previous.v2()).v2()).compareTo((Instant)((Tuple)current.v2()).v1()) <= 0) continue;
                String range1 = formatter.format((TemporalAccessor)((Tuple)previous.v2()).v1()) + " TO " + formatter.format((TemporalAccessor)((Tuple)previous.v2()).v2());
                String range2 = formatter.format((TemporalAccessor)((Tuple)current.v2()).v1()) + " TO " + formatter.format((TemporalAccessor)((Tuple)current.v2()).v2());
                throw new IllegalArgumentException("backing index [" + (String)previous.v1() + "] with range [" + range1 + "] is overlapping with backing index [" + (String)current.v1() + "] with range [" + range2 + "]");
            }
        }
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    public boolean isAllowCustomRouting() {
        return this.allowCustomRouting;
    }

    @Nullable
    public IndexMode getIndexMode() {
        return this.indexMode;
    }

    @Nullable
    public DataStreamLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public DataStream rollover(Index writeIndex, long generation, boolean timeSeries) {
        this.ensureNotReplicated();
        return this.unsafeRollover(writeIndex, generation, timeSeries);
    }

    public DataStream unsafeRollover(Index writeIndex, long generation, boolean timeSeries) {
        IndexMode indexMode = this.indexMode;
        if ((indexMode == null || indexMode == IndexMode.STANDARD) && timeSeries) {
            indexMode = IndexMode.TIME_SERIES;
        } else if (indexMode == IndexMode.TIME_SERIES && !timeSeries) {
            indexMode = null;
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(writeIndex);
        return new DataStream(this.name, backingIndices, generation, this.metadata, this.hidden, false, this.system, this.allowCustomRouting, indexMode, this.lifecycle);
    }

    public Tuple<String, Long> nextWriteIndexAndGeneration(Metadata clusterMetadata) {
        this.ensureNotReplicated();
        return this.unsafeNextWriteIndexAndGeneration(clusterMetadata);
    }

    public Tuple<String, Long> unsafeNextWriteIndexAndGeneration(Metadata clusterMetadata) {
        String newWriteIndexName;
        long generation = this.generation;
        long currentTimeMillis = this.timeProvider.getAsLong();
        while (clusterMetadata.hasIndexAbstraction(newWriteIndexName = DataStream.getDefaultBackingIndexName(this.getName(), ++generation, currentTimeMillis))) {
        }
        return Tuple.tuple((Object)newWriteIndexName, (Object)generation);
    }

    private void ensureNotReplicated() {
        if (this.replicated) {
            throw new IllegalArgumentException("data stream [" + this.name + "] cannot be rolled over, because it is a replicated data stream");
        }
    }

    public DataStream removeBackingIndex(Index index) {
        int backingIndexPosition = this.indices.indexOf(index);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", index.getName(), this.name));
        }
        if (this.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot remove backing index [%s] of data stream [%s] because it is the write index", index.getName(), this.name));
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.remove(index);
        assert (backingIndices.size() == this.indices.size() - 1);
        return new DataStream(this.name, backingIndices, this.generation + 1L, this.metadata, this.hidden, this.replicated, this.system, this.allowCustomRouting, this.indexMode, this.lifecycle);
    }

    public DataStream replaceBackingIndex(Index existingBackingIndex, Index newBackingIndex) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        int backingIndexPosition = backingIndices.indexOf(existingBackingIndex);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", existingBackingIndex.getName(), this.name));
        }
        if (this.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot replace backing index [%s] of data stream [%s] because it is the write index", existingBackingIndex.getName(), this.name));
        }
        backingIndices.set(backingIndexPosition, newBackingIndex);
        return new DataStream(this.name, backingIndices, this.generation + 1L, this.metadata, this.hidden, this.replicated, this.system, this.allowCustomRouting, this.indexMode, this.lifecycle);
    }

    public DataStream addBackingIndex(Metadata clusterMetadata, Index index) {
        DataStream parentDataStream = ((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getParentDataStream();
        if (parentDataStream != null) {
            if (parentDataStream.equals(this)) {
                return this;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] because it is already a backing index on data stream [%s]", index.getName(), this.getName(), parentDataStream.getName()));
        }
        IndexMetadata im = clusterMetadata.index(((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getWriteIndex());
        if (im.getAliases().size() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] until its alias(es) [%s] are removed", index.getName(), this.getName(), Strings.collectionToCommaDelimitedString(im.getAliases().keySet().stream().sorted().toList())));
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(0, index);
        assert (backingIndices.size() == this.indices.size() + 1);
        return new DataStream(this.name, backingIndices, this.generation + 1L, this.metadata, this.hidden, this.replicated, this.system, this.allowCustomRouting, this.indexMode, this.lifecycle);
    }

    public DataStream promoteDataStream() {
        return new DataStream(this.name, this.indices, this.getGeneration(), this.metadata, this.hidden, false, this.system, this.timeProvider, this.allowCustomRouting, this.indexMode, this.lifecycle);
    }

    @Nullable
    public DataStream snapshot(Collection<String> indicesInSnapshot) {
        ArrayList<Index> reconciledIndices = new ArrayList<Index>(this.indices);
        if (!reconciledIndices.removeIf(x -> !indicesInSnapshot.contains(x.getName()))) {
            return this;
        }
        if (reconciledIndices.size() == 0) {
            return null;
        }
        return new DataStream(this.name, reconciledIndices, this.generation, this.metadata == null ? null : new HashMap<String, Object>(this.metadata), this.hidden, this.replicated, this.system, this.allowCustomRouting, this.indexMode, this.lifecycle);
    }

    public List<Index> getIndicesPastRetention(Function<String, IndexMetadata> indexMetadataSupplier, LongSupplier nowSupplier) {
        if (this.lifecycle == null || this.lifecycle.getEffectiveDataRetention() == null) {
            return List.of();
        }
        List<Index> indicesPastRetention = this.getNonWriteIndicesOlderThan(this.lifecycle.getEffectiveDataRetention(), indexMetadataSupplier, this::isIndexManagedByDataStreamLifecycle, nowSupplier);
        return indicesPastRetention;
    }

    public List<Index> getNonWriteIndicesOlderThan(TimeValue age, Function<String, IndexMetadata> indexMetadataSupplier, @Nullable Predicate<IndexMetadata> indicesPredicate, LongSupplier nowSupplier) {
        ArrayList<Index> olderIndices = new ArrayList<Index>();
        for (Index index : this.indices) {
            long nowMillis;
            TimeValue indexLifecycleDate;
            IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
            if (indexMetadata == null || (indexLifecycleDate = this.getGenerationLifecycleDate(indexMetadata)) == null || (nowMillis = nowSupplier.getAsLong()) < indexLifecycleDate.getMillis() + age.getMillis() || indicesPredicate != null && !indicesPredicate.test(indexMetadata)) continue;
            olderIndices.add(index);
        }
        return olderIndices;
    }

    public boolean isIndexManagedByDataStreamLifecycle(Index index, Function<String, IndexMetadata> indexMetadataSupplier) {
        if (!this.indices.contains(index)) {
            return false;
        }
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null) {
            return false;
        }
        return this.isIndexManagedByDataStreamLifecycle(indexMetadata);
    }

    private boolean isIndexManagedByDataStreamLifecycle(IndexMetadata indexMetadata) {
        boolean preferIlm = IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings());
        if (indexMetadata.getLifecyclePolicyName() != null && this.lifecycle != null && this.lifecycle.isEnabled()) {
            return !preferIlm;
        }
        return this.lifecycle != null && this.lifecycle.isEnabled();
    }

    @Nullable
    public TimeValue getGenerationLifecycleDate(IndexMetadata indexMetadata) {
        if (indexMetadata.getIndex().equals(this.getWriteIndex())) {
            return null;
        }
        Long originationDate = indexMetadata.getSettings().getAsLong("index.lifecycle.origination_date", null);
        RolloverInfo rolloverInfo = indexMetadata.getRolloverInfos().get(this.getName());
        if (rolloverInfo != null) {
            return TimeValue.timeValueMillis((long)Objects.requireNonNullElseGet(originationDate, rolloverInfo::getTime));
        }
        return TimeValue.timeValueMillis((long)Objects.requireNonNullElseGet(originationDate, indexMetadata::getCreationDate));
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation) {
        return DataStream.getDefaultBackingIndexName(dataStreamName, generation, System.currentTimeMillis());
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation, long epochMillis) {
        return String.format(Locale.ROOT, ".ds-%s-%s-%06d", dataStreamName, DATE_FORMATTER.formatMillis(epochMillis), generation);
    }

    public DataStream(StreamInput in) throws IOException {
        this(in.readString(), DataStream.readIndices(in), in.readVLong(), in.readMap(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0) ? in.readBoolean() : false, in.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0) ? in.readOptionalEnum(IndexMode.class) : null, in.getTransportVersion().onOrAfter(TransportVersion.V_8_500_010) ? in.readOptionalWriteable(DataStreamLifecycle::new) : null);
    }

    static List<Index> readIndices(StreamInput in) throws IOException {
        in.readString();
        return in.readImmutableList(Index::new);
    }

    public static Diff<DataStream> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStream::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(TIMESTAMP_FIELD_NAME);
        out.writeList(this.indices);
        out.writeVLong(this.generation);
        out.writeGenericMap(this.metadata);
        out.writeBoolean(this.hidden);
        out.writeBoolean(this.replicated);
        out.writeBoolean(this.system);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0)) {
            out.writeBoolean(this.allowCustomRouting);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            out.writeOptionalEnum(this.indexMode);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_500_010)) {
            out.writeOptionalWriteable(this.lifecycle);
        }
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return (DataStream)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TIMESTAMP_FIELD_FIELD.getPreferredName()).startObject().field(NAME_FIELD.getPreferredName(), TIMESTAMP_FIELD_NAME).endObject();
        builder.xContentList(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(GENERATION_FIELD.getPreferredName(), this.generation);
        if (this.metadata != null) {
            builder.field(METADATA_FIELD.getPreferredName(), this.metadata);
        }
        builder.field(HIDDEN_FIELD.getPreferredName(), this.hidden);
        builder.field(REPLICATED_FIELD.getPreferredName(), this.replicated);
        builder.field(SYSTEM_FIELD.getPreferredName(), this.system);
        builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.allowCustomRouting);
        if (this.indexMode != null) {
            builder.field(INDEX_MODE.getPreferredName(), (Enum)this.indexMode);
        }
        if (this.lifecycle != null) {
            builder.field(LIFECYCLE.getPreferredName());
            this.lifecycle.toXContent(builder, params, rolloverConfiguration);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.name.equals(that.name) && this.indices.equals(that.indices) && this.generation == that.generation && Objects.equals(this.metadata, that.metadata) && this.hidden == that.hidden && this.system == that.system && this.replicated == that.replicated && this.allowCustomRouting == that.allowCustomRouting && this.indexMode == that.indexMode && Objects.equals(this.lifecycle, that.lifecycle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.indices, this.generation, this.metadata, this.hidden, this.system, this.replicated, this.allowCustomRouting, this.indexMode, this.lifecycle});
    }

    @Override
    public Index getWriteIndex(IndexRequest request, Metadata metadata) {
        if (request.opType() != DocWriteRequest.OpType.CREATE) {
            return this.getWriteIndex();
        }
        if (this.getIndexMode() != IndexMode.TIME_SERIES) {
            return this.getWriteIndex();
        }
        Object rawTimestamp = request.getRawTimestamp();
        Instant timestamp = rawTimestamp != null ? DataStream.getTimeStampFromRaw(rawTimestamp) : DataStream.getTimestampFromParser(request.source(), request.getContentType());
        Index result = this.selectTimeSeriesWriteIndex(timestamp = DataStream.getCanonicalTimestampBound(timestamp), metadata);
        if (result == null) {
            String timestampAsString = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(timestamp);
            String writeableIndicesString = this.getIndices().stream().map(metadata::index).map(IndexMetadata::getSettings).map(settings -> "[" + settings.get(IndexSettings.TIME_SERIES_START_TIME.getKey()) + "," + settings.get(IndexSettings.TIME_SERIES_END_TIME.getKey()) + "]").collect(Collectors.joining());
            throw new IllegalArgumentException("the document timestamp [" + timestampAsString + "] is outside of ranges of currently writable indices [" + writeableIndicesString + "]");
        }
        return result;
    }

    @Override
    public DataStream getParentDataStream() {
        return null;
    }

    private static Instant getTimeStampFromRaw(Object rawTimestamp) {
        try {
            if (rawTimestamp instanceof Long) {
                Long lTimestamp = (Long)rawTimestamp;
                return Instant.ofEpochMilli(lTimestamp);
            }
            if (rawTimestamp instanceof String) {
                String sTimestamp = (String)rawTimestamp;
                return DateFormatters.from(TIMESTAMP_FORMATTER.parse(sTimestamp), TIMESTAMP_FORMATTER.locale()).toInstant();
            }
            throw new IllegalArgumentException("timestamp [" + rawTimestamp + "] type [" + rawTimestamp.getClass() + "] error");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error get data stream timestamp field: " + e.getMessage(), e);
        }
    }

    private static Instant getTimestampFromParser(BytesReference source, XContentType xContentType) {
        Instant instant;
        block12: {
            XContent xContent = xContentType.xContent();
            XContentParser parser = xContent.createParser(TS_EXTRACT_CONFIG, (InputStream)source.streamInput());
            try {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                instant = switch (parser.nextToken()) {
                    case XContentParser.Token.VALUE_STRING -> DateFormatters.from(TIMESTAMP_FORMATTER.parse(parser.text()), TIMESTAMP_FORMATTER.locale()).toInstant();
                    case XContentParser.Token.VALUE_NUMBER -> Instant.ofEpochMilli(parser.longValue());
                    default -> throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] or [%s] but found [%s]", XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NUMBER, parser.currentToken()), new Object[0]);
                };
                if (parser == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error extracting data stream timestamp field: " + e.getMessage(), e);
                }
            }
            parser.close();
        }
        return instant;
    }

    public static Instant getCanonicalTimestampBound(Instant time) {
        return time.truncatedTo(ChronoUnit.SECONDS);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        ConstructingObjectParser tsFieldParser = new ConstructingObjectParser("timestamp_field", args -> {
            if (!TIMESTAMP_FIELD_NAME.equals(args[0])) {
                throw new IllegalArgumentException("unexpected timestamp field [" + args[0] + "]");
            }
            return TIMESTAMP_FIELD_NAME;
        });
        tsFieldParser.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject((f, v) -> {
            assert (v == TIMESTAMP_FIELD_NAME);
        }, (ContextParser)tsFieldParser, TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Index.fromXContent(p), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REPLICATED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SYSTEM_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_CUSTOM_ROUTING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_MODE);
        if (DataStreamLifecycle.isFeatureEnabled()) {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamLifecycle.fromXContent(p), LIFECYCLE);
        }
        TS_EXTRACT_CONFIG = XContentParserConfiguration.EMPTY.withFiltering(Set.of(TIMESTAMP_FIELD_NAME), null, false);
        TIMESTAMP_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||strict_date_optional_time||epoch_millis");
    }
}

