/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;

public class NodeLeftExecutor
implements ClusterStateTaskExecutor<Task> {
    private static final Logger logger = LogManager.getLogger(NodeLeftExecutor.class);
    private final AllocationService allocationService;

    public NodeLeftExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @SuppressForbidden(reason="maintaining ClusterState#transportVersions requires reading them")
    private static Map<String, TransportVersion> getTransportVersions(ClusterState clusterState) {
        return clusterState.transportVersions();
    }

    @Override
    public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<Task> batchExecutionContext) throws Exception {
        ClusterState initialState = batchExecutionContext.initialState();
        DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder(initialState.nodes());
        HashMap<String, TransportVersion> transportVersions = new HashMap<String, TransportVersion>(NodeLeftExecutor.getTransportVersions(initialState));
        boolean removed = false;
        for (ClusterStateTaskExecutor.TaskContext<Task> taskContext : batchExecutionContext.taskContexts()) {
            String reason;
            Task task = taskContext.getTask();
            if (initialState.nodes().nodeExists(task.node())) {
                remainingNodesBuilder.remove(task.node());
                transportVersions.remove(task.node().getId());
                removed = true;
                reason = task.reason();
            } else {
                logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
                reason = null;
            }
            taskContext.success(() -> {
                if (reason != null) {
                    logger.info("node-left: [{}] with reason [{}]", (Object)task.node().descriptionWithoutAttributes(), (Object)reason);
                }
                task.onClusterStateProcessed.run();
            });
        }
        if (!removed) {
            return initialState;
        }
        try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
            ClusterState remainingNodesClusterState = this.remainingNodesClusterState(initialState, remainingNodesBuilder, transportVersions);
            ClusterState ptasksDisassociatedState = PersistentTasksCustomMetadata.disassociateDeadNodes(remainingNodesClusterState);
            ClusterState clusterState = this.allocationService.disassociateDeadNodes(ptasksDisassociatedState, true, this.describeTasks(batchExecutionContext.taskContexts().stream().map(ClusterStateTaskExecutor.TaskContext::getTask).toList()));
            return clusterState;
        }
    }

    protected ClusterState remainingNodesClusterState(ClusterState currentState, DiscoveryNodes.Builder remainingNodesBuilder, Map<String, TransportVersion> transportVersions) {
        return ClusterState.builder(currentState).nodes(remainingNodesBuilder).transportVersions(transportVersions).build();
    }

    public record Task(DiscoveryNode node, String reason, Runnable onClusterStateProcessed) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.ERROR, "unexpected failure during [node-left]", (Throwable)e);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.node.appendDescriptionWithoutAttributes(stringBuilder);
            stringBuilder.append(" reason: ").append(this.reason);
            return stringBuilder.toString();
        }
    }
}

