/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal.node;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.support.AbstractClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;

public class NodeClient
extends AbstractClient {
    private Map<ActionType<? extends ActionResponse>, TransportAction<? extends ActionRequest, ? extends ActionResponse>> actions;
    private TaskManager taskManager;
    private Supplier<String> localNodeId;
    private Transport.Connection localConnection;
    private RemoteClusterService remoteClusterService;
    private NamedWriteableRegistry namedWriteableRegistry;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<ActionType<? extends ActionResponse>, TransportAction<? extends ActionRequest, ? extends ActionResponse>> actions, TaskManager taskManager, Supplier<String> localNodeId, Transport.Connection localConnection, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        this.actions = actions;
        this.taskManager = taskManager;
        this.localNodeId = localNodeId;
        this.localConnection = localConnection;
        this.remoteClusterService = remoteClusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    public List<String> getActionNames() {
        return this.actions.keySet().stream().map(ActionType::name).toList();
    }

    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        try {
            this.executeLocally(action, request, listener);
        }
        catch (IllegalArgumentException | IllegalStateException | TaskCancelledException e) {
            listener.onFailure(e);
        }
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        return this.taskManager.registerAndExecute("transport", this.transportAction(action), request, this.localConnection, new SafelyWrappedActionListener<Response>(listener));
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction<? extends ActionRequest, ? extends ActionResponse> transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias, Executor responseExecutor) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias, responseExecutor, true);
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    private record SafelyWrappedActionListener<Response>(ActionListener<Response> listener) implements ActionListener<Response>
    {
        @Override
        public void onResponse(Response response) {
            try {
                this.listener.onResponse(response);
            }
            catch (Exception e) {
                assert (false) : new AssertionError("callback must handle its own exceptions", e);
                throw e;
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.listener.onFailure(e);
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                assert (false) : new AssertionError("callback must handle its own exceptions", ex);
                throw ex;
            }
        }
    }
}

