/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;

public record ServerArgs(boolean daemonize, boolean quiet, Path pidFile, SecureSettings secrets, Settings nodeSettings, Path configDir) implements Writeable
{
    public ServerArgs {
        assert (pidFile == null || pidFile.isAbsolute());
        assert (secrets != null);
    }

    public ServerArgs(StreamInput in) throws IOException {
        this(in.readBoolean(), in.readBoolean(), ServerArgs.readPidFile(in), ServerArgs.readSecureSettingsFromStream(in), Settings.readSettingsFromStream(in), ServerArgs.resolvePath(in.readString()));
    }

    private static Path readPidFile(StreamInput in) throws IOException {
        String pidFile = in.readOptionalString();
        return pidFile == null ? null : ServerArgs.resolvePath(pidFile);
    }

    @SuppressForbidden(reason="reading local path from stream")
    private static Path resolvePath(String path) {
        return PathUtils.get((String)path, (String[])new String[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.daemonize);
        out.writeBoolean(this.quiet);
        out.writeOptionalString(this.pidFile == null ? null : this.pidFile.toString());
        out.writeString(this.secrets.getClass().getName());
        this.secrets.writeTo(out);
        this.nodeSettings.writeTo(out);
        out.writeString(this.configDir.toString());
    }

    private static SecureSettings readSecureSettingsFromStream(StreamInput in) throws IOException {
        String className = in.readString();
        try {
            return (SecureSettings)Class.forName(className).getConstructor(StreamInput.class).newInstance(in);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cfe) {
            throw new IllegalArgumentException("Invalid secrets implementation [" + className + "]", cfe);
        }
    }
}

